/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.Node;
import androidx.compose.ui.input.pointer.PointerId;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.ID;
import noria.ui.core.LayoutNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0010\u0018\u00002\u00020\u0001B#\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010!\u001a\u00020\u001d2\b\b\u0002\u0010\"\u001a\u00020#H\u0016R%\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Landroidx/compose/ui/input/pointer/NodeParent;", "", "resolvePointerInputModifierNode", "Lkotlin/Function1;", "Lnoria/ID;", "Lnoria/ui/core/LayoutNode;", "Landroidx/compose/ui/node/PointerInputModifierNode;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getResolvePointerInputModifierNode", "()Lkotlin/jvm/functions/Function1;", "children", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/input/pointer/Node;", "getChildren", "()Landroidx/compose/runtime/collection/MutableVector;", "dispatchInitialEventPass", "", "changes", "", "Landroidx/compose/ui/input/pointer/PointerId;", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "parentCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "internalPointerEvent", "Landroidx/compose/ui/input/pointer/InternalPointerEvent;", "dispatchMainEventPass", "dispatchFinalEventPass", "dispatchCancel", "", "clear", "removeDetachedPointerInputFilters", "cleanUpHits", "print", "depth", "", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nHitPathTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,633:1\n1182#2:634\n1161#2,2:635\n461#3,10:637\n493#3,10:647\n461#3,10:657\n493#3,10:667\n523#3:677\n48#3:678\n523#3:679\n461#3,10:680\n*S KotlinDebug\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/NodeParent\n*L\n140#1:634\n140#1:635,2\n160#1:637,10\n177#1:647,10\n191#1:657,10\n202#1:667,10\n218#1:677\n232#1:678\n233#1:679\n244#1:680,10\n*E\n"})
public class NodeParent {
    @NotNull
    private final Function1<ID, LayoutNode> resolvePointerInputModifierNode;
    @NotNull
    private final MutableVector<Node> children;

    public NodeParent(@NotNull Function1<? super ID, ? extends LayoutNode> resolvePointerInputModifierNode) {
        Intrinsics.checkNotNullParameter(resolvePointerInputModifierNode, (String)"resolvePointerInputModifierNode");
        this.resolvePointerInputModifierNode = resolvePointerInputModifierNode;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.children = new MutableVector((Object[])new Node[capacity$iv$iv], 0);
    }

    @NotNull
    public final Function1<ID, LayoutNode> getResolvePointerInputModifierNode() {
        return this.resolvePointerInputModifierNode;
    }

    @NotNull
    public final MutableVector<Node> getChildren() {
        return this.children;
    }

    public boolean dispatchInitialEventPass(@NotNull Map<PointerId, PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                dispatched = it.dispatchInitialEventPass(changes, parentCoordinates, internalPointerEvent) || dispatched;
            } while (++i$iv < size$iv);
        }
        return dispatched;
    }

    public boolean dispatchMainEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEachReversed = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = size$iv - 1;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                dispatched = it.dispatchMainEventPass(internalPointerEvent) || dispatched;
            } while (--i$iv >= 0);
        }
        return dispatched;
    }

    public boolean dispatchFinalEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        boolean dispatched = false;
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                dispatched = it.dispatchFinalEventPass(internalPointerEvent) || dispatched;
            } while (++i$iv < size$iv);
        }
        this.cleanUpHits(internalPointerEvent);
        return dispatched;
    }

    public void dispatchCancel() {
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEachReversed = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = size$iv - 1;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.dispatchCancel();
            } while (--i$iv >= 0);
        }
    }

    public final void clear() {
        this.children.clear();
    }

    public final void removeDetachedPointerInputFilters() {
        int index2 = 0;
        while (index2 < this.children.getSize()) {
            MutableVector<Node> this_$iv = this.children;
            boolean $i$f$get = false;
            Node child2 = (Node)this_$iv.getContent()[index2];
            LayoutNode latestPointerInputNode = (LayoutNode)this.resolvePointerInputModifierNode.invoke((Object)ID.box-impl((int)child2.getPointerInputNodeId-gZoixdo()));
            if (latestPointerInputNode == null) {
                this.children.removeAt(index2);
                child2.dispatchCancel();
                continue;
            }
            ++index2;
            child2.setPointerInputNode(latestPointerInputNode);
            child2.removeDetachedPointerInputFilters();
        }
    }

    public void cleanUpHits(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv.getSize() - 1; -1 < i; --i) {
            MutableVector<Node> this_$iv2 = this.children;
            boolean $i$f$get = false;
            Node child2 = (Node)this_$iv2.getContent()[i];
            if (!child2.isIn() && child2.getPointerIds().isEmpty() && child2.getChildren().isEmpty()) {
                this.children.removeAt(i);
                continue;
            }
            child2.setIn(false);
        }
    }

    public void print(int depth) {
        System.out.println((Object)"NodeParent");
        MutableVector<Node> this_$iv = this.children;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.print(depth + 1);
            } while (++i$iv < size$iv);
        }
    }

    public static /* synthetic */ void print$default(NodeParent nodeParent, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: print");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        nodeParent.print(n);
    }
}

