/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.DegreesKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.SkiaBackedCanvas;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u0007\u001a\u00020\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0086\b\u00f8\u0001\u0000\u001a.\u0010\u000b\u001a\u00020\b*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0086\b\u00f8\u0001\u0000\u001a\"\u0010\u0010\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012\u001a&\u0010\u0015\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012\u001a,\u0010\u0017\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012\"\u0019\u0010\u001a\u001a\u00060\u0006j\u0002`\u001b*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d*\n\u0010\u0005\"\u00020\u00062\u00020\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Canvas", "Landroidx/compose/ui/graphics/Canvas;", "image", "Landroidx/compose/ui/graphics/ImageBitmap;", "ActualCanvas", "NativeCanvas", "Lorg/jetbrains/skia/Canvas;", "withSave", "", "block", "Lkotlin/Function0;", "withSaveLayer", "bounds", "Landroidx/compose/ui/geometry/Rect;", "paint", "Landroidx/compose/ui/graphics/Paint;", "rotate", "degrees", "", "pivotX", "pivotY", "rotateRad", "radians", "scale", "sx", "sy", "nativeCanvas", "Landroidx/compose/ui/graphics/NativeCanvas;", "getNativeCanvas", "(Landroidx/compose/ui/graphics/Canvas;)Lorg/jetbrains/skia/Canvas;", "fleet.noria.ui"})
public final class CanvasKt {
    @NotNull
    public static final Canvas Canvas(@NotNull ImageBitmap image2) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        return CanvasKt.ActualCanvas(image2);
    }

    @NotNull
    public static final Canvas ActualCanvas(@NotNull ImageBitmap image2) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        Bitmap skiaBitmap = SkiaImageAsset_skikoKt.asSkiaBitmap(image2);
        if (!(!skiaBitmap.isImmutable())) {
            boolean bl = false;
            String string = "Cannot draw on immutable ImageBitmap";
            throw new IllegalArgumentException(string.toString());
        }
        return new SkiaBackedCanvas(new org.jetbrains.skia.Canvas(skiaBitmap, null, 2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withSave(@NotNull Canvas $this$withSave, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withSave, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withSave = false;
        try {
            $this$withSave.save();
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$withSave.restore();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withSaveLayer(@NotNull Canvas $this$withSaveLayer, @NotNull Rect bounds2, @NotNull Paint paint, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$withSaveLayer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bounds2, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withSaveLayer = false;
        try {
            $this$withSaveLayer.saveLayer(bounds2, paint);
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$withSaveLayer.restore();
            InlineMarker.finallyEnd((int)1);
        }
    }

    public static final void rotate(@NotNull Canvas $this$rotate, float degrees, float pivotX, float pivotY) {
        Intrinsics.checkNotNullParameter((Object)$this$rotate, (String)"<this>");
        if (degrees == 0.0f) {
            return;
        }
        $this$rotate.translate(pivotX, pivotY);
        $this$rotate.rotate(degrees);
        $this$rotate.translate(-pivotX, -pivotY);
    }

    public static final void rotateRad(@NotNull Canvas $this$rotateRad, float radians, float pivotX, float pivotY) {
        Intrinsics.checkNotNullParameter((Object)$this$rotateRad, (String)"<this>");
        CanvasKt.rotate($this$rotateRad, DegreesKt.degrees(radians), pivotX, pivotY);
    }

    public static /* synthetic */ void rotateRad$default(Canvas canvas, float f, float f2, float f3, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        CanvasKt.rotateRad(canvas, f, f2, f3);
    }

    public static final void scale(@NotNull Canvas $this$scale, float sx, float sy, float pivotX, float pivotY) {
        Intrinsics.checkNotNullParameter((Object)$this$scale, (String)"<this>");
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        $this$scale.translate(pivotX, pivotY);
        $this$scale.scale(sx, sy);
        $this$scale.translate(-pivotX, -pivotY);
    }

    public static /* synthetic */ void scale$default(Canvas canvas, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        CanvasKt.scale(canvas, f, f2, f3, f4);
    }

    @NotNull
    public static final org.jetbrains.skia.Canvas getNativeCanvas(@NotNull Canvas $this$nativeCanvas) {
        Intrinsics.checkNotNullParameter((Object)$this$nativeCanvas, (String)"<this>");
        return ((SkiaBackedCanvas)$this$nativeCanvas).getSkia();
    }
}

