/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.platform.ViewConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/text/selection/ClicksCounter;", "", "viewConfiguration", "Landroidx/compose/ui/platform/ViewConfiguration;", "clicksSlop", "", "<init>", "(Landroidx/compose/ui/platform/ViewConfiguration;F)V", "clicks", "", "getClicks", "()I", "setClicks", "(I)V", "prevClick", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "update", "", "event", "timeIsTolerable", "", "newClick", "positionIsTolerable", "fleet.noria.ui"})
public final class ClicksCounter {
    @NotNull
    private final ViewConfiguration viewConfiguration;
    private final float clicksSlop;
    private int clicks;
    @Nullable
    private PointerInputChange prevClick;

    public ClicksCounter(@NotNull ViewConfiguration viewConfiguration2, float clicksSlop) {
        Intrinsics.checkNotNullParameter((Object)viewConfiguration2, (String)"viewConfiguration");
        this.viewConfiguration = viewConfiguration2;
        this.clicksSlop = clicksSlop;
    }

    public final int getClicks() {
        return this.clicks;
    }

    public final void setClicks(int n) {
        this.clicks = n;
    }

    public final void update(@NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PointerInputChange currentPrevEvent = this.prevClick;
        this.clicks = currentPrevEvent != null && this.timeIsTolerable(currentPrevEvent, event) && this.positionIsTolerable(currentPrevEvent, event) ? ++this.clicks : 1;
        this.prevClick = event;
    }

    public final boolean timeIsTolerable(@NotNull PointerInputChange prevClick, @NotNull PointerInputChange newClick) {
        Intrinsics.checkNotNullParameter((Object)prevClick, (String)"prevClick");
        Intrinsics.checkNotNullParameter((Object)newClick, (String)"newClick");
        return newClick.getUptimeMillis() - prevClick.getUptimeMillis() < this.viewConfiguration.getDoubleTapTimeoutMillis();
    }

    public final boolean positionIsTolerable(@NotNull PointerInputChange prevClick, @NotNull PointerInputChange newClick) {
        Intrinsics.checkNotNullParameter((Object)prevClick, (String)"prevClick");
        Intrinsics.checkNotNullParameter((Object)newClick, (String)"newClick");
        return Offset.getDistance-impl(Offset.minus-MK-Hz9U(newClick.getPosition-F1C5BW0(), prevClick.getPosition-F1C5BW0())) < this.clicksSlop;
    }
}

