/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.InternalFoundationTextApi;
import androidx.compose.foundation.text.TextDelegateKt;
import androidx.compose.foundation.text.TextLayoutHelperKt;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextPainter;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.unit.UnpackedConstraintsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 D2\u00020\u0001:\u0001DBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020/J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010<\u001a\u00020/H\u0002J\"\u0010A\u001a\u00020B2\u0006\u0010?\u001a\u00020@2\u0006\u0010<\u001a\u00020/2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010BR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000b\u001a\u00020\f\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b \u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u00104\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010+R\u0011\u00106\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u001cR\u0011\u00108\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u001c\u00a8\u0006E"}, d2={"Landroidx/compose/foundation/text/TextDelegate;", "", "text", "Landroidx/compose/ui/text/AnnotatedString;", "style", "Landroidx/compose/ui/text/TextStyle;", "maxLines", "", "minLines", "softWrap", "", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "density", "Landroidx/compose/ui/unit/Density;", "fontFamilyResolver", "Landroidx/compose/ui/text/font/FontFamily$Resolver;", "placeholders", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/Placeholder;", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;Landroidx/compose/ui/text/TextStyle;IIZILandroidx/compose/ui/unit/Density;Landroidx/compose/ui/text/font/FontFamily$Resolver;Ljava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "getStyle", "()Landroidx/compose/ui/text/TextStyle;", "getMaxLines", "()I", "getMinLines", "getSoftWrap", "()Z", "getOverflow-gIe3tQ8", "I", "getDensity", "()Landroidx/compose/ui/unit/Density;", "getFontFamilyResolver", "()Landroidx/compose/ui/text/font/FontFamily$Resolver;", "getPlaceholders", "()Ljava/util/List;", "paragraphIntrinsics", "Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "getParagraphIntrinsics$fleet_noria_ui", "()Landroidx/compose/ui/text/MultiParagraphIntrinsics;", "setParagraphIntrinsics$fleet_noria_ui", "(Landroidx/compose/ui/text/MultiParagraphIntrinsics;)V", "intrinsicsLayoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getIntrinsicsLayoutDirection$fleet_noria_ui", "()Landroidx/compose/ui/unit/LayoutDirection;", "setIntrinsicsLayoutDirection$fleet_noria_ui", "(Landroidx/compose/ui/unit/LayoutDirection;)V", "nonNullIntrinsics", "getNonNullIntrinsics", "minIntrinsicWidth", "getMinIntrinsicWidth", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "layoutIntrinsics", "", "layoutDirection", "layoutText", "Landroidx/compose/ui/text/MultiParagraph;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "layout", "Landroidx/compose/ui/text/TextLayoutResult;", "prevResult", "Companion", "fleet.noria.ui"})
@InternalFoundationTextApi
@Stable
@SourceDebugExtension(value={"SMAP\nTextDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextDelegate.kt\nandroidx/compose/foundation/text/TextDelegate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,348:1\n1#2:349\n*E\n"})
public final class TextDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotatedString text;
    @NotNull
    private final TextStyle style;
    private final int maxLines;
    private final int minLines;
    private final boolean softWrap;
    private final int overflow;
    @NotNull
    private final Density density;
    @NotNull
    private final FontFamily.Resolver fontFamilyResolver;
    @NotNull
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    @Nullable
    private MultiParagraphIntrinsics paragraphIntrinsics;
    @Nullable
    private LayoutDirection intrinsicsLayoutDirection;

    private TextDelegate(AnnotatedString text2, TextStyle style, int maxLines, int minLines, boolean softWrap, int overflow, Density density, FontFamily.Resolver fontFamilyResolver2, List<AnnotatedString.Range<Placeholder>> placeholders) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver2, (String)"fontFamilyResolver");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        this.text = text2;
        this.style = style;
        this.maxLines = maxLines;
        this.minLines = minLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.fontFamilyResolver = fontFamilyResolver2;
        this.placeholders = placeholders;
        if (!(this.maxLines > 0)) {
            boolean $i$a$-require-TextDelegate$42 = false;
            String $i$a$-require-TextDelegate$42 = "no maxLines";
            throw new IllegalArgumentException($i$a$-require-TextDelegate$42.toString());
        }
        if (!(this.minLines > 0)) {
            boolean $i$a$-require-TextDelegate$52 = false;
            String $i$a$-require-TextDelegate$52 = "no minLines";
            throw new IllegalArgumentException($i$a$-require-TextDelegate$52.toString());
        }
        if (!(this.minLines <= this.maxLines)) {
            boolean bl = false;
            String string = "minLines greater than maxLines";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, int n, int n2, boolean bl, int n3, Density density, FontFamily.Resolver resolver, List list, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n4 & 8) != 0) {
            n2 = 1;
        }
        if ((n4 & 0x10) != 0) {
            bl = true;
        }
        if ((n4 & 0x20) != 0) {
            n3 = TextOverflow.Companion.getClip-gIe3tQ8();
        }
        if ((n4 & 0x100) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(annotatedString, textStyle, n, n2, bl, n3, density, resolver, list, null);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final int getMinLines() {
        return this.minLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    public final int getOverflow-gIe3tQ8() {
        return this.overflow;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final FontFamily.Resolver getFontFamilyResolver() {
        return this.fontFamilyResolver;
    }

    @NotNull
    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @Nullable
    public final MultiParagraphIntrinsics getParagraphIntrinsics$fleet_noria_ui() {
        return this.paragraphIntrinsics;
    }

    public final void setParagraphIntrinsics$fleet_noria_ui(@Nullable MultiParagraphIntrinsics multiParagraphIntrinsics) {
        this.paragraphIntrinsics = multiParagraphIntrinsics;
    }

    @Nullable
    public final LayoutDirection getIntrinsicsLayoutDirection$fleet_noria_ui() {
        return this.intrinsicsLayoutDirection;
    }

    public final void setIntrinsicsLayoutDirection$fleet_noria_ui(@Nullable LayoutDirection layoutDirection) {
        this.intrinsicsLayoutDirection = layoutDirection;
    }

    private final MultiParagraphIntrinsics getNonNullIntrinsics() {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.paragraphIntrinsics;
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutIntrinsics must be called first");
        }
        return multiParagraphIntrinsics;
    }

    public final int getMinIntrinsicWidth() {
        return TextDelegateKt.ceilToIntPx(this.getNonNullIntrinsics().getMinIntrinsicWidth());
    }

    public final int getMaxIntrinsicWidth() {
        return TextDelegateKt.ceilToIntPx(this.getNonNullIntrinsics().getMaxIntrinsicWidth());
    }

    public final void layoutIntrinsics(@NotNull LayoutDirection layoutDirection) {
        MultiParagraphIntrinsics intrinsics;
        MultiParagraphIntrinsics multiParagraphIntrinsics;
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        MultiParagraphIntrinsics localIntrinsics = this.paragraphIntrinsics;
        if (localIntrinsics == null || layoutDirection != this.intrinsicsLayoutDirection || localIntrinsics.getHasStaleResolvedFonts()) {
            this.intrinsicsLayoutDirection = layoutDirection;
            AnnotatedString annotatedString = this.text;
            TextStyle textStyle = TextStyleKt.resolveDefaults(this.style, layoutDirection);
            Density density = this.density;
            FontFamily.Resolver resolver = this.fontFamilyResolver;
            List<AnnotatedString.Range<Placeholder>> list = this.placeholders;
            multiParagraphIntrinsics = new MultiParagraphIntrinsics(annotatedString, textStyle, list, density, resolver);
        } else {
            multiParagraphIntrinsics = localIntrinsics;
        }
        this.paragraphIntrinsics = intrinsics = multiParagraphIntrinsics;
    }

    private final MultiParagraph layoutText(Constraints constraints, LayoutDirection layoutDirection) {
        this.layoutIntrinsics(layoutDirection);
        int minWidth = constraints.getMinWidth();
        boolean widthMatters = this.softWrap || TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8());
        int maxWidth = widthMatters && constraints.getHasBoundedWidth() ? constraints.getMaxWidth() : Integer.MAX_VALUE;
        boolean overwriteMaxLines = !this.softWrap && TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8());
        int finalMaxLines = overwriteMaxLines ? 1 : this.maxLines;
        int width2 = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((int)this.getMaxIntrinsicWidth(), (int)minWidth, (int)maxWidth);
        return new MultiParagraph(this.getNonNullIntrinsics(), new Constraints(0, width2, 0, constraints.getMaxHeight(), 5, null), finalMaxLines, TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8()));
    }

    @NotNull
    public final TextLayoutResult layout(@NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResult) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        if (prevResult != null && TextLayoutHelperKt.canReuse-5LixHlo(prevResult, this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.fontFamilyResolver, constraints)) {
            TextLayoutResult $this$layout_u24lambda_u243 = prevResult;
            boolean bl = false;
            return $this$layout_u24lambda_u243.copy-O0kMr_c(new TextLayoutInput($this$layout_u24lambda_u243.getLayoutInput().getText(), this.style, $this$layout_u24lambda_u243.getLayoutInput().getPlaceholders(), $this$layout_u24lambda_u243.getLayoutInput().getMaxLines(), $this$layout_u24lambda_u243.getLayoutInput().getSoftWrap(), $this$layout_u24lambda_u243.getLayoutInput().getOverflow-gIe3tQ8(), $this$layout_u24lambda_u243.getLayoutInput().getDensity(), $this$layout_u24lambda_u243.getLayoutInput().getLayoutDirection(), $this$layout_u24lambda_u243.getLayoutInput().getFontFamilyResolver(), constraints, null), UnpackedConstraintsKt.constrain-O0kMr_c(constraints, IntSizeKt.IntSize(TextDelegateKt.ceilToIntPx($this$layout_u24lambda_u243.getMultiParagraph().getWidth()), TextDelegateKt.ceilToIntPx($this$layout_u24lambda_u243.getMultiParagraph().getHeight()))));
        }
        MultiParagraph multiParagraph = this.layoutText(constraints, layoutDirection);
        long size2 = UnpackedConstraintsKt.constrain-O0kMr_c(constraints, IntSizeKt.IntSize(TextDelegateKt.ceilToIntPx(multiParagraph.getWidth()), TextDelegateKt.ceilToIntPx(multiParagraph.getHeight())));
        return new TextLayoutResult(new TextLayoutInput(this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.fontFamilyResolver, constraints, null), multiParagraph, size2, null);
    }

    public static /* synthetic */ TextLayoutResult layout$default(TextDelegate textDelegate, Constraints constraints, LayoutDirection layoutDirection, TextLayoutResult textLayoutResult, int n, Object object) {
        if ((n & 4) != 0) {
            textLayoutResult = null;
        }
        return textDelegate.layout(constraints, layoutDirection, textLayoutResult);
    }

    public /* synthetic */ TextDelegate(AnnotatedString text2, TextStyle style, int maxLines, int minLines, boolean softWrap, int overflow, Density density, FontFamily.Resolver fontFamilyResolver2, List placeholders, DefaultConstructorMarker $constructor_marker) {
        this(text2, style, maxLines, minLines, softWrap, overflow, density, fontFamilyResolver2, placeholders);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Landroidx/compose/foundation/text/TextDelegate$Companion;", "", "<init>", "()V", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "fleet.noria.ui"})
    public static final class Companion {
        private Companion() {
        }

        public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            TextPainter.INSTANCE.paint(canvas, textLayoutResult);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

