/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.PhysicalPaddingValues;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.UnpackedConstraintsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Landroidx/compose/foundation/layout/PhysicalPaddingValuesModifier;", "Landroidx/compose/ui/layout/LayoutModifier;", "paddingValues", "Landroidx/compose/foundation/layout/PhysicalPaddingValues;", "<init>", "(Landroidx/compose/foundation/layout/PhysicalPaddingValues;)V", "getPaddingValues", "()Landroidx/compose/foundation/layout/PhysicalPaddingValues;", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "measurable", "Landroidx/compose/ui/layout/Measurable;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "hashCode", "", "equals", "", "other", "", "fleet.noria.ui"})
final class PhysicalPaddingValuesModifier
implements LayoutModifier {
    @NotNull
    private final PhysicalPaddingValues paddingValues;

    public PhysicalPaddingValuesModifier(@NotNull PhysicalPaddingValues paddingValues) {
        Intrinsics.checkNotNullParameter((Object)paddingValues, (String)"paddingValues");
        this.paddingValues = paddingValues;
    }

    @NotNull
    public final PhysicalPaddingValues getPaddingValues() {
        return this.paddingValues;
    }

    @Override
    @NotNull
    public MeasureResult measure(@NotNull MeasureScope $this$measure, @NotNull Measurable measurable, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int horizontal = this.paddingValues.calculateLeftPadding($this$measure.getLayoutDirection()) + this.paddingValues.calculateRightPadding($this$measure.getLayoutDirection());
        int vertical = this.paddingValues.calculateTopPadding() + this.paddingValues.calculateBottomPadding();
        Placeable placeable = measurable.measure(UnpackedConstraintsKt.offset(constraints, -horizontal, -vertical));
        int width2 = UnpackedConstraintsKt.constrainWidth(constraints, placeable.getWidth() + horizontal);
        int height2 = UnpackedConstraintsKt.constrainHeight(constraints, placeable.getHeight() + vertical);
        return MeasureScope.DefaultImpls.layout$default($this$measure, width2, height2, null, (Function1)new Function1<Placeable.PlacementScope, Unit>(placeable, this, $this$measure){
            final /* synthetic */ Placeable $placeable;
            final /* synthetic */ PhysicalPaddingValuesModifier this$0;
            final /* synthetic */ MeasureScope $this_measure;
            {
                this.$placeable = $placeable;
                this.this$0 = $receiver;
                this.$this_measure = $receiver2;
                super(1);
            }

            public final void invoke(Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                Placeable.PlacementScope.place$default($this$layout, this.$placeable, this.this$0.getPaddingValues().calculateLeftPadding(this.$this_measure.getLayoutDirection()), this.this$0.getPaddingValues().calculateTopPadding(), 0.0f, 4, null);
            }
        }, 4, null);
    }

    public int hashCode() {
        return this.paddingValues.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        PhysicalPaddingValuesModifier physicalPaddingValuesModifier = other instanceof PhysicalPaddingValuesModifier ? (PhysicalPaddingValuesModifier)other : null;
        if (physicalPaddingValuesModifier == null) {
            return false;
        }
        PhysicalPaddingValuesModifier otherModifier = physicalPaddingValuesModifier;
        return Intrinsics.areEqual((Object)this.paddingValues, (Object)otherModifier.paddingValues);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        return LayoutModifier.DefaultImpls.minIntrinsicWidth(this, $this$minIntrinsicWidth, measurable, height2);
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        return LayoutModifier.DefaultImpls.minIntrinsicHeight(this, $this$minIntrinsicHeight, measurable, width2);
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        return LayoutModifier.DefaultImpls.maxIntrinsicWidth(this, $this$maxIntrinsicWidth, measurable, height2);
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        return LayoutModifier.DefaultImpls.maxIntrinsicHeight(this, $this$maxIntrinsicHeight, measurable, width2);
    }

    @Override
    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldIn(this, initial, operation);
    }

    @Override
    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldOut(this, initial, operation);
    }

    @Override
    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.any(this, predicate);
    }

    @Override
    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.all(this, predicate);
    }

    @Override
    @NotNull
    public Modifier then(@NotNull Modifier other) {
        return LayoutModifier.DefaultImpls.then(this, other);
    }
}

