/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.Direction;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Constraints;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/compose/foundation/layout/FillModifier;", "Landroidx/compose/ui/layout/LayoutModifier;", "direction", "Landroidx/compose/foundation/layout/Direction;", "fraction", "", "<init>", "(Landroidx/compose/foundation/layout/Direction;F)V", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "measurable", "Landroidx/compose/ui/layout/Measurable;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "equals", "", "other", "", "hashCode", "", "fleet.noria.ui"})
final class FillModifier
implements LayoutModifier {
    @NotNull
    private final Direction direction;
    private final float fraction;

    public FillModifier(@NotNull Direction direction, float fraction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.direction = direction;
        this.fraction = fraction;
    }

    @Override
    @NotNull
    public MeasureResult measure(@NotNull MeasureScope $this$measure, @NotNull Measurable measurable, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int minWidth = 0;
        int maxWidth = 0;
        if (constraints.getHasBoundedWidth() && this.direction != Direction.Vertical) {
            int width2;
            minWidth = width2 = RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)constraints.getMaxWidth() * this.fraction)), (int)constraints.getMinWidth(), (int)constraints.getMaxWidth());
            maxWidth = width2;
        } else {
            minWidth = constraints.getMinWidth();
            maxWidth = constraints.getMaxWidth();
        }
        int minHeight = 0;
        int maxHeight = 0;
        if (constraints.getHasBoundedHeight() && this.direction != Direction.Horizontal) {
            int height2;
            minHeight = height2 = RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)constraints.getMaxHeight() * this.fraction)), (int)constraints.getMinHeight(), (int)constraints.getMaxHeight());
            maxHeight = height2;
        } else {
            minHeight = constraints.getMinHeight();
            maxHeight = constraints.getMaxHeight();
        }
        Placeable placeable = measurable.measure(new Constraints(minWidth, maxWidth, minHeight, maxHeight));
        return MeasureScope.DefaultImpls.layout$default($this$measure, placeable.getWidth(), placeable.getHeight(), null, (Function1)new Function1<Placeable.PlacementScope, Unit>(placeable){
            final /* synthetic */ Placeable $placeable;
            {
                this.$placeable = $placeable;
                super(1);
            }

            public final void invoke(Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                Placeable.PlacementScope.placeRelative$default($this$layout, this.$placeable, 0, 0, 0.0f, 4, null);
            }
        }, 4, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FillModifier && this.direction == ((FillModifier)other).direction && this.fraction == ((FillModifier)other).fraction;
    }

    public int hashCode() {
        return this.direction.hashCode() * 31 + Float.hashCode(this.fraction);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        return LayoutModifier.DefaultImpls.minIntrinsicWidth(this, $this$minIntrinsicWidth, measurable, height2);
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        return LayoutModifier.DefaultImpls.minIntrinsicHeight(this, $this$minIntrinsicHeight, measurable, width2);
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        return LayoutModifier.DefaultImpls.maxIntrinsicWidth(this, $this$maxIntrinsicWidth, measurable, height2);
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        return LayoutModifier.DefaultImpls.maxIntrinsicHeight(this, $this$maxIntrinsicHeight, measurable, width2);
    }

    @Override
    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldIn(this, initial, operation);
    }

    @Override
    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldOut(this, initial, operation);
    }

    @Override
    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.any(this, predicate);
    }

    @Override
    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.all(this, predicate);
    }

    @Override
    @NotNull
    public Modifier then(@NotNull Modifier other) {
        return LayoutModifier.DefaultImpls.then(this, other);
    }
}

