/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.AlignmentLineProvider;
import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u0000 \u00142\u00020\u0001:\u0007\u0014\u0015\u0016\u0017\u0018\u0019\u001aB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H \u00a2\u0006\u0002\b\fJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\r\u001a\u00020\u000e8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0006\u001b\u001c\u001d\u001e\u001f \u00a8\u0006!"}, d2={"Landroidx/compose/foundation/layout/CrossAxisAlignment;", "", "<init>", "()V", "align", "", "size", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "placeable", "Landroidx/compose/ui/layout/Placeable;", "beforeCrossAxisAlignmentLine", "align$fleet_noria_ui", "isRelative", "", "isRelative$fleet_noria_ui", "()Z", "calculateAlignmentLinePosition", "calculateAlignmentLinePosition$fleet_noria_ui", "(Landroidx/compose/ui/layout/Placeable;)Ljava/lang/Integer;", "Companion", "CenterCrossAxisAlignment", "StartCrossAxisAlignment", "EndCrossAxisAlignment", "AlignmentLineCrossAxisAlignment", "VerticalCrossAxisAlignment", "HorizontalCrossAxisAlignment", "Landroidx/compose/foundation/layout/CrossAxisAlignment$AlignmentLineCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment$CenterCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment$EndCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment$HorizontalCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment$StartCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment$VerticalCrossAxisAlignment;", "fleet.noria.ui"})
@Immutable
public abstract class CrossAxisAlignment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CrossAxisAlignment Center = CenterCrossAxisAlignment.INSTANCE;
    @NotNull
    private static final CrossAxisAlignment Start = StartCrossAxisAlignment.INSTANCE;
    @NotNull
    private static final CrossAxisAlignment End = EndCrossAxisAlignment.INSTANCE;

    private CrossAxisAlignment() {
    }

    public abstract int align$fleet_noria_ui(int var1, @NotNull LayoutDirection var2, @NotNull Placeable var3, int var4);

    public boolean isRelative$fleet_noria_ui() {
        return false;
    }

    @Nullable
    public Integer calculateAlignmentLinePosition$fleet_noria_ui(@NotNull Placeable placeable) {
        Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
        return null;
    }

    public /* synthetic */ CrossAxisAlignment(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0004\b\u0010\u0010\u0011J-\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Landroidx/compose/foundation/layout/CrossAxisAlignment$AlignmentLineCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "alignmentLineProvider", "Landroidx/compose/foundation/layout/AlignmentLineProvider;", "<init>", "(Landroidx/compose/foundation/layout/AlignmentLineProvider;)V", "getAlignmentLineProvider", "()Landroidx/compose/foundation/layout/AlignmentLineProvider;", "isRelative", "", "isRelative$fleet_noria_ui", "()Z", "calculateAlignmentLinePosition", "", "placeable", "Landroidx/compose/ui/layout/Placeable;", "calculateAlignmentLinePosition$fleet_noria_ui", "(Landroidx/compose/ui/layout/Placeable;)Ljava/lang/Integer;", "align", "size", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "beforeCrossAxisAlignmentLine", "align$fleet_noria_ui", "fleet.noria.ui"})
    private static final class AlignmentLineCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        private final AlignmentLineProvider alignmentLineProvider;

        public AlignmentLineCrossAxisAlignment(@NotNull AlignmentLineProvider alignmentLineProvider) {
            Intrinsics.checkNotNullParameter((Object)alignmentLineProvider, (String)"alignmentLineProvider");
            super(null);
            this.alignmentLineProvider = alignmentLineProvider;
        }

        @NotNull
        public final AlignmentLineProvider getAlignmentLineProvider() {
            return this.alignmentLineProvider;
        }

        @Override
        public boolean isRelative$fleet_noria_ui() {
            return true;
        }

        @Override
        @NotNull
        public Integer calculateAlignmentLinePosition$fleet_noria_ui(@NotNull Placeable placeable) {
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return this.alignmentLineProvider.calculateAlignmentLinePosition(placeable);
        }

        @Override
        public int align$fleet_noria_ui(int size2, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            int n;
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            int alignmentLinePosition = this.alignmentLineProvider.calculateAlignmentLinePosition(placeable);
            if (alignmentLinePosition != Integer.MIN_VALUE) {
                int line = beforeCrossAxisAlignmentLine - alignmentLinePosition;
                n = layoutDirection == LayoutDirection.Rtl ? size2 - line : line;
            } else {
                n = 0;
            }
            return n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Landroidx/compose/foundation/layout/CrossAxisAlignment$CenterCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "<init>", "()V", "align", "", "size", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "placeable", "Landroidx/compose/ui/layout/Placeable;", "beforeCrossAxisAlignmentLine", "align$fleet_noria_ui", "fleet.noria.ui"})
    private static final class CenterCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        public static final CenterCrossAxisAlignment INSTANCE = new CenterCrossAxisAlignment();

        private CenterCrossAxisAlignment() {
            super(null);
        }

        @Override
        public int align$fleet_noria_ui(int size2, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return size2 / 2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u0015\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bR\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u001c"}, d2={"Landroidx/compose/foundation/layout/CrossAxisAlignment$Companion;", "", "<init>", "()V", "Center", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "getCenter$annotations", "getCenter", "()Landroidx/compose/foundation/layout/CrossAxisAlignment;", "Start", "getStart$annotations", "getStart", "End", "getEnd$annotations", "getEnd", "AlignmentLine", "alignmentLine", "Landroidx/compose/ui/layout/AlignmentLine;", "Relative", "alignmentLineProvider", "Landroidx/compose/foundation/layout/AlignmentLineProvider;", "Relative$fleet_noria_ui", "vertical", "Landroidx/compose/ui/Alignment$Vertical;", "vertical$fleet_noria_ui", "horizontal", "Landroidx/compose/ui/Alignment$Horizontal;", "horizontal$fleet_noria_ui", "fleet.noria.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CrossAxisAlignment getCenter() {
            return Center;
        }

        @Stable
        public static /* synthetic */ void getCenter$annotations() {
        }

        @NotNull
        public final CrossAxisAlignment getStart() {
            return Start;
        }

        @Stable
        public static /* synthetic */ void getStart$annotations() {
        }

        @NotNull
        public final CrossAxisAlignment getEnd() {
            return End;
        }

        @Stable
        public static /* synthetic */ void getEnd$annotations() {
        }

        @NotNull
        public final CrossAxisAlignment AlignmentLine(@NotNull AlignmentLine alignmentLine) {
            Intrinsics.checkNotNullParameter((Object)alignmentLine, (String)"alignmentLine");
            return new AlignmentLineCrossAxisAlignment(new AlignmentLineProvider.Value(alignmentLine));
        }

        @NotNull
        public final CrossAxisAlignment Relative$fleet_noria_ui(@NotNull AlignmentLineProvider alignmentLineProvider) {
            Intrinsics.checkNotNullParameter((Object)alignmentLineProvider, (String)"alignmentLineProvider");
            return new AlignmentLineCrossAxisAlignment(alignmentLineProvider);
        }

        @NotNull
        public final CrossAxisAlignment vertical$fleet_noria_ui(@NotNull Alignment.Vertical vertical) {
            Intrinsics.checkNotNullParameter((Object)vertical, (String)"vertical");
            return new VerticalCrossAxisAlignment(vertical);
        }

        @NotNull
        public final CrossAxisAlignment horizontal$fleet_noria_ui(@NotNull Alignment.Horizontal horizontal) {
            Intrinsics.checkNotNullParameter((Object)horizontal, (String)"horizontal");
            return new HorizontalCrossAxisAlignment(horizontal);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Landroidx/compose/foundation/layout/CrossAxisAlignment$EndCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "<init>", "()V", "align", "", "size", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "placeable", "Landroidx/compose/ui/layout/Placeable;", "beforeCrossAxisAlignmentLine", "align$fleet_noria_ui", "fleet.noria.ui"})
    private static final class EndCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        public static final EndCrossAxisAlignment INSTANCE = new EndCrossAxisAlignment();

        private EndCrossAxisAlignment() {
            super(null);
        }

        @Override
        public int align$fleet_noria_ui(int size2, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return layoutDirection == LayoutDirection.Ltr ? size2 : 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Landroidx/compose/foundation/layout/CrossAxisAlignment$HorizontalCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "horizontal", "Landroidx/compose/ui/Alignment$Horizontal;", "<init>", "(Landroidx/compose/ui/Alignment$Horizontal;)V", "getHorizontal", "()Landroidx/compose/ui/Alignment$Horizontal;", "align", "", "size", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "placeable", "Landroidx/compose/ui/layout/Placeable;", "beforeCrossAxisAlignmentLine", "align$fleet_noria_ui", "fleet.noria.ui"})
    private static final class HorizontalCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        private final Alignment.Horizontal horizontal;

        public HorizontalCrossAxisAlignment(@NotNull Alignment.Horizontal horizontal) {
            Intrinsics.checkNotNullParameter((Object)horizontal, (String)"horizontal");
            super(null);
            this.horizontal = horizontal;
        }

        @NotNull
        public final Alignment.Horizontal getHorizontal() {
            return this.horizontal;
        }

        @Override
        public int align$fleet_noria_ui(int size2, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return this.horizontal.align(0, size2, layoutDirection);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Landroidx/compose/foundation/layout/CrossAxisAlignment$StartCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "<init>", "()V", "align", "", "size", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "placeable", "Landroidx/compose/ui/layout/Placeable;", "beforeCrossAxisAlignmentLine", "align$fleet_noria_ui", "fleet.noria.ui"})
    private static final class StartCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        public static final StartCrossAxisAlignment INSTANCE = new StartCrossAxisAlignment();

        private StartCrossAxisAlignment() {
            super(null);
        }

        @Override
        public int align$fleet_noria_ui(int size2, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return layoutDirection == LayoutDirection.Ltr ? 0 : size2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Landroidx/compose/foundation/layout/CrossAxisAlignment$VerticalCrossAxisAlignment;", "Landroidx/compose/foundation/layout/CrossAxisAlignment;", "vertical", "Landroidx/compose/ui/Alignment$Vertical;", "<init>", "(Landroidx/compose/ui/Alignment$Vertical;)V", "getVertical", "()Landroidx/compose/ui/Alignment$Vertical;", "align", "", "size", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "placeable", "Landroidx/compose/ui/layout/Placeable;", "beforeCrossAxisAlignmentLine", "align$fleet_noria_ui", "fleet.noria.ui"})
    private static final class VerticalCrossAxisAlignment
    extends CrossAxisAlignment {
        @NotNull
        private final Alignment.Vertical vertical;

        public VerticalCrossAxisAlignment(@NotNull Alignment.Vertical vertical) {
            Intrinsics.checkNotNullParameter((Object)vertical, (String)"vertical");
            super(null);
            this.vertical = vertical;
        }

        @NotNull
        public final Alignment.Vertical getVertical() {
            return this.vertical;
        }

        @Override
        public int align$fleet_noria_ui(int size2, @NotNull LayoutDirection layoutDirection, @NotNull Placeable placeable, int beforeCrossAxisAlignmentLine) {
            Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
            Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
            return this.vertical.align(0, size2);
        }
    }
}

