/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import androidx.compose.foundation.CheckScrollableContainerConstraintsKt;
import androidx.compose.foundation.ScrollState;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Constraints;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001c\u0010\u0018\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u001c\u0010\u001a\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001c\u0010\u001b\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u0014H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000b\u00a8\u0006&"}, d2={"Landroidx/compose/foundation/ScrollingLayoutModifier;", "Landroidx/compose/ui/layout/LayoutModifier;", "scrollerState", "Landroidx/compose/foundation/ScrollState;", "isReversed", "", "isVertical", "<init>", "(Landroidx/compose/foundation/ScrollState;ZZ)V", "getScrollerState", "()Landroidx/compose/foundation/ScrollState;", "()Z", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "measurable", "Landroidx/compose/ui/layout/Measurable;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "minIntrinsicWidth", "", "Landroidx/compose/ui/layout/IntrinsicMeasureScope;", "Landroidx/compose/ui/layout/IntrinsicMeasurable;", "height", "minIntrinsicHeight", "width", "maxIntrinsicWidth", "maxIntrinsicHeight", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "fleet.noria.ui"})
final class ScrollingLayoutModifier
implements LayoutModifier {
    @NotNull
    private final ScrollState scrollerState;
    private final boolean isReversed;
    private final boolean isVertical;

    public ScrollingLayoutModifier(@NotNull ScrollState scrollerState, boolean isReversed, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)scrollerState, (String)"scrollerState");
        this.scrollerState = scrollerState;
        this.isReversed = isReversed;
        this.isVertical = isVertical;
    }

    @NotNull
    public final ScrollState getScrollerState() {
        return this.scrollerState;
    }

    public final boolean isReversed() {
        return this.isReversed;
    }

    public final boolean isVertical() {
        return this.isVertical;
    }

    @Override
    @NotNull
    public MeasureResult measure(@NotNull MeasureScope $this$measure, @NotNull Measurable measurable, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        CheckScrollableContainerConstraintsKt.checkScrollableContainerConstraints(constraints, this.isVertical ? Orientation.Vertical : Orientation.Horizontal);
        int n = this.isVertical ? Integer.MAX_VALUE : constraints.getMaxHeight();
        int n2 = this.isVertical ? constraints.getMaxWidth() : Integer.MAX_VALUE;
        Constraints childConstraints2 = Constraints.copy$default(constraints, 0, n2, 0, n, 5, null);
        Placeable placeable = measurable.measure(childConstraints2);
        int width2 = RangesKt.coerceAtMost((int)placeable.getWidth(), (int)constraints.getMaxWidth());
        int height2 = RangesKt.coerceAtMost((int)placeable.getHeight(), (int)constraints.getMaxHeight());
        int scrollHeight = placeable.getHeight() - height2;
        int scrollWidth = placeable.getWidth() - width2;
        int side = this.isVertical ? scrollHeight : scrollWidth;
        this.scrollerState.setMaxValue$fleet_noria_ui(side);
        this.scrollerState.setViewportSize$fleet_noria_ui(this.isVertical ? height2 : width2);
        return MeasureScope.DefaultImpls.layout$default($this$measure, width2, height2, null, (Function1)new Function1<Placeable.PlacementScope, Unit>(this, side, placeable){
            final /* synthetic */ ScrollingLayoutModifier this$0;
            final /* synthetic */ int $side;
            final /* synthetic */ Placeable $placeable;
            {
                this.this$0 = $receiver;
                this.$side = $side;
                this.$placeable = $placeable;
                super(1);
            }

            public final void invoke(Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                int scroll2 = RangesKt.coerceIn((int)this.this$0.getScrollerState().getValue(), (int)0, (int)this.$side);
                int absScroll = this.this$0.isReversed() ? scroll2 - this.$side : -scroll2;
                int xOffset = this.this$0.isVertical() ? 0 : absScroll;
                int yOffset = this.this$0.isVertical() ? absScroll : 0;
                Placeable.PlacementScope.placeRelativeWithLayer$default($this$layout, this.$placeable, xOffset, yOffset, 0.0f, null, 12, null);
            }
        }, 4, null);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.isVertical ? measurable.minIntrinsicWidth(Integer.MAX_VALUE) : measurable.minIntrinsicWidth(height2);
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.isVertical ? measurable.minIntrinsicHeight(width2) : measurable.minIntrinsicHeight(Integer.MAX_VALUE);
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.isVertical ? measurable.maxIntrinsicWidth(Integer.MAX_VALUE) : measurable.maxIntrinsicWidth(height2);
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        return this.isVertical ? measurable.maxIntrinsicHeight(width2) : measurable.maxIntrinsicHeight(Integer.MAX_VALUE);
    }

    @NotNull
    public final ScrollState component1() {
        return this.scrollerState;
    }

    public final boolean component2() {
        return this.isReversed;
    }

    public final boolean component3() {
        return this.isVertical;
    }

    @NotNull
    public final ScrollingLayoutModifier copy(@NotNull ScrollState scrollerState, boolean isReversed, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)scrollerState, (String)"scrollerState");
        return new ScrollingLayoutModifier(scrollerState, isReversed, isVertical);
    }

    public static /* synthetic */ ScrollingLayoutModifier copy$default(ScrollingLayoutModifier scrollingLayoutModifier, ScrollState scrollState2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            scrollState2 = scrollingLayoutModifier.scrollerState;
        }
        if ((n & 2) != 0) {
            bl = scrollingLayoutModifier.isReversed;
        }
        if ((n & 4) != 0) {
            bl2 = scrollingLayoutModifier.isVertical;
        }
        return scrollingLayoutModifier.copy(scrollState2, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "ScrollingLayoutModifier(scrollerState=" + this.scrollerState + ", isReversed=" + this.isReversed + ", isVertical=" + this.isVertical + ")";
    }

    public int hashCode() {
        int result2 = this.scrollerState.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isReversed);
        result2 = result2 * 31 + Boolean.hashCode(this.isVertical);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScrollingLayoutModifier)) {
            return false;
        }
        ScrollingLayoutModifier scrollingLayoutModifier = (ScrollingLayoutModifier)other;
        if (!Intrinsics.areEqual((Object)this.scrollerState, (Object)scrollingLayoutModifier.scrollerState)) {
            return false;
        }
        if (this.isReversed != scrollingLayoutModifier.isReversed) {
            return false;
        }
        return this.isVertical == scrollingLayoutModifier.isVertical;
    }

    @Override
    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldIn(this, initial, operation);
    }

    @Override
    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return LayoutModifier.DefaultImpls.foldOut(this, initial, operation);
    }

    @Override
    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.any(this, predicate);
    }

    @Override
    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return LayoutModifier.DefaultImpls.all(this, predicate);
    }

    @Override
    @NotNull
    public Modifier then(@NotNull Modifier other) {
        return LayoutModifier.DefaultImpls.then(this, other);
    }
}

