/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B9\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0010\u0010\u0010\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001f"}, d2={"Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "keyframes", "", "", "Lkotlin/Pair;", "Landroidx/compose/animation/core/Easing;", "durationMillis", "delayMillis", "<init>", "(Ljava/util/Map;II)V", "getDurationMillis", "()I", "getDelayMillis", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "init", "", "value", "(Landroidx/compose/animation/core/AnimationVector;)V", "getVelocityFromNanos", "fleet.noria.ui"})
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final Map<Integer, Pair<V, Easing>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    private V valueVector;
    private V velocityVector;

    public VectorizedKeyframesSpec(@NotNull Map<Integer, ? extends Pair<? extends V, ? extends Easing>> keyframes, int durationMillis, int delayMillis) {
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
    }

    public /* synthetic */ VectorizedKeyframesSpec(Map map, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(map, n, n2);
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.access$clampPlayTime(this, playTimeMillis);
        if (this.keyframes.containsKey(clampedPlayTime)) {
            return (V)((AnimationVector)((Pair)MapsKt.getValue(this.keyframes, (Object)clampedPlayTime)).getFirst());
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        int startTime2 = 0;
        Object startVal = initialValue;
        Object endVal = targetValue;
        int endTime = this.getDurationMillis();
        Easing easing = EasingKt.getLinearEasing();
        for (Map.Entry<Integer, Pair<V, Easing>> entry : this.keyframes.entrySet()) {
            int timestamp = ((Number)entry.getKey()).intValue();
            Pair<V, Easing> value2 = entry.getValue();
            if (clampedPlayTime > timestamp && timestamp >= startTime2) {
                startTime2 = timestamp;
                startVal = (AnimationVector)value2.getFirst();
                easing = (Easing)value2.getSecond();
                continue;
            }
            if (clampedPlayTime >= timestamp || timestamp > endTime) continue;
            endTime = timestamp;
            endVal = (AnimationVector)value2.getFirst();
        }
        float fraction = easing.transform((float)(clampedPlayTime - startTime2) / (float)(endTime - startTime2));
        this.init(initialValue);
        int n = ((AnimationVector)startVal).getSize$fleet_noria_ui();
        for (int i = 0; i < n; ++i) {
            V v = this.valueVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v = null;
            }
            ((AnimationVector)v).set$fleet_noria_ui(i, VectorConvertersKt.lerp(((AnimationVector)startVal).get$fleet_noria_ui(i), ((AnimationVector)endVal).get$fleet_noria_ui(i), fraction));
        }
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v = null;
        }
        return v;
    }

    private final void init(V value2) {
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(value2);
            this.velocityVector = AnimationVectorsKt.newInstance(value2);
        }
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.access$clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime <= 0L) {
            return initialVelocity;
        }
        V startNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime - 1L, initialValue, targetValue, initialVelocity);
        V endNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime, initialValue, targetValue, initialVelocity);
        this.init(initialValue);
        int n = ((AnimationVector)startNum).getSize$fleet_noria_ui();
        for (int i = 0; i < n; ++i) {
            V v = this.velocityVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v = null;
            }
            ((AnimationVector)v).set$fleet_noria_ui(i, (((AnimationVector)startNum).get$fleet_noria_ui(i) - ((AnimationVector)endNum).get$fleet_noria_ui(i)) * 1000.0f);
        }
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        return v;
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.getDurationNanos(this, initialValue, targetValue, initialVelocity);
    }

    @Override
    public boolean isInfinite() {
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.isInfinite(this);
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.getEndVelocity(this, initialValue, targetValue, initialVelocity);
    }
}

