/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.parsing;

import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.parsing.JSTagOrGenericUtil;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public final class JSTagOrGenericsFlowHelper {
    public static boolean parseFlowParameterList(JSTagOrGenericUtil.State state) {
        IElementType next = state.getCurrentToken();
        int balance = 1;
        if (next == JSTokenTypes.LBRACE || next == JSTokenTypes.LBRACKET) {
            if (next == JSTokenTypes.LBRACKET) {
                return true;
            }
            return JSTagOrGenericsFlowHelper.isFlowGenericObjectDestructuringLambda(state);
        }
        boolean wasIdentifier = false;
        if (next == JSTokenTypes.IDENTIFIER) {
            wasIdentifier = true;
            next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
            if (next == JSTokenTypes.QUEST) {
                next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
            }
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA) {
            return wasIdentifier;
        }
        if (next == JSTokenTypes.LPAR) {
            return true;
        }
        boolean isLt = next == JSTokenTypes.LT;
        next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
        if (isLt && JSTagOrGenericUtil.startsWithDiv(next)) {
            return false;
        }
        if (next != JSTokenTypes.LT) {
            while (balance > 0 && next != null) {
                if (next == JSTokenTypes.LPAR) {
                    ++balance;
                }
                if (next == JSTokenTypes.RPAR) {
                    --balance;
                }
                isLt = next == JSTokenTypes.LT;
                next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
                if (!isLt || !JSTagOrGenericUtil.startsWithDiv(next)) continue;
                return false;
            }
        }
        if (next != JSTokenTypes.LT) {
            return true;
        }
        next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
        return JSTagOrGenericsFlowHelper.checkFlowToken(state, next);
    }

    private static boolean isFlowGenericObjectDestructuringLambda(JSTagOrGenericUtil.State state) {
        IElementType next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
        int balance = 1;
        while (next != null) {
            if (next == JSTokenTypes.LBRACE) {
                ++balance;
            }
            if (next == JSTokenTypes.RBRACE && --balance == 0) break;
            next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
        }
        if (balance != 0) {
            return true;
        }
        next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
        if (next != JSTokenTypes.RPAR) {
            return true;
        }
        next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
        return JSTokenTypes.ARROWS.contains(next);
    }

    private static boolean checkFlowToken(JSTagOrGenericUtil.State state, IElementType next) {
        if (next != JSTokenTypes.IDENTIFIER) {
            return next != JSTokenTypes.REGEXP_LITERAL;
        }
        next = JSTagOrGenericsFlowHelper.skipCommentsAndWhitespaces(state);
        return next != JSTokenTypes.COMMA && next != JSTokenTypes.EXTENDS_KEYWORD && next != JSTokenTypes.GT;
    }

    @Nullable
    private static IElementType skipCommentsAndWhitespaces(JSTagOrGenericUtil.State state) {
        state.advanceLexer();
        return state.getCurrentToken();
    }
}

