/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.javascript.JSKeywordSets;
import fleet.com.intellij.lang.javascript.JSTokenTypes;
import fleet.com.intellij.lang.javascript.parsing.ExpressionParser;
import fleet.com.intellij.lang.javascript.parsing.FunctionParser;
import fleet.com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.util.ThreeState;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSArrowFunctionDetector {
    public static final JSArrowFunctionDetector INSTANCE = new JSArrowFunctionDetector();
    private static final Map<IElementType, IElementType> PARENS = new HashMap<IElementType, IElementType>();
    private static final Map<IElementType, IElementType> GENERIC_PARENS;

    private JSArrowFunctionDetector() {
    }

    public boolean isArrowFunctionExpression(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        PsiBuilder.Marker marker = builder.mark();
        boolean result = this.checkArrowFunctionExpression(builder, parser);
        marker.rollbackTo();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkArrowFunctionExpression(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        this.skipAngleBrackets(builder);
        if (builder.getTokenType() != JSTokenTypes.LPAR) {
            return false;
        }
        IElementType next = builder.lookAhead(1);
        if (!parser.isValidFirstParameterStart(next)) {
            return false;
        }
        builder.advanceLexer();
        if (next == JSTokenTypes.RPAR) {
            builder.advanceLexer();
            if (builder.getTokenType() == JSTokenTypes.COLON) {
                return true;
            }
        } else {
            while (!builder.eof()) {
                ThreeState subResult;
                IElementType tokenType = builder.getTokenType();
                if (tokenType == JSTokenTypes.RPAR) {
                    builder.advanceLexer();
                    break;
                }
                if (tokenType == JSTokenTypes.COMMA) {
                    if (builder.lookAhead(1) == JSTokenTypes.EQ) {
                        return true;
                    }
                    builder.advanceLexer();
                }
                if ((subResult = this.checkCommaSeparatedListElement(builder, parser)) == ThreeState.UNSURE) continue;
                return subResult.toBoolean();
            }
        }
        Boolean data = (Boolean)builder.getUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING);
        try {
            builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)true);
            if (builder.getTokenType() == JSTokenTypes.COLON && !((JSPsiTypeParser)parser.myJavaScriptParser.getTypeParser()).tryParseArrowFunctionReturnType()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            builder.putUserData(ExpressionParser.PROHIBIT_TOKEN_REMAPPING, (Object)data);
        }
        return JSTokenTypes.ARROWS.contains(builder.getTokenType());
    }

    @NotNull
    private ThreeState checkCommaSeparatedListElement(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        boolean seenEquals = false;
        boolean seenTypeColon = false;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (PARENS.containsKey(tokenType)) {
                if (this.skipParentheses(builder, PARENS)) continue;
                return ThreeState.NO;
            }
            if (seenTypeColon && tokenType == JSTokenTypes.LT) {
                if (this.skipParentheses(builder, GENERIC_PARENS)) continue;
                return ThreeState.NO;
            }
            if (tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR) break;
            if (seenEquals) {
                builder.advanceLexer();
                continue;
            }
            if (tokenType == JSTokenTypes.EQ) {
                seenEquals = true;
            } else if (tokenType == JSTokenTypes.QUEST) {
                IElementType lookahead = builder.lookAhead(1);
                if (lookahead == JSTokenTypes.COLON || lookahead == JSTokenTypes.EQ || lookahead == JSTokenTypes.COMMA || lookahead == JSTokenTypes.RPAR) {
                    return ThreeState.YES;
                }
                if (!seenTypeColon || !parser.supportsColonTypeCast()) {
                    return ThreeState.NO;
                }
            } else if (tokenType == JSTokenTypes.COLON) {
                if (!parser.supportsColonTypeCast()) {
                    return ThreeState.YES;
                }
                seenTypeColon = true;
            } else {
                if (!seenTypeColon && tokenType == JSTokenTypes.AT) {
                    return ThreeState.YES;
                }
                if (!seenTypeColon && tokenType != JSTokenTypes.DOT_DOT_DOT && !JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                    return ThreeState.NO;
                }
            }
            builder.advanceLexer();
        }
        return ThreeState.UNSURE;
    }

    public boolean isArrowFunctionType(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        PsiBuilder.Marker marker = builder.mark();
        boolean result = this.checkArrowFunctionType(builder, parser);
        marker.rollbackTo();
        return result;
    }

    public boolean checkArrowFunctionType(@NotNull PsiBuilder builder, @NotNull FunctionParser<?> parser) {
        ThreeState state;
        if (builder.getTokenType() == JSTokenTypes.LT) {
            return true;
        }
        if (builder.getTokenType() != JSTokenTypes.LPAR) {
            return false;
        }
        IElementType next = builder.lookAhead(1);
        if (!parser.isValidFirstParameterStart(next)) {
            return false;
        }
        if (next == JSTokenTypes.RPAR || next == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        builder.advanceLexer();
        boolean foundParameter = false;
        while (!builder.eof() && parser.myJavaScriptParser.isIdentifierName(builder.getTokenType())) {
            builder.advanceLexer();
            foundParameter = true;
        }
        if ((builder.getTokenType() == JSTokenTypes.LBRACE || builder.getTokenType() == JSTokenTypes.LBRACKET) && (state = this.skipAndCheckUnionOrIntersection(builder)) == ThreeState.NO) {
            builder.advanceLexer();
            foundParameter = true;
        }
        if (!foundParameter) {
            return false;
        }
        next = builder.getTokenType();
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA || next == JSTokenTypes.QUEST || next == JSTokenTypes.EQ) {
            return true;
        }
        if (next != JSTokenTypes.RPAR) {
            return false;
        }
        builder.advanceLexer();
        return JSTokenTypes.ARROWS.contains(builder.getTokenType());
    }

    private void skipAngleBrackets(@NotNull PsiBuilder builder) {
        if (builder.getTokenType() == JSTokenTypes.LT) {
            builder.advanceLexer();
            int balance = 1;
            while (!builder.eof()) {
                IElementType tokenType = builder.getTokenType();
                if (tokenType == JSTokenTypes.LT) {
                    ++balance;
                } else if (tokenType == JSTokenTypes.GT) {
                    --balance;
                }
                builder.advanceLexer();
                if (balance != 0) continue;
                break;
            }
        }
    }

    private boolean skipParentheses(@NotNull PsiBuilder builder, @NotNull Map<IElementType, IElementType> parens) {
        ArrayDeque<IElementType> leftParens = new ArrayDeque<IElementType>();
        IElementType firstToken = builder.getTokenType();
        assert (parens.containsKey(firstToken));
        leftParens.push(firstToken);
        builder.advanceLexer();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == parens.get(leftParens.peek())) {
                leftParens.pop();
            } else {
                if (parens.containsValue(tokenType)) {
                    return false;
                }
                if (parens.containsKey(tokenType)) {
                    leftParens.push(tokenType);
                }
            }
            builder.advanceLexer();
            if (!leftParens.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private ThreeState skipAndCheckUnionOrIntersection(@NotNull PsiBuilder builder) {
        IElementType lpar = builder.getTokenType();
        IElementType rpar = PARENS.get(lpar);
        boolean hasUnionOrIntersection = false;
        builder.advanceLexer();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == rpar) {
                return ThreeState.fromBoolean((boolean)hasUnionOrIntersection);
            }
            if (PARENS.containsValue(tokenType)) {
                return ThreeState.UNSURE;
            }
            if (tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.AND) {
                hasUnionOrIntersection = true;
            }
            if (PARENS.containsKey(tokenType)) {
                ThreeState isUnionOrIntersectionInner = this.skipAndCheckUnionOrIntersection(builder);
                if (isUnionOrIntersectionInner == ThreeState.UNSURE) {
                    return ThreeState.UNSURE;
                }
                hasUnionOrIntersection |= isUnionOrIntersectionInner == ThreeState.YES;
            }
            builder.advanceLexer();
        }
        return ThreeState.UNSURE;
    }

    static {
        PARENS.put(JSTokenTypes.LPAR, JSTokenTypes.RPAR);
        PARENS.put(JSTokenTypes.LBRACE, JSTokenTypes.RBRACE);
        PARENS.put(JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET);
        PARENS.put(JSTokenTypes.LBRACE_OR, JSTokenTypes.OR_RBRACE);
        GENERIC_PARENS = new HashMap<IElementType, IElementType>();
        GENERIC_PARENS.put(JSTokenTypes.LT, JSTokenTypes.GT);
        GENERIC_PARENS.putAll(PARENS);
    }
}

