/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.javascript;

import fleet.com.intellij.openapi.progress.ProgressManager;
import fleet.com.intellij.openapi.util.Ref;
import fleet.com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J8\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rJ0\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rH\u0007J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\rH\u0007J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0007J\u0018\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u0007H\u0003J\u0016\u0010*\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lfleet/com/intellij/lang/javascript/JSStringUtil;", "", "()V", "EXT_UNICODE_CHAR", "Ljava/util/regex/Pattern;", "UNICODE_CHAR", "isCaseSeparator", "", "codePoint", "", "isRegularDigit", "isStartedWithQuote", "text", "", "parseStringCharacters", "chars", "outChars", "Ljava/lang/StringBuilder;", "sourceOffsetsRef", "Lfleet/com/intellij/openapi/util/Ref;", "", "regExp", "escapeBacktick", "replaceUnicodeEscapeSequences", "stringUtilReplaceUnicodeEscapeSequences", "toCamelCase", "str", "toKebabCase", "toSeparatorBasedCase", "separator", "", "noSeparatorBeforeDigit", "noSeparatorBetweenDigitAndLowercase", "splitConsecutiveUppercase", "unescapeSimpleStringChars", "unescapeStringLiteralValue", "value", "unquoteAndUnescapeString", "s", "unquoteAndUnescapeStringLiteralValue", "quotedString", "unescape", "unquoteString", "javascript-parser"})
public final class JSStringUtil {
    @NotNull
    public static final JSStringUtil INSTANCE = new JSStringUtil();
    @NotNull
    private static final Pattern EXT_UNICODE_CHAR;
    @NotNull
    private static final Pattern UNICODE_CHAR;

    private JSStringUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String unquoteAndUnescapeStringLiteralValue(@NotNull String quotedString) {
        Intrinsics.checkNotNullParameter((Object)quotedString, (String)"quotedString");
        return INSTANCE.unquoteAndUnescapeStringLiteralValue(quotedString, true);
    }

    @NotNull
    public final String toCamelCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        StringBuilder result = new StringBuilder();
        int[] codePoints = str.codePoints().toArray();
        int n = codePoints.length;
        for (int i = 0; i < n; ++i) {
            int prevChar;
            int ch = codePoints[i];
            if (Character.isUpperCase(ch)) {
                prevChar = i > 0 ? codePoints[i - 1] : 0;
                int nextChar = i < codePoints.length - 1 ? codePoints[i + 1] : 0;
                if (((CharSequence)result).length() > 0 && (this.isCaseSeparator(prevChar) || this.isRegularDigit(prevChar) || !Character.isUpperCase(prevChar) || Character.isLowerCase(nextChar))) {
                    result.appendCodePoint(ch);
                    continue;
                }
                result.appendCodePoint(Character.toLowerCase(ch));
                continue;
            }
            if (Character.isLowerCase(ch)) {
                prevChar = i > 0 ? codePoints[i - 1] : 0;
                if (((CharSequence)result).length() > 0 && (this.isCaseSeparator(prevChar) || this.isRegularDigit(prevChar))) {
                    result.appendCodePoint(Character.toUpperCase(ch));
                    continue;
                }
                result.appendCodePoint(ch);
                continue;
            }
            if (this.isCaseSeparator(ch)) continue;
            result.appendCodePoint(ch);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String toKebabCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.toSeparatorBasedCase('-', str, false, false, false);
    }

    private final String toSeparatorBasedCase(char separator, String str, boolean noSeparatorBeforeDigit, boolean noSeparatorBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        StringBuilder result = new StringBuilder();
        int[] codePoints = str.codePoints().toArray();
        int n = codePoints.length;
        for (int i = 0; i < n; ++i) {
            int nextChar;
            int ch = codePoints[i];
            int prevChar = i > 0 ? codePoints[i - 1] : 0;
            int n2 = nextChar = i + 1 < codePoints.length ? codePoints[i + 1] : 0;
            if (this.isCaseSeparator(ch)) {
                if (this.isCaseSeparator(nextChar) || nextChar == 0 || !(((CharSequence)result).length() > 0)) continue;
                result.append(separator);
                continue;
            }
            if (Character.isUpperCase(ch)) {
                if (!this.isCaseSeparator(prevChar) && ((CharSequence)result).length() > 0 && (this.isRegularDigit(prevChar) || !Character.isUpperCase(prevChar) || splitConsecutiveUppercase || Character.isLowerCase(nextChar))) {
                    result.append(separator);
                }
                result.appendCodePoint(Character.toLowerCase(ch));
                continue;
            }
            if (Character.isLowerCase(ch)) {
                if (!noSeparatorBetweenDigitAndLowercase && this.isRegularDigit(prevChar)) {
                    result.append(separator);
                }
                result.appendCodePoint(ch);
                continue;
            }
            if (!noSeparatorBeforeDigit && this.isRegularDigit(ch)) {
                if (!this.isCaseSeparator(prevChar) && !this.isRegularDigit(prevChar) && ((CharSequence)result).length() > 0) {
                    result.append(separator);
                }
                result.appendCodePoint(ch);
                continue;
            }
            result.appendCodePoint(ch);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean isCaseSeparator(int codePoint) {
        return codePoint == 95 || codePoint == 46 || codePoint == 45 || codePoint == 32;
    }

    private final boolean isRegularDigit(int codePoint) {
        return 48 <= codePoint && codePoint <= 57;
    }

    @JvmStatic
    public static final boolean isStartedWithQuote(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringUtil.startsWithChar((CharSequence)text, (char)'\"') || StringUtil.startsWithChar((CharSequence)text, (char)'\'');
    }

    @Contract(pure=true)
    @NotNull
    public final String unquoteAndUnescapeString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.unquoteString(s, true);
    }

    @NotNull
    public final String unquoteString(@NotNull String s, boolean unescape) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (StringUtil.isQuotedString((String)s)) {
            String string = s.substring(1, s.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String unquotedString = string;
            return unescape ? JSStringUtil.unescapeStringLiteralValue(unquotedString) : unquotedString;
        }
        return unescape ? INSTANCE.replaceUnicodeEscapeSequences(s) : s;
    }

    private final String stringUtilReplaceUnicodeEscapeSequences(String text) {
        Matcher matcher = UNICODE_CHAR.matcher(text);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.find()) {
            return text;
        }
        matcher2.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text.length());
        while (matcher2.find()) {
            sb.append(text, lastEnd, matcher2.start());
            String string = matcher2.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = string;
            int n = 2;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            string2 = string3;
            n = 16;
            char c = (char)Integer.parseInt(string2, CharsKt.checkRadix((int)n));
            sb.append(c);
            lastEnd = matcher2.end();
        }
        String string = text.substring(lastEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        sb.append(string);
        String string4 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @NotNull
    public final String replaceUnicodeEscapeSequences(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String text2 = text;
        if (!StringsKt.contains$default((CharSequence)text2, (CharSequence)"\\u", (boolean)false, (int)2, null)) {
            return text2;
        }
        text2 = this.stringUtilReplaceUnicodeEscapeSequences(text2);
        Matcher matcher = EXT_UNICODE_CHAR.matcher(text2);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text2.length());
        while (matcher2.find()) {
            String string;
            sb.append(text2, lastEnd, matcher2.start());
            Intrinsics.checkNotNullExpressionValue((Object)matcher2.group(), (String)"group(...)");
            int n = 3;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String item = string2;
            String string3 = item.substring(0, item.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            item = string3;
            try {
                char c = (char)Integer.parseInt(item, CharsKt.checkRadix((int)16));
                sb.append(c);
                lastEnd = matcher2.end();
            }
            catch (NumberFormatException ex) {
                return text2;
            }
        }
        String string = text2.substring(lastEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        sb.append(string);
        String string4 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @JvmStatic
    @Contract(pure=true)
    @NotNull
    public static final String unescapeStringLiteralValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String unescaped = INSTANCE.unescapeSimpleStringChars(value);
        if (!StringUtil.containsChar((String)unescaped, (char)'\\')) {
            return unescaped;
        }
        StringBuilder builder = new StringBuilder();
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        INSTANCE.parseStringCharacters(value, builder, (Ref<int[]>)ref, false, false);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean parseStringCharacters(String chars, StringBuilder outChars, Ref<int[]> sourceOffsetsRef, boolean regExp, boolean escapeBacktick) {
        if (StringsKt.indexOf$default((CharSequence)chars, (char)'\\', (int)0, (boolean)false, (int)6, null) < 0) {
            outChars.append(chars);
            sourceOffsetsRef.set((Object)IntStream.range(0, chars.length() + 1).toArray());
            return true;
        }
        int[] sourceOffsets = new int[chars.length() + 1];
        int index = 0;
        int outOffset = outChars.length();
        boolean result = true;
        int iteration = 0;
        while (index < chars.length()) {
            block47: {
                if (iteration++ % 1000 == 0) {
                    ProgressManager.checkCanceled();
                }
                char c = chars.charAt(index++);
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
                if (c != '\\') {
                    outChars.append(c);
                    continue;
                }
                if (index == chars.length()) {
                    result = false;
                    break;
                }
                c = chars.charAt(index++);
                if (escapeBacktick && c == '`') {
                    outChars.append(c);
                } else if (regExp) {
                    if (c != '/') {
                        outChars.append('\\');
                    }
                    outChars.append(c);
                } else {
                    char c2 = c;
                    if (c2 == 'b') {
                        outChars.append('\b');
                    } else if (c2 == 't') {
                        outChars.append('\t');
                    } else if (c2 == 'n' ? true : c2 == '\n') {
                        outChars.append('\n');
                    } else if (c2 == 'r') {
                        outChars.append('\r');
                    } else if (c2 == '\"') {
                        outChars.append('\"');
                    } else if (c2 == '/') {
                        outChars.append('/');
                    } else if (c2 == '\'') {
                        outChars.append('\'');
                    } else if (c2 == '\\') {
                        outChars.append('\\');
                    } else if (((((((c2 == '0' ? true : c2 == '1') ? true : c2 == '2') ? true : c2 == '3') ? true : c2 == '4') ? true : c2 == '5') ? true : c2 == '6') ? true : c2 == '7') {
                        char startC = c;
                        v = c - 48;
                        if (index < chars.length()) {
                            if (Intrinsics.compare((int)48, (int)(c = chars.charAt(index++))) <= 0 && Intrinsics.compare((int)c, (int)55) <= 0) {
                                v <<= 3;
                                v += c - 48;
                                if (Intrinsics.compare((int)startC, (int)51) <= 0 && index < chars.length()) {
                                    if (Intrinsics.compare((int)48, (int)(c = chars.charAt(index++))) <= 0 && Intrinsics.compare((int)c, (int)55) <= 0) {
                                        v <<= 3;
                                        v += c - 48;
                                    }
                                }
                            } else {
                                --index;
                            }
                        }
                        outChars.append((char)v);
                    } else {
                        int v;
                        if (c2 == 'x') {
                            if (index + 2 <= chars.length()) {
                                try {
                                    String string = chars.substring(index, index + 2);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                    v = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                                    outChars.append((char)v);
                                    index += 2;
                                    break block47;
                                }
                                catch (Exception e) {
                                    result = false;
                                    break;
                                }
                            }
                            result = false;
                            break;
                        }
                        if (c2 == 'u') {
                            if (index + 3 <= chars.length() && chars.charAt(index) == '{') {
                                int end = StringsKt.indexOf$default((CharSequence)chars, (char)'}', (int)(index + 1), (boolean)false, (int)4, null);
                                if (end < 0) {
                                    result = false;
                                    break;
                                }
                                try {
                                    String string = chars.substring(index + 1, end);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                    v = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                                    c = chars.charAt(index + 1);
                                    if (c == '+' || c == '-') {
                                        result = false;
                                        break;
                                    }
                                    outChars.appendCodePoint(v);
                                    index = end + 1;
                                    break block47;
                                }
                                catch (Exception e) {
                                    result = false;
                                    break;
                                }
                            }
                            if (index + 4 <= chars.length()) {
                                try {
                                    String string = chars.substring(index, index + 4);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                    v = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                                    c = chars.charAt(index);
                                    if (c == '+' || c == '-') {
                                        result = false;
                                        break;
                                    }
                                    outChars.append((char)v);
                                    index += 4;
                                    break block47;
                                }
                                catch (Exception e) {
                                    result = false;
                                    break;
                                }
                            }
                            result = false;
                            break;
                        }
                        outChars.append(c);
                    }
                }
            }
            sourceOffsets[outChars.length() - outOffset] = --index;
        }
        sourceOffsets[outChars.length() - outOffset] = chars.length();
        int[] nArray = Arrays.copyOf(sourceOffsets, outChars.length() - outOffset + 1);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        sourceOffsetsRef.set((Object)nArray);
        return result;
    }

    @NotNull
    public final String unescapeSimpleStringChars(@NotNull String chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        int index = 0;
        StringBuilder outChars = new StringBuilder(chars.length());
        while (index < chars.length()) {
            char c;
            block6: {
                block5: {
                    c = chars.charAt(index);
                    ++index;
                    if (c != '\\') {
                        outChars.append(c);
                        continue;
                    }
                    if (index >= chars.length()) break;
                    c = chars.charAt(index);
                    ++index;
                    if (c == 'u' || c == 'x') break block5;
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (!bl) break block6;
                }
                outChars.append('\\').append(c);
                continue;
            }
            char c2 = c;
            outChars.append((char)(c2 == 'b' ? 8 : (c2 == 't' ? 9 : ((c2 == 'n' ? true : c2 == '\n') ? 10 : (c2 == 'r' ? 13 : (c2 == '\"' ? 34 : (c2 == '/' ? 47 : (c2 == '\'' ? 39 : (c2 == '\\' ? 92 : (int)c)))))))));
        }
        String string = outChars.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Contract(pure=true)
    private final String unquoteAndUnescapeStringLiteralValue(String quotedString, boolean unescape) {
        char firstChar;
        if (!(StringUtil.isQuotedString((String)quotedString) || quotedString.length() <= 0 || (firstChar = quotedString.charAt(0)) != '\"' && firstChar != '\'')) {
            String string = quotedString.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String unquotedString = string;
            return unescape ? JSStringUtil.unescapeStringLiteralValue(unquotedString) : unquotedString;
        }
        return this.unquoteString(quotedString, unescape);
    }

    static {
        Pattern pattern = Pattern.compile("\\\\u\\{[0-9a-fA-F]+}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        EXT_UNICODE_CHAR = pattern;
        Pattern pattern2 = Pattern.compile("\\\\u[\\da-fA-F]{4}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        UNICODE_CHAR = pattern2;
    }
}

