/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public final class Plist {
    public static final Plist EMPTY_PLIST = new Plist(Collections.emptyMap());
    private final Map<String, PListValue> myMap;

    public static SimpleDateFormat dateFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public static Plist fromMap(Map<String, PListValue> map) {
        return new Plist(Collections.unmodifiableMap(map));
    }

    public Plist() {
        this(new LinkedHashMap<String, PListValue>());
    }

    private Plist(Map<String, PListValue> map) {
        this.myMap = map;
    }

    public void setEntry(@NotNull String key, @Nullable PListValue value) {
        if (key == null) {
            Plist.$$$reportNull$$$0(0);
        }
        if (value == null) {
            this.myMap.remove(key);
        } else {
            this.myMap.put(key, value);
        }
    }

    @Nullable
    public PListValue getPlistValue(@NotNull String key) {
        if (key == null) {
            Plist.$$$reportNull$$$0(1);
        }
        return this.getPlistValue(key, null);
    }

    @Contract(value="_,!null -> !null")
    public PListValue getPlistValue(@NotNull String key, @Nullable Object defValue) {
        PListValue result;
        if (key == null) {
            Plist.$$$reportNull$$$0(2);
        }
        if ((result = this.myMap.get(key)) != null) {
            return result;
        }
        if (defValue != null) {
            return new PListValue(defValue, PlistValueType.fromObject(defValue));
        }
        return null;
    }

    public boolean contains(@NotNull String key) {
        if (key == null) {
            Plist.$$$reportNull$$$0(3);
        }
        return this.myMap.containsKey(key);
    }

    public Set<Map.Entry<String, PListValue>> entries() {
        return this.myMap.entrySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plist plist = (Plist)o;
        return this.myMap.equals(plist.myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "key";
        objectArray2[1] = "org/jetbrains/plugins/textmate/plist/Plist";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setEntry";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPlistValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

