/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.anonymization;

import fleet.util.os.Os;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000201B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u001a\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J(\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0015\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u001d\u0010!\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001b\u0010*\u001a\u00020+8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b,\u0010-\u00a8\u00062"}, d2={"Lfleet/reporting/anonymization/DeviceIdManager;", "", "<init>", "()V", "UNDEFINED", "", "DEVICE_ID_SHARED_FILE", "DEVICE_ID_PREFERENCE_KEY", "getOrGenerateId", "token", "Lfleet/reporting/anonymization/DeviceIdManager$DeviceIdToken;", "recorderId", "assertAllowed", "", "getPreferenceKey", "isBaseRecorder", "", "isUndefinedRecorder", "syncWithSharedFile", "fileName", "installationId", "prefs", "Ljava/util/prefs/Preferences;", "prefsKey", "deleteLegacySharedFile", "UTF8_BOM", "", "hasUTF8Bom", "bom", "loadFromFile", "file", "Ljava/io/File;", "loadFromFile$fleet_reporting_anonymization", "writeToFile", "text", "writeToFile$fleet_reporting_anonymization", "preferences", "getPreferences", "()Ljava/util/prefs/Preferences;", "generateId", "calendar", "Ljava/util/Calendar;", "oSChar", "", "getOSChar", "()C", "oSChar$delegate", "Lkotlin/Lazy;", "DeviceIdToken", "InvalidDeviceIdTokenException", "fleet.reporting.anonymization"})
@SourceDebugExtension(value={"SMAP\nDeviceIdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceIdManager.kt\nfleet/reporting/anonymization/DeviceIdManager\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n108#2:173\n80#2,22:174\n1734#3,3:196\n1#4:199\n*S KotlinDebug\n*F\n+ 1 DeviceIdManager.kt\nfleet/reporting/anonymization/DeviceIdManager\n*L\n85#1:173\n85#1:174,22\n123#1:196,3\n*E\n"})
public final class DeviceIdManager {
    @NotNull
    public static final DeviceIdManager INSTANCE = new DeviceIdManager();
    @NotNull
    private static final String UNDEFINED = "UNDEFINED";
    @NotNull
    private static final String DEVICE_ID_SHARED_FILE = "PermanentDeviceId";
    @NotNull
    private static final String DEVICE_ID_PREFERENCE_KEY = "device_id";
    @NotNull
    private static final byte[] UTF8_BOM;
    @NotNull
    private static final Lazy oSChar$delegate;

    private DeviceIdManager() {
    }

    @NotNull
    public final String getOrGenerateId(@Nullable DeviceIdToken token, @NotNull String recorderId) throws InvalidDeviceIdTokenException {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.assertAllowed(token, recorderId);
        Preferences prefs = this.getPreferences();
        String preferenceKey = this.getPreferenceKey(recorderId);
        String deviceId = prefs.get(preferenceKey, null);
        CharSequence charSequence = deviceId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !StringsKt.contains$default((CharSequence)deviceId, (char)'_', (boolean)false, (int)2, null)) {
            Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
            deviceId = this.generateId(calendar);
            prefs.put(preferenceKey, deviceId);
        }
        if (Os.INSTANCE.isWindows()) {
            if (this.isBaseRecorder(recorderId)) {
                deviceId = this.syncWithSharedFile(DEVICE_ID_SHARED_FILE, deviceId, prefs, preferenceKey);
            } else {
                this.deleteLegacySharedFile(recorderId + "_PermanentDeviceId");
            }
        }
        return deviceId;
    }

    private final void assertAllowed(DeviceIdToken token, String recorderId) throws InvalidDeviceIdTokenException {
        if (this.isBaseRecorder(recorderId)) {
            if (token == null) {
                throw new InvalidDeviceIdTokenException("Cannot access base device id from unknown class");
            }
        } else if (!this.isUndefinedRecorder(recorderId) && token == null) {
            throw new InvalidDeviceIdTokenException("Cannot access device id from unknown class");
        }
    }

    private final String getPreferenceKey(String recorderId) {
        Object object;
        if (this.isBaseRecorder(recorderId)) {
            object = DEVICE_ID_PREFERENCE_KEY;
        } else {
            String string = recorderId.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            object = string + "_device_id";
        }
        return object;
    }

    private final boolean isBaseRecorder(String recorderId) {
        return Intrinsics.areEqual((Object)"FUS", (Object)recorderId);
    }

    private final boolean isUndefinedRecorder(String recorderId) {
        return Intrinsics.areEqual((Object)UNDEFINED, (Object)recorderId);
    }

    private final String syncWithSharedFile(String fileName, String installationId, Preferences prefs, String prefsKey) {
        File dir;
        String installationId2 = installationId;
        String appdata = System.getenv("APPDATA");
        if (appdata != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
            File permanentIdFile = new File(dir, fileName);
            try {
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    String $this$trim$iv = this.loadFromFile$fleet_reporting_anonymization(permanentIdFile);
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    fromFile = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
                if (!(((CharSequence)fromFile).length() == 0)) {
                    if (!Intrinsics.areEqual((Object)fromFile, (Object)installationId2)) {
                        installationId2 = fromFile;
                        prefs.put(prefsKey, installationId2);
                    }
                } else {
                    this.writeToFile$fleet_reporting_anonymization(permanentIdFile, installationId2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return installationId2;
    }

    private final void deleteLegacySharedFile(String fileName) {
        try {
            File permanentIdFile;
            File dir;
            String appdata = System.getenv("APPDATA");
            if (appdata != null && (dir = new File(appdata, "JetBrains")).exists() && (permanentIdFile = new File(dir, fileName)).exists()) {
                permanentIdFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUTF8Bom(byte[] bom) {
        boolean bl;
        if (bom.length < 3) return false;
        Iterable $this$all$iv = ArraysKt.zip((byte[])UTF8_BOM, (byte[])bom);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            byte b;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            byte a = ((Number)pair.component1()).byteValue();
            if (a != (b = ((Number)pair.component2()).byteValue())) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String loadFromFile$fleet_reporting_anonymization(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream is = (FileInputStream)closeable;
            boolean bl = false;
            byte[] byArray = is.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] bytes = byArray;
            int offset = INSTANCE.hasUTF8Bom(bytes) ? UTF8_BOM.length : 0;
            int n = bytes.length - offset;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String string = new String(bytes, offset, n, charset2);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile$fleet_reporting_anonymization(@NotNull File file, @NotNull String text) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Closeable closeable = new DataOutputStream(new FileOutputStream(file));
        Throwable throwable = null;
        try {
            DataOutputStream stream = (DataOutputStream)closeable;
            boolean bl = false;
            String string = text;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            stream.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Preferences getPreferences() {
        Preferences preferences = Preferences.userRoot().node("jetbrains");
        Intrinsics.checkNotNullExpressionValue((Object)preferences, (String)"node(...)");
        return preferences;
    }

    private final String generateId(Calendar calendar) {
        int year = calendar.get(1);
        if (year < 2000) {
            year = 2000;
        }
        if (year > 2099) {
            year = 2099;
        }
        calendar.set(1, year);
        return new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).format(calendar.getTime()) + "_" + UUID.randomUUID();
    }

    public final char getOSChar() {
        Lazy lazy = oSChar$delegate;
        return ((Character)lazy.getValue()).charValue();
    }

    private static final char oSChar_delegate$lambda$4() {
        Os.Type type = Os.INSTANCE.getType();
        return switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> '1';
            case 2 -> '3';
            case 3 -> '2';
            case 4 -> '0';
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    static {
        byte[] byArray = new byte[]{-17, -69, -65};
        UTF8_BOM = byArray;
        oSChar$delegate = LazyKt.lazy(DeviceIdManager::oSChar_delegate$lambda$4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lfleet/reporting/anonymization/DeviceIdManager$DeviceIdToken;", "", "fleet.reporting.anonymization"})
    public static interface DeviceIdToken {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/reporting/anonymization/DeviceIdManager$InvalidDeviceIdTokenException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "fleet.reporting.anonymization"})
    public static final class InvalidDeviceIdTokenException
    extends Exception {
        public InvalidDeviceIdTokenException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Os.Type.values().length];
            try {
                nArray[Os.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.MacOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.Unknown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

