/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.cidr.cpp.lexer;

import fleet.com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import fleet.com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import fleet.com.intellij.cidr.cpp.lexer._OCLexer;
import fleet.com.intellij.lexer.FlexAdapter;
import fleet.com.intellij.lexer.FlexLexer;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class OCLexer
extends FlexAdapter {
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION1 = _OCLexer.FLEX_JIT_ERROR_GUARD1;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION2 = _OCLexer.FLEX_JIT_ERROR_GUARD2;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION3 = _OCLexer.FLEX_JIT_ERROR_GUARD3;
    @TestOnly
    private static final IElementType CHECK_JIT_ADAPTATION_ = _OCLexer.FLEX_ERROR;
    public static final int INITIAL = 0;
    public static final int INITIAL_INSIDE_LINE = 1024;
    public static final int DIRECTIVE_BODY_STATE = 8;
    public static final int PRAGMA_BODY_STATE = 12;
    public static final int INCLUDE_BODY_STATE = 10;
    public static final int MAX_RAW_STRING_PREFIX_LENGTH = 16;
    @NotNull
    private final CidrTokenTypeProvider myTokenTypeProvider;

    public OCLexer(@NotNull CidrLexerSettings settings) {
        super((FlexLexer)new _OCLexer(null){

            @Override
            public void reset(CharSequence buffer, int start, int end, int initialState) {
                boolean isInsideLine = initialState == 1024;
                super.reset(buffer, start, end, isInsideLine ? 0 : initialState);
                this.myLogicalLineStartOffset = isInsideLine ? -1 : start;
            }
        });
        _OCLexer base = (_OCLexer)this.getFlex();
        base.setTokenTypeProvider(settings.getTokenTypeProvider());
        this.myTokenTypeProvider = settings.getTokenTypeProvider();
        if (settings.getLanguageKind().isCpp()) {
            base.allowCPPKeywords();
        }
        if (settings.getLanguageKind().isCuda()) {
            base.allowCUDAKeywords();
        }
        if (settings.getLanguageKind().isObjC()) {
            base.allowObjCKeywords();
        }
        if (settings.getAllowNullabilityKeywords()) {
            base.allowNullabilityKeywords();
        }
        if (settings.getAllowNullabilityNullableResultKeywords()) {
            base.allowNullabilityNullableResultKeywords();
        }
        if (settings.getAllowGccAutoType()) {
            base.allowGccAutoType();
        }
        if (settings.getAllowAvailabilityExpression()) {
            base.allowAvailabilityExpression();
        }
        if (settings.getAllowMsvcExtensions()) {
            base.allowMsvcExtensions();
        }
        if (settings.getAllowRiderMsvcExtensions()) {
            base.allowRiderMsvcExtensions();
        }
        base.setLanguageStandard(settings.getLanguageLevel());
        if (settings.getTreatCppAltOpsAsKeywords()) {
            base.forHighlighting();
        }
    }

    @NotNull
    public CidrTokenTypeProvider getTokenTypeProvider() {
        return this.myTokenTypeProvider;
    }
}

