/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.cidr.cpp.lexer;

import fleet.com.intellij.lexer.StringLiteralLexer;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.tree.IElementType;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CidrStringLiteralLexer
extends StringLiteralLexer {
    public static final char LONG_UNICODE_ESCAPE_CHAR = 'U';
    public static final char NAMED_UNICODE_ESCAPE_CHAR = 'N';
    public static final char OCTAL_ESCAPE_CHAR = 'o';
    public static final int LONG_UNICODE_ESCAPE_SEQUENCE_LENGTH = 10;
    @NonNls
    public static final String ADDITIONAL_VALID_ESCAPES = "?abvUNo";

    public CidrStringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        super(quoteChar, originalLiteralToken, false, ADDITIONAL_VALID_ESCAPES, true, true);
    }

    protected int locateHexEscapeSequence(int start, int indexOfCharAfterSlash) {
        int location = this.locateSeq(indexOfCharAfterSlash, ch -> StringUtil.isHexDigit((char)ch.charValue()));
        if (location >= 0) {
            return location;
        }
        for (location = indexOfCharAfterSlash + 1; location < this.myBufferEnd; ++location) {
            if (StringUtil.isHexDigit((char)this.myBuffer.charAt(location))) continue;
            return location;
        }
        return location;
    }

    @NotNull
    protected IElementType getHexCodedEscapeSeq() {
        if (this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            return this.myBuffer.charAt(this.myEnd - 1) == '}' && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myEnd - 2)) ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return this.myStart + 2 < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myStart + 2)) ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
    }

    protected int locateUnicodeEscapeSequence(int start, int indexOfCharAfterSlash) {
        int location = this.locateSeq(indexOfCharAfterSlash, ch -> StringUtil.isHexDigit((char)ch.charValue()));
        if (location >= 0) {
            return location;
        }
        return super.locateUnicodeEscapeSequence(start, indexOfCharAfterSlash);
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            return this.myBuffer.charAt(this.myEnd - 1) == '}' && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myEnd - 2)) ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return super.getUnicodeEscapeSequenceType();
    }

    protected int locateAdditionalEscapeSequence(int start, int indexOfCharAfterSlash) {
        int location;
        char chAfterSlash = this.myBuffer.charAt(indexOfCharAfterSlash);
        if (chAfterSlash == 'U') {
            int location2;
            for (location2 = indexOfCharAfterSlash + 1; location2 < start + 10; ++location2) {
                if (location2 != this.myBufferEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(location2))) continue;
                return location2;
            }
            return location2;
        }
        if (chAfterSlash == 'o' && (location = this.locateSeq(indexOfCharAfterSlash, ch -> StringUtil.isOctalDigit((char)ch.charValue()))) >= 0) {
            return location;
        }
        if (chAfterSlash == 'N' && (location = this.locateSeq(indexOfCharAfterSlash, ch -> ch.charValue() != '}' && ch.charValue() != '\"')) >= 0) {
            return location;
        }
        return -1;
    }

    public IElementType getTokenType() {
        char ch;
        IElementType type = super.getTokenType();
        if (type == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && ((ch = this.myBuffer.charAt(this.myStart + 1)) == 'U' ? this.myEnd - this.myStart != 10 : (ch == 'N' ? this.myEnd - this.myStart <= 4 || this.myBuffer.charAt(this.myEnd - 1) != '}' : ch == 'o' && (this.myBuffer.charAt(this.myEnd - 1) != '}' || !StringUtil.isOctalDigit((char)this.myBuffer.charAt(this.myEnd - 2)))))) {
            return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return type;
    }

    private int locateSeq(int indexOfCharAfterSlash, Predicate<Character> valid) {
        if (indexOfCharAfterSlash + 1 < this.myBufferEnd && this.myBuffer.charAt(indexOfCharAfterSlash + 1) == '{') {
            int location;
            for (location = indexOfCharAfterSlash + 2; location < this.myBufferEnd; ++location) {
                char ch = this.myBuffer.charAt(location);
                if (ch == '}') {
                    return location + 1;
                }
                if (valid.test(Character.valueOf(ch))) continue;
                return location;
            }
            return location;
        }
        return -1;
    }
}

