/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.functions;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.ParserPart;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.parsing.Attributes;
import fleet.com.jetbrains.php.lang.parser.parsing.TypeDeclaration;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import org.jetbrains.annotations.NotNull;

public final class ParameterList {
    private static final Parameter PARAMETER_PART = new Parameter(false);
    private static final Parameter DOC_PARAMETER_PART = new Parameter(true);

    public static void parse(PhpPsiBuilder builder, boolean isDoc) {
        PsiBuilder.Marker parameterList = builder.mark();
        Parameter part = isDoc ? DOC_PARAMETER_PART : PARAMETER_PART;
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, part.parse(builder), part, true);
        parameterList.done(PhpElementTypes.PARAMETER_LIST);
    }

    public static void parseParameter(@NotNull PhpPsiBuilder builder) {
        builder.compareAndEat(PhpTokenTypes.opBIT_AND);
        builder.compareAndEat(PhpTokenTypes.opVARIADIC);
        if (builder.compareAndEat(PhpTokenTypes.DOLLAR)) {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.VARIABLE));
        } else if (!builder.compareAndEat(PhpTokenTypes.VARIABLE)) {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.VARIABLE));
            builder.compareAndEat(PhpTokenTypes.IDENTIFIER);
        }
    }

    private static class Parameter
    implements ParserPart {
        @NotNull
        private static final TokenSet POSSIBLE_PROMOTED_PROPERTY_MODIFIER = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsVISIBILITY_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwVAR})});
        private final boolean myIsDoc;

        Parameter(boolean isDoc) {
            this.myIsDoc = isDoc;
        }

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            if (builder.compare(PhpTokenTypes.chRPAREN)) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            PsiBuilder.Marker parameter = builder.mark();
            boolean isPromotedField = false;
            if (this.myIsDoc) {
                builder.compareAndEat(PhpTokenTypes.opQUEST);
                do {
                    TypeDeclaration.parseSimpleType(builder);
                    if (!builder.compareAndEat(PhpTokenTypes.chLBRACKET)) continue;
                    builder.match(PhpTokenTypes.chRBRACKET);
                } while (builder.compareAndEat(PhpTokenTypes.opBIT_OR));
            } else {
                Attributes.parseAttributesList(builder);
                isPromotedField = Parameter.parsePromotedPropertyPart(builder);
                TypeDeclaration.parseType(builder, PhpElementTypes.PARAMETER_TYPE);
                Attributes.parseAttributesList(builder);
            }
            ParameterList.parseParameter(builder);
            if (builder.compare(PhpTokenTypes.opASGN)) {
                builder.advanceLexer();
                PsiBuilder.Marker defaultValue = builder.mark();
                if (Expression.parse(builder) == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected(PhpBundle.message("default.value", new Object[0])));
                }
                defaultValue.done(PhpElementTypes.PARAMETER_DEFAULT_VALUE);
            }
            IElementType type = isPromotedField ? PhpStubElementTypes.PROMOTED_FIELD_PARAMETER : PhpStubElementTypes.NOT_PROMOTED_PARAMETER;
            parameter.done(type);
            return type;
        }

        private static boolean parsePromotedPropertyPart(PhpPsiBuilder builder) {
            boolean isPromotedField = false;
            PsiBuilder.Marker mark = builder.mark();
            boolean isReadonly = false;
            while (builder.compare(PhpTokenTypes.tsVARIABLE_MODIFIERS) || (isReadonly = ClassMemberModifiers.mayBeReadonlyKeyword(builder))) {
                boolean bl = isPromotedField = isPromotedField || builder.compare(POSSIBLE_PROMOTED_PROPERTY_MODIFIER);
                if (isReadonly) {
                    if (!builder.readonlyPropertiesSupported() && ClassMemberModifiers.readonlyIsType(builder)) {
                        mark.drop();
                        return isPromotedField;
                    }
                    isPromotedField = true;
                }
                builder.advanceLexer();
            }
            if (isPromotedField) {
                mark.drop();
                Attributes.parseAttributesList(builder);
            } else {
                mark.rollbackTo();
            }
            return isPromotedField;
        }
    }
}

