/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.expressions;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.parsing.Namespace;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.StaticClassConstant;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.StaticArrayPairList;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.primary.Array;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.primary.Scalar;

public final class StaticScalar {
    public static final TokenSet STRING_START = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chLSINGLE_QUOTE, PhpTokenTypes.chLDOUBLE_QUOTE});
    public static final TokenSet STRING_BODY = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, PhpTokenTypes.STRING_NEW_LINE});
    public static final TokenSet STRING_END = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chRSINGLE_QUOTE, PhpTokenTypes.chRDOUBLE_QUOTE});

    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker staticScalar = builder.mark();
        IElementType result = StaticClassConstant.parse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            if (builder.compareAndEat(PhpTokenTypes.opPLUS) || builder.compareAndEat(PhpTokenTypes.opMINUS)) {
                StaticScalar.parse(builder);
                staticScalar.done(PhpElementTypes.STATIC_SCALAR);
                result = PhpElementTypes.STATIC_SCALAR;
            } else if (builder.compare(PhpTokenTypes.kwARRAY) || builder.compare(PhpTokenTypes.chLBRACKET)) {
                boolean longSyntax = builder.compareAndEat(PhpTokenTypes.kwARRAY);
                if (longSyntax) {
                    builder.match(PhpTokenTypes.chLPAREN);
                } else {
                    builder.match(PhpTokenTypes.chLBRACKET);
                }
                StaticArrayPairList.parse(builder);
                if (longSyntax) {
                    builder.match(PhpTokenTypes.chRPAREN);
                } else {
                    builder.match(PhpTokenTypes.chRBRACKET);
                }
                staticScalar.done(PhpElementTypes.ARRAY_CREATION_EXPRESSION);
                result = PhpElementTypes.ARRAY_CREATION_EXPRESSION;
            } else if (StaticScalar.parseConstantReference(builder)) {
                staticScalar.done(PhpElementTypes.CONSTANT_REF);
                result = PhpElementTypes.CONSTANT_REF;
            } else {
                result = StaticScalar.parseCommonScalar(builder);
                if (result != PhpElementTypes.EMPTY_INPUT) {
                    staticScalar.drop();
                }
            }
        } else {
            staticScalar.drop();
        }
        if (result == PhpElementTypes.EMPTY_INPUT) {
            staticScalar.rollbackTo();
        }
        return result;
    }

    public static boolean parseConstantReference(PhpPsiBuilder builder) {
        return Namespace.parseReference(builder) != null && builder.compareAndEat(PhpTokenTypes.IDENTIFIER);
    }

    public static IElementType parseCommonScalar(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.tsNUMBERS) || builder.compare(PhpTokenTypes.chLSINGLE_QUOTE)) {
            PsiBuilder.Marker scalar = builder.mark();
            IElementType type = builder.getTokenType();
            if (!PhpTokenTypes.tsNUMBERS.contains(type)) {
                scalar.done(Scalar.parseStringLiteral(builder));
                return Array.tryParsingArrayDerefOrFunctionCall(builder, PhpElementTypes.STRING, scalar);
            }
            builder.advanceLexer();
            scalar.done(PhpElementTypes.NUMBER);
            return PhpElementTypes.COMMON_SCALAR;
        }
        if (builder.compare(PhpTokenTypes.HEREDOC_START)) {
            PsiBuilder.Marker marker = builder.mark();
            String identifier = builder.getTokenText();
            builder.advanceLexer();
            if (identifier == null || !identifier.endsWith("\n")) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("line.separator", new Object[0])));
            }
            builder.compareAndEat(PhpTokenTypes.HEREDOC_CONTENTS);
            builder.match(PhpTokenTypes.HEREDOC_END);
            marker.done(PhpElementTypes.HEREDOC);
            return PhpElementTypes.HEREDOC;
        }
        return PhpElementTypes.EMPTY_INPUT;
    }
}

