/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing.classes;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.ParserPart;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.parsing.Attributes;
import fleet.com.jetbrains.php.lang.parser.parsing.TypeDeclaration;
import fleet.com.jetbrains.php.lang.parser.parsing.calls.Function;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassMemberModifiers;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import fleet.com.jetbrains.php.lang.parser.parsing.classes.ClassStatementList;
import org.jetbrains.annotations.Nullable;

public final class ClassDeclaration {
    private static final ParserPart INTERFACE_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            return ClassReference.parse(builder);
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result = ClassDeclaration.parseInterface(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = ClassDeclaration.parseClass(builder, false);
        }
        return result;
    }

    public static IElementType parseClass(PhpPsiBuilder builder, boolean anonymous) {
        IElementType typeResult;
        PsiBuilder.Marker classMarker = builder.mark();
        Attributes.parseAttributesList(builder);
        if (anonymous && ClassMemberModifiers.mayBeReadonlyKeyword(builder)) {
            builder.advanceLexer();
        }
        if (anonymous && !builder.compare(PhpTokenTypes.kwCLASS) || !builder.compare(PhpTokenTypes.kwCLASS) && !builder.compare(PhpTokenTypes.kwTRAIT) && !builder.compare(PhpTokenTypes.kwENUM) && !builder.compare(PhpTokenTypes.kwABSTRACT) && !builder.compare(PhpTokenTypes.kwFINAL) && !ClassMemberModifiers.mayBeReadonlyKeyword(builder)) {
            classMarker.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        if (!builder.compareAndEat(PhpTokenTypes.kwTRAIT) && !builder.compareAndEat(PhpTokenTypes.kwENUM)) {
            boolean isReadonly = ClassMemberModifiers.mayBeReadonlyKeyword(builder);
            boolean hasClassModifier = false;
            if (isReadonly) {
                builder.advanceLexer();
            }
            if (builder.compare(PhpTokenTypes.kwABSTRACT) || builder.compare(PhpTokenTypes.kwFINAL)) {
                builder.advanceLexer();
                hasClassModifier = true;
            }
            if (!isReadonly && ClassMemberModifiers.mayBeReadonlyKeyword(builder)) {
                isReadonly = true;
                builder.advanceLexer();
            }
            if (!builder.compareAndEat(PhpTokenTypes.kwCLASS)) {
                if (isReadonly && !hasClassModifier && (!builder.readonlyClassesSupported() || builder.compare(PhpTokenTypes.chLPAREN))) {
                    classMarker.rollbackTo();
                    return PhpElementTypes.EMPTY_INPUT;
                }
                builder.error(PhpParserErrors.expected(PhpTokenTypes.kwCLASS));
            }
        }
        Attributes.parseAttributesList(builder);
        if (!anonymous && !builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("class.name", new Object[0])));
        }
        if (anonymous && builder.compare(PhpTokenTypes.chLPAREN)) {
            Function.parseFunctionCallParameterList(builder);
        }
        if (builder.compare(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("extends.or.implements", new Object[0])));
            builder.advanceLexer();
        }
        if (builder.compareAndEat(PhpTokenTypes.opCOLON) && (typeResult = TypeDeclaration.parseType(builder, PhpElementTypes.BACKED_ENUM_TYPE)) == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("type", new Object[0])));
        }
        ClassDeclaration.parseClassExtends(builder);
        ClassDeclaration.parseClassImplements(builder);
        ClassDeclaration.parseClassStatements(builder);
        classMarker.done(PhpStubElementTypes.CLASS);
        return PhpStubElementTypes.CLASS;
    }

    @Nullable
    private static IElementType parseClassExtends(PhpPsiBuilder builder) {
        PsiBuilder.Marker extendsMarker = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwEXTENDS)) {
            ClassReference.parse(builder);
        }
        extendsMarker.done(PhpElementTypes.EXTENDS_LIST);
        return null;
    }

    private static IElementType parseClassImplements(PhpPsiBuilder builder) {
        PsiBuilder.Marker implementsList = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwIMPLEMENTS)) {
            ClassDeclaration.parseClassNamesList(builder);
        }
        implementsList.done(PhpElementTypes.IMPLEMENTS_LIST);
        return PhpElementTypes.IMPLEMENTS_LIST;
    }

    private static IElementType parseInterface(PhpPsiBuilder builder) {
        PsiBuilder.Marker interfaceMarker = builder.mark();
        Attributes.parseAttributesList(builder);
        if (!builder.compare(PhpTokenTypes.kwINTERFACE)) {
            interfaceMarker.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.advanceLexer();
        if (!builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("interface.name", new Object[0])));
        }
        if (builder.compare(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.expected(PhpBundle.message("extends", new Object[0])));
            builder.advanceLexer();
        }
        ClassDeclaration.parseInterfaceExtends(builder);
        PsiBuilder.Marker implementsList = builder.mark();
        implementsList.done(PhpElementTypes.IMPLEMENTS_LIST);
        ClassDeclaration.parseClassStatements(builder);
        interfaceMarker.done(PhpStubElementTypes.CLASS);
        return PhpStubElementTypes.CLASS;
    }

    private static void parseClassStatements(PhpPsiBuilder builder) {
        if (!builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.chLBRACE));
            return;
        }
        ClassStatementList.parse(builder);
        builder.match(PhpTokenTypes.chRBRACE);
    }

    private static IElementType parseInterfaceExtends(PhpPsiBuilder builder) {
        PsiBuilder.Marker extendsList = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwEXTENDS)) {
            ClassDeclaration.parseClassNamesList(builder);
        }
        extendsList.done(PhpElementTypes.EXTENDS_LIST);
        return PhpElementTypes.EXTENDS_LIST;
    }

    public static void parseClassNamesList(PhpPsiBuilder builder) {
        if (ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, INTERFACE_PART.parse(builder), INTERFACE_PART, true) < 0) {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.IDENTIFIER));
        }
    }
}

