/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.php.lang.parser.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.jetbrains.php.PhpBundle;
import fleet.com.jetbrains.php.lang.lexer.PhpTokenTypes;
import fleet.com.jetbrains.php.lang.parser.ListParsingHelper;
import fleet.com.jetbrains.php.lang.parser.ParserPart;
import fleet.com.jetbrains.php.lang.parser.PhpElementTypes;
import fleet.com.jetbrains.php.lang.parser.PhpParserErrors;
import fleet.com.jetbrains.php.lang.parser.PhpPsiBuilder;
import fleet.com.jetbrains.php.lang.parser.PhpStubElementTypes;
import fleet.com.jetbrains.php.lang.parser.parsing.Attributes;
import fleet.com.jetbrains.php.lang.parser.parsing.StatementList;
import fleet.com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.BreakStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.ContinueStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.DeclareStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.DoWhileStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.EchoStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.ForStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.ForeachStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.GlobalStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.GotoStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.IfStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.ReturnStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.StaticStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.SwitchStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.ThrowStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.TryStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.UnsetStatement;
import fleet.com.jetbrains.php.lang.parser.parsing.statements.WhileStatement;
import org.jetbrains.annotations.NotNull;

public final class Statement {
    private static final TokenSet HTML___PHP_CLOSING_TAG = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.HTML, PhpTokenTypes.PHP_CLOSING_TAG});
    private static final ParserPart CONSTANT_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            if (!builder.compare(PhpTokenTypes.IDENTIFIER)) {
                return PhpElementTypes.EMPTY_INPUT;
            }
            PsiBuilder.Marker constant = builder.mark();
            builder.match(PhpTokenTypes.IDENTIFIER);
            builder.match(PhpTokenTypes.opASGN);
            IElementType result = Expression.parse(builder);
            if (result == PhpElementTypes.EMPTY_INPUT) {
                builder.error(PhpParserErrors.expected(PhpBundle.message("initializer", new Object[0])));
            }
            constant.done(PhpStubElementTypes.CONST);
            return PhpStubElementTypes.CONST;
        }
    };
    @NotNull
    private static final TokenSet FUNCTION_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwFN, PhpTokenTypes.kwFUNCTION});

    public static IElementType parse(PhpPsiBuilder builder) {
        if (builder.compare(PhpTokenTypes.chLBRACE)) {
            StatementList.parseFast(builder);
            return PhpElementTypes.GROUP_STATEMENT;
        }
        if (Statement.parseHTML(builder)) {
            return PhpElementTypes.HTML;
        }
        if (builder.compare(PhpTokenTypes.opSEMICOLON)) {
            PsiBuilder.Marker statement = builder.mark();
            builder.advanceLexer();
            statement.done(PhpElementTypes.STATEMENT);
            return PhpElementTypes.STATEMENT;
        }
        IElementType result = Statement.parseStatementByKeyword(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            PsiBuilder.Marker statement = builder.mark();
            result = Expression.parse(builder);
            if (result != PhpElementTypes.EMPTY_INPUT) {
                if (builder.getTokenType() != PhpTokenTypes.PHP_CLOSING_TAG) {
                    builder.match(PhpTokenTypes.opSEMICOLON);
                }
                statement.done(PhpElementTypes.STATEMENT);
            } else {
                statement.drop();
                builder.error(PhpBundle.message("parsing.error.statement.expected", new Object[0]));
            }
        }
        return result;
    }

    public static boolean parseHTML(PhpPsiBuilder builder) {
        if (builder.compare(HTML___PHP_CLOSING_TAG)) {
            builder.compareAndEat(PhpTokenTypes.PHP_CLOSING_TAG);
            PsiBuilder.Marker html = builder.mark();
            if (builder.compareAndEat(PhpTokenTypes.HTML)) {
                html.done(PhpElementTypes.HTML);
            } else {
                html.drop();
            }
            if (builder.compare(PhpTokenTypes.PHP_OPENING_TAG)) {
                builder.advanceLexer();
            } else if (builder.compareAndEat(PhpTokenTypes.PHP_ECHO_OPENING_TAG)) {
                PsiBuilder.Marker echo = builder.mark();
                EchoStatement.parse(builder, true);
                echo.done(PhpElementTypes.ECHO);
            }
            return true;
        }
        return false;
    }

    private static IElementType parseStatementByKeyword(PhpPsiBuilder builder) {
        if (Statement.tryToParseLabel(builder)) {
            return PhpElementTypes.GOTO_LABEL;
        }
        IElementType constResult = Statement.parseConst(builder);
        if (constResult != PhpElementTypes.EMPTY_INPUT) {
            return constResult;
        }
        if (!builder.compare(PhpTokenTypes.tsSTATEMENT_FIRST_TOKENS)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        if (builder.compare(PhpTokenTypes.kwIF)) {
            return IfStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwWHILE)) {
            return WhileStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwDO)) {
            return DoWhileStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwFOR)) {
            return ForStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwSWITCH)) {
            return SwitchStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwBREAK)) {
            return BreakStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwCONTINUE)) {
            return ContinueStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwRETURN)) {
            return ReturnStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwGLOBAL)) {
            return GlobalStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwSTATIC) && !FUNCTION_KEYWORDS.contains(builder.lookAhead())) {
            return StaticStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwECHO)) {
            return EchoStatement.parse(builder, false);
        }
        if (builder.compare(PhpTokenTypes.kwUNSET)) {
            return UnsetStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwFOREACH)) {
            return ForeachStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwDECLARE)) {
            return DeclareStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwTRY)) {
            return TryStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwTHROW)) {
            return ThrowStatement.parse(builder);
        }
        if (builder.compare(PhpTokenTypes.kwGOTO)) {
            return GotoStatement.parse(builder);
        }
        return PhpElementTypes.EMPTY_INPUT;
    }

    private static boolean tryToParseLabel(PhpPsiBuilder builder) {
        PsiBuilder.Marker label = builder.mark();
        if (builder.compare(PhpTokenTypes.IDENTIFIER)) {
            builder.advanceLexer();
            if (builder.compareAndEat(PhpTokenTypes.opCOLON)) {
                label.done(PhpElementTypes.GOTO_LABEL);
                return true;
            }
        }
        label.rollbackTo();
        return false;
    }

    private static IElementType parseConst(PhpPsiBuilder builder) {
        PsiBuilder.Marker constants = builder.mark();
        Attributes.parseAttributesList(builder);
        if (!builder.compare(PhpTokenTypes.kwCONST)) {
            constants.rollbackTo();
            return PhpElementTypes.EMPTY_INPUT;
        }
        builder.advanceLexer();
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, CONSTANT_PART.parse(builder), CONSTANT_PART, false);
        if (!builder.compare(PhpTokenTypes.PHP_CLOSING_TAG)) {
            builder.match(PhpTokenTypes.opSEMICOLON);
        }
        constants.done(PhpElementTypes.CONSTANTS);
        return PhpElementTypes.CONSTANTS;
    }
}

