/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.anonymization.server;

import com.jetbrains.fus.reporting.anonymization.LogAnonymizer;
import com.jetbrains.fus.reporting.anonymization.server.Event;
import com.jetbrains.fus.reporting.anonymization.server.Group;
import com.jetbrains.fus.reporting.anonymization.server.LambdaFieldsToAnonymizeStorage;
import com.jetbrains.fus.reporting.anonymization.server.LogRecord;
import com.jetbrains.fus.reporting.anonymization.server.Recorder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J(\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/server/LambdaLogAnonymizer;", "", "fieldsToAnonymizeStorage", "Lcom/jetbrains/fus/reporting/anonymization/server/LambdaFieldsToAnonymizeStorage;", "salt", "", "(Lcom/jetbrains/fus/reporting/anonymization/server/LambdaFieldsToAnonymizeStorage;[B)V", "anonymizer", "Lcom/jetbrains/fus/reporting/anonymization/LogAnonymizer;", "anonymizeEvent", "Lcom/jetbrains/fus/reporting/anonymization/server/Event;", "event", "groupId", "", "recorderId", "anonymizeIds", "", "ids", "anonymizeRecord", "Lcom/jetbrains/fus/reporting/anonymization/server/LogRecord;", "record", "anonymization"})
public final class LambdaLogAnonymizer {
    private final LogAnonymizer anonymizer;
    private final LambdaFieldsToAnonymizeStorage fieldsToAnonymizeStorage;

    /*
     * WARNING - void declaration
     */
    private final Event anonymizeEvent(Event event, String groupId, String recorderId) {
        Set<String> fieldsToAnonymize = this.fieldsToAnonymizeStorage.getFieldsToAnonymize(groupId, event.getId(), recorderId);
        HashMap anonymizedData = new HashMap();
        Object object = event.getData();
        boolean bl = false;
        Iterator<Map.Entry<String, Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void field;
            Map.Entry<String, Object> entry;
            Map.Entry<String, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object value = entry2.getValue();
            ((Map)anonymizedData).put(field, fieldsToAnonymize.contains(field) ? this.anonymizer.anonymizeValue((String)field, value, fieldsToAnonymize) : value);
        }
        return new Event(event.getId(), event.getCount(), anonymizedData);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> anonymizeIds(Map<String, String> ids) {
        HashMap anonymizedIds = new HashMap();
        Object object = ids;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            String value = entry2.getValue();
            ((Map)anonymizedIds).put(key, this.anonymizer.anonymize(value));
        }
        return anonymizedIds;
    }

    @NotNull
    public final LogRecord anonymizeRecord(@NotNull LogRecord record) {
        String string;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Recorder recorder = Recorder.copy$default(record.getRecorder(), null, null, 3, null);
        Event event = this.anonymizeEvent(record.getEvent(), record.getGroup().getId(), record.getRecorder().getId());
        String string2 = record.getCountry();
        String string3 = record.getProduct();
        Boolean bl = record.getInternal();
        long l = record.getTime();
        String string4 = record.getBuild();
        String string5 = record.getBucket();
        Map<String, Object> map = record.getClient_data();
        if (record.getSession() == null) {
            string = null;
        } else {
            String string6 = record.getSession();
            Intrinsics.checkNotNull((Object)string6);
            string = this.anonymizer.anonymize(string6);
        }
        Object object = record.getTrace_data();
        Object object2 = record.getSystem_data();
        Group group = Group.copy$default(record.getGroup(), null, null, false, 7, null);
        Map<String, String> map2 = this.anonymizeIds(record.getIds());
        String string7 = string;
        Map<String, Object> map3 = map;
        String string8 = string5;
        String string9 = string4;
        long l2 = l;
        Boolean bl2 = bl;
        String string10 = string3;
        String string11 = string2;
        Event event2 = event;
        return new LogRecord(recorder, string10, string11, bl2, string9, string7, l2, map2, event2, group, string8, object2, map3, object);
    }

    public LambdaLogAnonymizer(@NotNull LambdaFieldsToAnonymizeStorage fieldsToAnonymizeStorage, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)fieldsToAnonymizeStorage, (String)"fieldsToAnonymizeStorage");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        this.fieldsToAnonymizeStorage = fieldsToAnonymizeStorage;
        this.anonymizer = new LogAnonymizer(salt, LogAnonymizer.Mode.SERVER);
    }
}

