/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.anonymization;

import com.jetbrains.fus.reporting.anonymization.AnonymizerUtil;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0012\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/AnonymizerUtil;", "", "()V", "sha256", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "getSha256", "()Ljava/security/MessageDigest;", "sha256$delegate", "Lkotlin/Lazy;", "anonymize", "", "salt", "", "data", "cloneDigest", "digest", "toHexString", "bytes", "anonymization"})
public final class AnonymizerUtil {
    private static final Lazy sha256$delegate;
    @NotNull
    public static final AnonymizerUtil INSTANCE;

    private final MessageDigest getSha256() {
        Lazy lazy = sha256$delegate;
        AnonymizerUtil anonymizerUtil = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MessageDigest)lazy.getValue();
    }

    @NotNull
    public final String anonymize(@NotNull String salt, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = salt;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return this.anonymize(byArray, data);
    }

    @NotNull
    public final String anonymize(@NotNull byte[] salt, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        MessageDigest messageDigest = this.getSha256();
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"sha256");
        MessageDigest md = this.cloneDigest(messageDigest);
        md.update(salt);
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        md.update(byArray);
        return this.toHexString(md.digest());
    }

    private final MessageDigest cloneDigest(MessageDigest digest) {
        MessageDigest messageDigest;
        try {
            Object object = digest.clone();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.MessageDigest");
            }
            messageDigest = (MessageDigest)object;
        }
        catch (CloneNotSupportedException e) {
            throw (Throwable)new IllegalArgumentException("Message digest is not cloneable: " + this);
        }
        return messageDigest;
    }

    private final String toHexString(byte[] bytes) {
        String digits = "0123456789abcdef";
        Intrinsics.checkNotNull((Object)bytes);
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte b;
            byte i2 = b = byArray[i];
            sb.append(digits.charAt(i2 >> 4 & 0xF)).append(digits.charAt(i2 & 0xF));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private AnonymizerUtil() {
    }

    static {
        AnonymizerUtil anonymizerUtil;
        INSTANCE = anonymizerUtil = new AnonymizerUtil();
        sha256$delegate = LazyKt.lazy((Function0)sha256.2.INSTANCE);
    }
}

