/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.markdown;

import fleet.api.Directory;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.FileDescriptor;
import fleet.api.HostId;
import fleet.api.Location;
import fleet.api.ProtocolPath;
import fleet.api.Root;
import fleet.api.SourcePosition;
import fleet.api.SourceRange;
import fleet.frontend.actions.FleetDataKeysKt;
import fleet.frontend.layout.ShowOpts;
import fleet.frontend.layout.WindowEntity;
import fleet.frontend.navigation.NavigationKt;
import fleet.frontend.navigation.NavigationParameters;
import fleet.frontend.navigation.NavigationParametersKt;
import fleet.frontend.navigation.ViewKt;
import fleet.git.frontend.GitChangesTabLocation;
import fleet.git.frontend.GitHistoryTabLocation;
import fleet.git.frontend.GitNavigationKt;
import fleet.git.protocol.GitRef;
import fleet.git.protocol.Oid;
import fleet.kernel.plugins.PluginScope;
import fleet.navigation.common.api.ViewTypeId;
import fleet.util.UID;
import io.ktor.http.CodecsKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import noria.model.ActionContext;
import noria.windowManagement.api.WindowManager;
import noria.windowManagement.extensions.WindowManagerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lfleet/ai/frontend/markdown/InlineLinkInfo;", "", "linkText", "", "linkDest", "linkTitle", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLinkText", "()Ljava/lang/String;", "getLinkDest", "getLinkTitle", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "fleet.plugins.ai.frontend"})
public final class InlineLinkInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String linkText;
    @NotNull
    private final String linkDest;
    @Nullable
    private final String linkTitle;
    @NotNull
    private static final String WorkspaceFileScheme = "fleet-file://";
    @NotNull
    private static final String WorkspaceCommitScheme = "fleet-commit://";
    @NotNull
    private static final String WorkspaceChangesScheme = "fleet-changes://";

    public InlineLinkInfo(@NotNull String linkText, @NotNull String linkDest, @Nullable String linkTitle) {
        Intrinsics.checkNotNullParameter((Object)linkText, (String)"linkText");
        Intrinsics.checkNotNullParameter((Object)linkDest, (String)"linkDest");
        this.linkText = linkText;
        this.linkDest = linkDest;
        this.linkTitle = linkTitle;
    }

    @NotNull
    public final String getLinkText() {
        return this.linkText;
    }

    @NotNull
    public final String getLinkDest() {
        return this.linkDest;
    }

    @Nullable
    public final String getLinkTitle() {
        return this.linkTitle;
    }

    @NotNull
    public final String component1() {
        return this.linkText;
    }

    @NotNull
    public final String component2() {
        return this.linkDest;
    }

    @Nullable
    public final String component3() {
        return this.linkTitle;
    }

    @NotNull
    public final InlineLinkInfo copy(@NotNull String linkText, @NotNull String linkDest, @Nullable String linkTitle) {
        Intrinsics.checkNotNullParameter((Object)linkText, (String)"linkText");
        Intrinsics.checkNotNullParameter((Object)linkDest, (String)"linkDest");
        return new InlineLinkInfo(linkText, linkDest, linkTitle);
    }

    public static /* synthetic */ InlineLinkInfo copy$default(InlineLinkInfo inlineLinkInfo, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = inlineLinkInfo.linkText;
        }
        if ((n & 2) != 0) {
            string2 = inlineLinkInfo.linkDest;
        }
        if ((n & 4) != 0) {
            string3 = inlineLinkInfo.linkTitle;
        }
        return inlineLinkInfo.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "InlineLinkInfo(linkText=" + this.linkText + ", linkDest=" + this.linkDest + ", linkTitle=" + this.linkTitle + ")";
    }

    public int hashCode() {
        int result2 = this.linkText.hashCode();
        result2 = result2 * 31 + this.linkDest.hashCode();
        result2 = result2 * 31 + (this.linkTitle == null ? 0 : this.linkTitle.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InlineLinkInfo)) {
            return false;
        }
        InlineLinkInfo inlineLinkInfo = (InlineLinkInfo)other;
        if (!Intrinsics.areEqual((Object)this.linkText, (Object)inlineLinkInfo.linkText)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.linkDest, (Object)inlineLinkInfo.linkDest)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.linkTitle, (Object)inlineLinkInfo.linkTitle);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ!\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\nJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ/\u0010\u001d\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005J)\u0010$\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010%J\u0012\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0018\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050)*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion;", "", "<init>", "()V", "WorkspaceFileScheme", "", "WorkspaceCommitScheme", "WorkspaceChangesScheme", "encodeToMarkdown", "address", "Lfleet/api/FileAddress;", "name", "line", "", "(Lfleet/api/FileAddress;Ljava/lang/String;Ljava/lang/Long;)Ljava/lang/String;", "location", "Lfleet/api/Location;", "(Lfleet/api/Location;Ljava/lang/Long;)Ljava/lang/String;", "workTree", "commit", "Lfleet/git/protocol/Oid;", "encodeLocalChanges", "navigate", "", "link", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "actionContext", "Lnoria/model/ActionContext;", "encodeToMarkdownImpl", "type", "Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type;", "(Lfleet/api/FileAddress;Ljava/lang/String;Ljava/lang/Long;Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type;)Ljava/lang/String;", "isCustom", "", "tag", "encodeFileAddress", "(Lfleet/api/FileAddress;Ljava/lang/Long;Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type;)Ljava/lang/String;", "decodeFileAddress", "encoded", "urlParams", "", "Type", "fleet.plugins.ai.frontend"})
    @SourceDebugExtension(value={"SMAP\nInlineLinkInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineLinkInfo.kt\nfleet/ai/frontend/markdown/InlineLinkInfo$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1755#2,3:139\n1611#2,9:143\n1863#2:152\n1864#2:154\n1620#2:155\n1187#2,2:156\n1261#2,4:158\n1#3:142\n1#3:153\n*S KotlinDebug\n*F\n+ 1 InlineLinkInfo.kt\nfleet/ai/frontend/markdown/InlineLinkInfo$Companion\n*L\n111#1:139,3\n133#1:143,9\n133#1:152\n133#1:154\n133#1:155\n134#1:156,2\n134#1:158,4\n133#1:153\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String encodeToMarkdown(@NotNull FileAddress address, @NotNull String name, @Nullable Long line) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.encodeToMarkdownImpl(address, name, line, Type.File.INSTANCE);
        }

        public static /* synthetic */ String encodeToMarkdown$default(Companion companion, FileAddress fileAddress, String string, Long l, int n, Object object) {
            if ((n & 2) != 0) {
                string = FileAddressKt.getName((FileAddress)fileAddress);
            }
            if ((n & 4) != 0) {
                l = null;
            }
            return companion.encodeToMarkdown(fileAddress, string, l);
        }

        @Nullable
        public final String encodeToMarkdown(@NotNull Location location, @Nullable Long line) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Location location2 = location;
            return location2 instanceof FileDescriptor.Address ? fleet.ai.frontend.markdown.InlineLinkInfo$Companion.encodeToMarkdown$default(this, ((FileDescriptor.Address)location).getFileAddress(), null, line, 2, null) : (location2 instanceof SourcePosition ? this.encodeToMarkdown((Location)((SourcePosition)location).getFile(), ((SourcePosition)location).getOffset()) : (location2 instanceof SourceRange ? this.encodeToMarkdown((Location)((SourceRange)location).getFile(), ((SourceRange)location).getRange().getStart()) : (location2 instanceof Directory ? fleet.ai.frontend.markdown.InlineLinkInfo$Companion.encodeToMarkdown$default(this, ((Directory)location).getFileAddress(), null, null, 6, null) : null)));
        }

        public static /* synthetic */ String encodeToMarkdown$default(Companion companion, Location location, Long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = null;
            }
            return companion.encodeToMarkdown(location, l);
        }

        @NotNull
        public final String encodeToMarkdown(@NotNull FileAddress workTree, @NotNull Oid commit) {
            Intrinsics.checkNotNullParameter((Object)workTree, (String)"workTree");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            return this.encodeToMarkdownImpl(workTree, StringsKt.take((String)commit.getOid(), (int)8), null, new Type.Commit(commit.getOid()));
        }

        @NotNull
        public final String encodeLocalChanges(@NotNull FileAddress workTree) {
            Intrinsics.checkNotNullParameter((Object)workTree, (String)"workTree");
            return this.encodeToMarkdownImpl(workTree, "Local Changes", null, Type.Changes.INSTANCE);
        }

        public final void navigate(@NotNull String link, @NotNull PluginScope pluginScope, @NotNull ActionContext actionContext) {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            if (!this.isCustom(link)) {
                WindowManagerKt.openUrl((WindowManager)FleetDataKeysKt.getWindowManager((ActionContext)actionContext), (String)link);
                return;
            }
            FileAddress fileAddress = this.decodeFileAddress(link);
            if (fileAddress == null) {
                return;
            }
            FileAddress file = fileAddress;
            if (StringsKt.startsWith$default((String)link, (String)InlineLinkInfo.WorkspaceFileScheme, (boolean)false, (int)2, null)) {
                FileDescriptor.Address address = new FileDescriptor.Address(file);
                String string = this.urlParams(link).get("line");
                Long line = string != null ? StringsKt.toLongOrNull((String)string) : null;
                NavigationParameters navigation = line != null && line < 0L ? NavigationParametersKt.toNavigationParams$default((Location)((Location)new SourcePosition((FileDescriptor)address, line.longValue())), (boolean)false, null, (boolean)false, null, (int)15, null) : NavigationParametersKt.toNavigationParams$default((Location)((Location)address), (boolean)false, null, (boolean)false, null, (int)15, null);
                v2 = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)pluginScope), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(navigation, actionContext, null){
                    int label;
                    final /* synthetic */ NavigationParameters $navigation;
                    final /* synthetic */ ActionContext $actionContext;
                    {
                        this.$navigation = $navigation;
                        this.$actionContext = $actionContext;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = NavigationKt.navigate((NavigationParameters)this.$navigation, (ShowOpts)new ShowOpts(false, false, false, true, false, false, null, false, null, false, false, null, FleetDataKeysKt.getWindowEntity((ActionContext)this.$actionContext), 3575, null), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else if (StringsKt.startsWith$default((String)link, (String)InlineLinkInfo.WorkspaceCommitScheme, (boolean)false, (int)2, null)) {
                String string = this.urlParams(link).get("commit");
                if (string == null) {
                    return;
                }
                String commit = string;
                v2 = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)pluginScope), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, commit, actionContext, null){
                    int label;
                    final /* synthetic */ FileAddress $file;
                    final /* synthetic */ String $commit;
                    final /* synthetic */ ActionContext $actionContext;
                    {
                        this.$file = $file;
                        this.$commit = $commit;
                        this.$actionContext = $actionContext;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                WindowEntity windowEntity = FleetDataKeysKt.getWindowEntity((ActionContext)this.$actionContext);
                                this.label = 1;
                                Object object3 = ViewKt.navigate((ViewTypeId)GitNavigationKt.getGitHistoryTabTypeId(), (Object)new GitHistoryTabLocation.Repository(this.$file, null, new GitRef.Commit(new Oid(this.$commit), StringsKt.take((String)this.$commit, (int)8)), 2, null), (ShowOpts)new ShowOpts(false, true, false, false, true, false, null, false, null, false, false, null, windowEntity, 4077, null), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else if (StringsKt.startsWith$default((String)link, (String)InlineLinkInfo.WorkspaceChangesScheme, (boolean)false, (int)2, null)) {
                GitChangesTabLocation.Repository changesTabLocation = new GitChangesTabLocation.Repository(file);
                WindowEntity windowEntity = FleetDataKeysKt.getWindowEntity((ActionContext)actionContext);
                ShowOpts showOpts = new ShowOpts(false, true, false, false, true, false, null, false, null, false, false, null, windowEntity, 4077, null);
                v2 = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)pluginScope), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(changesTabLocation, showOpts, null){
                    int label;
                    final /* synthetic */ GitChangesTabLocation.Repository $changesTabLocation;
                    final /* synthetic */ ShowOpts $showOpts;
                    {
                        this.$changesTabLocation = $changesTabLocation;
                        this.$showOpts = $showOpts;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = ViewKt.navigate((ViewTypeId)GitNavigationKt.getGitChangesTabViewTypeId(), (Object)this.$changesTabLocation, (ShowOpts)this.$showOpts, (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else {
                return;
            }
        }

        private final String encodeToMarkdownImpl(FileAddress address, String name, Long line, Type type) {
            return "[" + name + "](" + this.encodeFileAddress(address, line, type) + ")";
        }

        public final boolean isCustom(@NotNull String tag) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Object[] objectArray = new String[]{InlineLinkInfo.WorkspaceFileScheme, InlineLinkInfo.WorkspaceCommitScheme, InlineLinkInfo.WorkspaceChangesScheme};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)tag, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final String encodeFileAddress(FileAddress address, Long line, Type type) {
            String string;
            Object object;
            String path = CollectionsKt.joinToString$default((Iterable)address.getPath().getComponents(), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            String root = CodecsKt.encodeURLPathPart((String)address.getPath().getRoot().toString());
            UID hostId = address.getHostId().getUid();
            Long l = line;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                object = "&line=" + it;
            } else {
                object = string = null;
            }
            if (object == null) {
                string = "";
            }
            String linePart = string;
            String string2 = new URI(type.getScheme() + "/" + path + "?hostId=" + hostId + "&root=" + root + linePart + "&" + type.getParam()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        static /* synthetic */ String encodeFileAddress$default(Companion companion, FileAddress fileAddress, Long l, Type type, int n, Object object) {
            if ((n & 2) != 0) {
                l = null;
            }
            return companion.encodeFileAddress(fileAddress, l, type);
        }

        private final FileAddress decodeFileAddress(String encoded) {
            String string;
            String hostId;
            String path;
            block9: {
                block8: {
                    String string2;
                    Map<String, String> params;
                    block7: {
                        block6: {
                            params = this.urlParams(encoded);
                            String string3 = new URI(encoded).getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                            char[] cArray = new char[]{'/'};
                            path = StringsKt.trim((String)string3, (char[])cArray);
                            string2 = params.get("hostId");
                            if (string2 == null) break block6;
                            String string4 = string2;
                            UID.Companion companion = UID.Companion;
                            String p0 = string4;
                            boolean $i$f$decodeFileAddress$stub_for_inlining = false;
                            boolean bl = false;
                            UID uID = companion.fromString(p0);
                            string2 = uID;
                            if (uID != null) break block7;
                        }
                        return null;
                    }
                    hostId = string2;
                    string = params.get("root");
                    if (string == null) break block8;
                    String it = string;
                    boolean bl = false;
                    Root root = Intrinsics.areEqual((Object)it, (Object)Root.Unix.INSTANCE.toString()) ? (Root)Root.Unix.INSTANCE : (Root)new Root.Windows(it);
                    string = root;
                    if (root != null) break block9;
                }
                return null;
            }
            String root = string;
            String[] stringArray = new String[]{"/"};
            return new FileAddress(new HostId((UID)hostId), new ProtocolPath((Root)root, StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, String> urlParams(String $this$urlParams) {
            void $this$associateTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            List list2;
            List list3;
            URI uriPath = new URI($this$urlParams);
            String string = uriPath.getQuery();
            if (string != null) {
                String[] stringArray = new String[]{"&"};
                list3 = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<Object> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Object object = new String[]{"="};
                Object it2 = object = StringsKt.split$default((CharSequence)it, (String[])object, (boolean)false, (int)0, (int)6, null);
                boolean bl3 = false;
                if ((it2.size() == 2 ? object : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                List it = (List)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to(it.get(0), it.get(1));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u0082\u0001\u0003\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type;", "", "scheme", "", "param", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getScheme", "()Ljava/lang/String;", "getParam", "File", "Changes", "Commit", "Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type$Changes;", "Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type$Commit;", "Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type$File;", "fleet.plugins.ai.frontend"})
        private static abstract class Type {
            @NotNull
            private final String scheme;
            @NotNull
            private final String param;

            private Type(String scheme, String param) {
                this.scheme = scheme;
                this.param = param;
            }

            @NotNull
            public final String getScheme() {
                return this.scheme;
            }

            @NotNull
            public final String getParam() {
                return this.param;
            }

            public /* synthetic */ Type(String scheme, String param, DefaultConstructorMarker $constructor_marker) {
                this(scheme, param);
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type$Changes;", "Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "fleet.plugins.ai.frontend"})
            public static final class Changes
            extends Type {
                @NotNull
                public static final Changes INSTANCE = new Changes();

                private Changes() {
                    super(InlineLinkInfo.WorkspaceChangesScheme, "type=changes", null);
                }

                @NotNull
                public String toString() {
                    return "Changes";
                }

                public int hashCode() {
                    return 811589941;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Changes)) {
                        return false;
                    }
                    Changes cfr_ignored_0 = (Changes)other;
                    return true;
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type$Commit;", "Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type;", "commit", "", "<init>", "(Ljava/lang/String;)V", "getCommit", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fleet.plugins.ai.frontend"})
            public static final class Commit
            extends Type {
                @NotNull
                private final String commit;

                public Commit(@NotNull String commit) {
                    Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
                    super(InlineLinkInfo.WorkspaceCommitScheme, "commit=" + commit, null);
                    this.commit = commit;
                }

                @NotNull
                public final String getCommit() {
                    return this.commit;
                }

                @NotNull
                public final String component1() {
                    return this.commit;
                }

                @NotNull
                public final Commit copy(@NotNull String commit) {
                    Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
                    return new Commit(commit);
                }

                public static /* synthetic */ Commit copy$default(Commit commit, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = commit.commit;
                    }
                    return commit.copy(string);
                }

                @NotNull
                public String toString() {
                    return "Commit(commit=" + this.commit + ")";
                }

                public int hashCode() {
                    return this.commit.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Commit)) {
                        return false;
                    }
                    Commit commit = (Commit)other;
                    return Intrinsics.areEqual((Object)this.commit, (Object)commit.commit);
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type$File;", "Lfleet/ai/frontend/markdown/InlineLinkInfo$Companion$Type;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "fleet.plugins.ai.frontend"})
            public static final class File
            extends Type {
                @NotNull
                public static final File INSTANCE = new File();

                private File() {
                    super(InlineLinkInfo.WorkspaceFileScheme, "type=file", null);
                }

                @NotNull
                public String toString() {
                    return "File";
                }

                public int hashCode() {
                    return -1187554230;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof File)) {
                        return false;
                    }
                    File cfr_ignored_0 = (File)other;
                    return true;
                }
            }
        }
    }
}

