/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.auth.enterprise;

import fleet.ai.frontend.auth.enterprise.TbaToken;
import fleet.ai.frontend.auth.enterprise.TbaTokenKt;
import fleet.ai.frontend.auth.enterprise.TbaTokenResponse;
import io.ktor.http.HttpHeaders;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00042\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult;", "", "Success", "Failure", "Companion", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Success;", "fleet.plugins.ai.frontend"})
public interface TbaTokenResult {
    @NotNull
    public static final Companion Companion = fleet.ai.frontend.auth.enterprise.TbaTokenResult$Companion.$$INSTANCE;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Companion;", "", "<init>", "()V", "parse", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult;", "rawResponse", "", "parseSuccessResponse", "response", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResponse;", "parseErrorResponse", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "tbaTokenResponse", "TbaAuthErrorType", "fleet.plugins.ai.frontend"})
    @SourceDebugExtension(value={"SMAP\nTbaToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TbaToken.kt\nfleet/ai/frontend/auth/enterprise/TbaTokenResult$Companion\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,134:1\n96#2:135\n1755#3,3:136\n1755#3,3:139\n487#4,7:142\n*S KotlinDebug\n*F\n+ 1 TbaToken.kt\nfleet/ai/frontend/auth/enterprise/TbaTokenResult$Companion\n*L\n38#1:135\n53#1:136,3\n54#1:139,3\n57#1:142,7\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final TbaTokenResult parse(@NotNull String rawResponse) {
            Object $this$parse_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)rawResponse, (String)"rawResponse");
            if (StringsKt.isBlank((CharSequence)rawResponse)) {
                return new Failure.GenericError("Got empty response from TBA", null, 2, null);
            }
            Object object = this;
            try {
                $this$parse_u24lambda_u240 = object;
                boolean bl = false;
                Json this_$iv = TbaTokenKt.access$getJson();
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                $this$parse_u24lambda_u240 = Result.constructor-impl((Object)((TbaTokenResponse)this_$iv.decodeFromString((DeserializationStrategy)TbaTokenResponse.Companion.serializer(), rawResponse)));
            }
            catch (Throwable bl) {
                $this$parse_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$parse_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable error = throwable;
                boolean bl = false;
                return new Failure.MalformedResponse("Cannot parse response from TBA: " + error.getMessage(), error);
            }
            TbaTokenResponse responseObject = (TbaTokenResponse)object;
            object = responseObject.getType();
            return Intrinsics.areEqual((Object)object, (Object)"success") ? this.parseSuccessResponse(responseObject) : (Intrinsics.areEqual((Object)object, (Object)"error") ? (TbaTokenResult)this.parseErrorResponse(responseObject) : (TbaTokenResult)new Failure.MalformedResponse("Malformed response from TBA: '" + rawResponse + "'", null, 2, null));
        }

        private final TbaTokenResult parseSuccessResponse(TbaTokenResponse response2) {
            TbaTokenResult tbaTokenResult;
            if (response2.getExpiresAt() == null) {
                tbaTokenResult = new Failure.ValidationError("Token reply from TBA has no 'expires_at' field: " + response2);
            } else if (response2.getAccessToken() == null) {
                tbaTokenResult = new Failure.ValidationError("Token reply from TBA has no 'accessToken' field: " + response2);
            } else {
                boolean bl;
                String it;
                boolean $i$f$any;
                Iterable $this$any$iv;
                Map<String, String> map2 = response2.getAdditionalHeaders();
                if (map2 != null && (map2 = map2.keySet()) != null) {
                    boolean bl2;
                    block22: {
                        $this$any$iv = (Iterable)((Object)map2);
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl3 = false;
                                if (!StringsKt.isBlank((CharSequence)it)) continue;
                                bl2 = true;
                                break block22;
                            }
                            bl2 = false;
                        }
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                if (bl) {
                    tbaTokenResult = new Failure.ValidationError("Empty additional header name is forbidden in: " + response2);
                } else {
                    boolean bl4;
                    Map<String, String> map3 = response2.getAdditionalHeaders();
                    if (map3 != null && (map3 = map3.values()) != null) {
                        boolean bl5;
                        block23: {
                            $this$any$iv = (Iterable)((Object)map3);
                            $i$f$any = false;
                            if (((Collection)$this$any$iv).isEmpty()) {
                                bl5 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (String)element$iv;
                                    boolean bl6 = false;
                                    if (!StringsKt.isBlank((CharSequence)it)) continue;
                                    bl5 = true;
                                    break block23;
                                }
                                bl5 = false;
                            }
                        }
                        bl4 = bl5;
                    } else {
                        bl4 = false;
                    }
                    if (bl4) {
                        tbaTokenResult = new Failure.ValidationError("Empty additional header value is forbidden in: " + response2);
                    } else {
                        Map map4;
                        Map<String, String> map5 = response2.getAdditionalHeaders();
                        if (map5 != null) {
                            Map<String, String> $this$filterKeys$iv = map5;
                            boolean $i$f$filterKeys = false;
                            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
                            for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                                String it2 = entry$iv.getKey();
                                boolean bl7 = false;
                                if (!(!Intrinsics.areEqual((Object)it2, (Object)HttpHeaders.INSTANCE.getAuthorization()))) continue;
                                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                            }
                            map4 = result$iv;
                        } else {
                            map4 = null;
                        }
                        Map additionalHeaders = map4;
                        String string = response2.getAccessToken();
                        Map map6 = additionalHeaders;
                        if (map6 == null) {
                            map6 = MapsKt.emptyMap();
                        }
                        Instant instant = Instant.ofEpochSecond(response2.getExpiresAt());
                        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
                        TbaToken token2 = new TbaToken(string, "Bearer", map6, instant);
                        tbaTokenResult = new Success(token2);
                    }
                }
            }
            return tbaTokenResult;
        }

        /*
         * Unable to fully structure code
         */
        private final Failure parseErrorResponse(TbaTokenResponse tbaTokenResponse) {
            block15: {
                block12: {
                    block13: {
                        block14: {
                            v0 = var2_2 = tbaTokenResponse.getError();
                            if (v0 == null) break block12;
                            switch (v0.hashCode()) {
                                case 1701498841: {
                                    if (!var2_2.equals("OTHER_ERROR")) {
                                        ** break;
                                    }
                                    break block13;
                                }
                                case -1905424057: {
                                    if (var2_2.equals("CONNECTION_ERROR")) break;
                                    ** break;
                                }
                                case -893421611: {
                                    if (!var2_2.equals("LOGIN_REQUIRED")) {
                                        ** break;
                                    }
                                    break block14;
                                }
                            }
                            v1 = tbaTokenResponse.getMessage();
                            if (v1 == null) {
                                v1 = "";
                            }
                            v2 = new Failure.NetworkError(v1);
                            break block15;
                        }
                        v3 = tbaTokenResponse.getMessage();
                        if (v3 == null) {
                            v3 = "";
                        }
                        v2 = new Failure.LoginRequired(v3);
                        break block15;
                    }
                    message = tbaTokenResponse.getMessage();
                    if (message != null && StringsKt.contains$default((CharSequence)message, (CharSequence)"Failed to resolve Enterprise Account", (boolean)false, (int)2, null)) {
                        v2 = new Failure.LoginRequired(message);
                    } else {
                        v4 = tbaTokenResponse.getMessage();
                        if (v4 == null) {
                            v4 = "";
                        }
                        v2 = new Failure.GenericError(v4, null, 2, null);
                    }
                    break block15;
                }
                v2 = new Failure.ValidationError("No error kind specified in TBA response: " + tbaTokenResponse);
                break block15;
lbl39:
                // 4 sources

                v2 = new Failure.GenericError("Unrecognised error from TBA: [" + tbaTokenResponse.getError() + "] " + tbaTokenResponse.getMessage(), null, 2, null);
            }
            return v2;
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Companion$TbaAuthErrorType;", "", "<init>", "()V", "CONNECTION_ERROR", "", "LOGIN_REQUIRED", "OTHER_ERROR", "fleet.plugins.ai.frontend"})
        private static final class TbaAuthErrorType {
            @NotNull
            public static final TbaAuthErrorType INSTANCE = new TbaAuthErrorType();
            @NotNull
            public static final String CONNECTION_ERROR = "CONNECTION_ERROR";
            @NotNull
            public static final String LOGIN_REQUIRED = "LOGIN_REQUIRED";
            @NotNull
            public static final String OTHER_ERROR = "OTHER_ERROR";

            private TbaAuthErrorType() {
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0006\u0006\u0007\b\t\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0006\f\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult;", "message", "", "getMessage", "()Ljava/lang/String;", "Timeout", "NetworkError", "LoginRequired", "ValidationError", "MalformedResponse", "GenericError", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$GenericError;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$LoginRequired;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$MalformedResponse;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$NetworkError;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$Timeout;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$ValidationError;", "fleet.plugins.ai.frontend"})
    public static interface Failure
    extends TbaTokenResult {
        @NotNull
        public String getMessage();

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$GenericError;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getMessage", "()Ljava/lang/String;", "getCause", "()Ljava/lang/Throwable;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fleet.plugins.ai.frontend"})
        public static final class GenericError
        implements Failure {
            @NotNull
            private final String message;
            @Nullable
            private final Throwable cause;

            public GenericError(@NotNull String message2, @Nullable Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.message = message2;
                this.cause = cause;
            }

            public /* synthetic */ GenericError(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    throwable = null;
                }
                this(string, throwable);
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @Nullable
            public final Throwable getCause() {
                return this.cause;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @Nullable
            public final Throwable component2() {
                return this.cause;
            }

            @NotNull
            public final GenericError copy(@NotNull String message2, @Nullable Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                return new GenericError(message2, cause);
            }

            public static /* synthetic */ GenericError copy$default(GenericError genericError, String string, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    string = genericError.message;
                }
                if ((n & 2) != 0) {
                    throwable = genericError.cause;
                }
                return genericError.copy(string, throwable);
            }

            @NotNull
            public String toString() {
                return "GenericError(message=" + this.message + ", cause=" + this.cause + ")";
            }

            public int hashCode() {
                int result2 = this.message.hashCode();
                result2 = result2 * 31 + (this.cause == null ? 0 : this.cause.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GenericError)) {
                    return false;
                }
                GenericError genericError = (GenericError)other;
                if (!Intrinsics.areEqual((Object)this.message, (Object)genericError.message)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cause, (Object)genericError.cause);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$LoginRequired;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fleet.plugins.ai.frontend"})
        public static final class LoginRequired
        implements Failure {
            @NotNull
            private final String message;

            public LoginRequired(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.message = message2;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final LoginRequired copy(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                return new LoginRequired(message2);
            }

            public static /* synthetic */ LoginRequired copy$default(LoginRequired loginRequired, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = loginRequired.message;
                }
                return loginRequired.copy(string);
            }

            @NotNull
            public String toString() {
                return "LoginRequired(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoginRequired)) {
                    return false;
                }
                LoginRequired loginRequired = (LoginRequired)other;
                return Intrinsics.areEqual((Object)this.message, (Object)loginRequired.message);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$MalformedResponse;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getMessage", "()Ljava/lang/String;", "getCause", "()Ljava/lang/Throwable;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fleet.plugins.ai.frontend"})
        public static final class MalformedResponse
        implements Failure {
            @NotNull
            private final String message;
            @Nullable
            private final Throwable cause;

            public MalformedResponse(@NotNull String message2, @Nullable Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.message = message2;
                this.cause = cause;
            }

            public /* synthetic */ MalformedResponse(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    throwable = null;
                }
                this(string, throwable);
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @Nullable
            public final Throwable getCause() {
                return this.cause;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @Nullable
            public final Throwable component2() {
                return this.cause;
            }

            @NotNull
            public final MalformedResponse copy(@NotNull String message2, @Nullable Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                return new MalformedResponse(message2, cause);
            }

            public static /* synthetic */ MalformedResponse copy$default(MalformedResponse malformedResponse, String string, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    string = malformedResponse.message;
                }
                if ((n & 2) != 0) {
                    throwable = malformedResponse.cause;
                }
                return malformedResponse.copy(string, throwable);
            }

            @NotNull
            public String toString() {
                return "MalformedResponse(message=" + this.message + ", cause=" + this.cause + ")";
            }

            public int hashCode() {
                int result2 = this.message.hashCode();
                result2 = result2 * 31 + (this.cause == null ? 0 : this.cause.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MalformedResponse)) {
                    return false;
                }
                MalformedResponse malformedResponse = (MalformedResponse)other;
                if (!Intrinsics.areEqual((Object)this.message, (Object)malformedResponse.message)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cause, (Object)malformedResponse.cause);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$NetworkError;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fleet.plugins.ai.frontend"})
        public static final class NetworkError
        implements Failure {
            @NotNull
            private final String message;

            public NetworkError(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.message = message2;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final NetworkError copy(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                return new NetworkError(message2);
            }

            public static /* synthetic */ NetworkError copy$default(NetworkError networkError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = networkError.message;
                }
                return networkError.copy(string);
            }

            @NotNull
            public String toString() {
                return "NetworkError(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkError)) {
                    return false;
                }
                NetworkError networkError = (NetworkError)other;
                return Intrinsics.areEqual((Object)this.message, (Object)networkError.message);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$Timeout;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fleet.plugins.ai.frontend"})
        public static final class Timeout
        implements Failure {
            @NotNull
            private final String message;

            public Timeout(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.message = message2;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Timeout copy(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                return new Timeout(message2);
            }

            public static /* synthetic */ Timeout copy$default(Timeout timeout, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = timeout.message;
                }
                return timeout.copy(string);
            }

            @NotNull
            public String toString() {
                return "Timeout(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Timeout)) {
                    return false;
                }
                Timeout timeout = (Timeout)other;
                return Intrinsics.areEqual((Object)this.message, (Object)timeout.message);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure$ValidationError;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Failure;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fleet.plugins.ai.frontend"})
        public static final class ValidationError
        implements Failure {
            @NotNull
            private final String message;

            public ValidationError(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.message = message2;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final ValidationError copy(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                return new ValidationError(message2);
            }

            public static /* synthetic */ ValidationError copy$default(ValidationError validationError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = validationError.message;
                }
                return validationError.copy(string);
            }

            @NotNull
            public String toString() {
                return "ValidationError(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ValidationError)) {
                    return false;
                }
                ValidationError validationError = (ValidationError)other;
                return Intrinsics.areEqual((Object)this.message, (Object)validationError.message);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lfleet/ai/frontend/auth/enterprise/TbaTokenResult$Success;", "Lfleet/ai/frontend/auth/enterprise/TbaTokenResult;", "token", "Lfleet/ai/frontend/auth/enterprise/TbaToken;", "<init>", "(Lfleet/ai/frontend/auth/enterprise/TbaToken;)V", "getToken", "()Lfleet/ai/frontend/auth/enterprise/TbaToken;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fleet.plugins.ai.frontend"})
    public static final class Success
    implements TbaTokenResult {
        @NotNull
        private final TbaToken token;

        public Success(@NotNull TbaToken token2) {
            Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
            this.token = token2;
        }

        @NotNull
        public final TbaToken getToken() {
            return this.token;
        }

        @NotNull
        public final TbaToken component1() {
            return this.token;
        }

        @NotNull
        public final Success copy(@NotNull TbaToken token2) {
            Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
            return new Success(token2);
        }

        public static /* synthetic */ Success copy$default(Success success, TbaToken tbaToken, int n, Object object) {
            if ((n & 1) != 0) {
                tbaToken = success.token;
            }
            return success.copy(tbaToken);
        }

        @NotNull
        public String toString() {
            return "Success(token=" + this.token + ")";
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            return Intrinsics.areEqual((Object)this.token, (Object)success.token);
        }
    }
}

