/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.auth;

import ai.grazie.quota.Quota;
import ai.grazie.utils.mpp.money.Credit;
import ai.grazie.utils.mpp.time.Timestamp;
import androidx.compose.foundation.BackgroundKt;
import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.layout.ColumnKt;
import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.shape.RoundedCornerShapeKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.unit.Dp;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.ai.frontend.api.cloud.AiCloudAuthenticationStatus;
import fleet.ai.frontend.api.cloud.AiCloudAuthenticationStatusKt;
import fleet.ai.frontend.api.cloud.GrazieCloudQuotaStateEntity;
import fleet.ai.frontend.api.cloud.GrazieCloudUserStateEntity;
import fleet.ai.frontend.api.cloud.UrlTiedGrazieToken;
import fleet.ai.frontend.auth.AiLicensePlaquesKt;
import fleet.ai.frontend.auth.MockAuthStatus;
import fleet.ai.frontend.settings.AiSettingsKt;
import fleet.authentication.LicensePlaque;
import fleet.common.license.ProductLicense;
import fleet.common.settings.SettingsEntityKt;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.components.ThemedAnnotatedStringBuilder;
import fleet.compose.theme.keys.TextStyleKeys;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.compose.theme.text.NoriaParagraphStyle;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import noria.NoriaContext;
import noria.ReadScope;
import noria.impl.Runtime;
import noria.model.Theme;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a*\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u001c\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0003\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003\u001a\u0014\u0010\u0013\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0014H\u0003\u001a\u0014\u0010\u0015\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0016H\u0003\u001a\u0014\u0010\u0017\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0018H\u0003\u001a\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"quotaUntil", "", "quota", "Lai/grazie/quota/Quota;", "quotaDaysLeft", "volumeLeft", "plaque", "", "Lnoria/NoriaContext;", "content", "Lkotlin/Function1;", "Landroidx/compose/foundation/layout/ColumnScope;", "Lkotlin/ExtensionFunctionType;", "Landroidx/compose/runtime/Composable;", "aiLicensePlaqueRenderer", "Lfleet/authentication/LicensePlaque;", "proLicensePlaque", "status", "Lfleet/ai/frontend/api/cloud/AiCloudAuthenticationStatus$Authenticated$Pro;", "trialLicensePlaque", "Lfleet/ai/frontend/api/cloud/AiCloudAuthenticationStatus$Authenticated$Trial;", "enterpriseLicensePlaque", "Lfleet/ai/frontend/api/cloud/AiCloudAuthenticationStatus$Authenticated$Enterprise;", "errorLicensePlaque", "Lfleet/ai/frontend/api/cloud/AiCloudAuthenticationStatus$AuthenticationError;", "fleet.plugins.ai.frontend"})
@SourceDebugExtension(value={"SMAP\nAiLicensePlaques.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiLicensePlaques.kt\nfleet/ai/frontend/auth/AiLicensePlaquesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,257:1\n1#2:258\n155#3:259\n155#3:260\n155#3:261\n*S KotlinDebug\n*F\n+ 1 AiLicensePlaques.kt\nfleet/ai/frontend/auth/AiLicensePlaquesKt\n*L\n74#1:259\n77#1:260\n78#1:261\n*E\n"})
public final class AiLicensePlaquesKt {
    private static final String quotaUntil(Quota quota) {
        LocalDate date;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM d, yyyy");
        Timestamp timestamp = quota.getUntil();
        if (timestamp != null) {
            Timestamp it = timestamp;
            boolean bl = false;
            v1 = Instant.ofEpochMilli(it.getMillis()).atZone(ZoneId.systemDefault()).toLocalDate();
        } else {
            v1 = date = null;
        }
        if (date == null) {
            throw new IllegalArgumentException("ai.grazie.quota.Quota.until can't be null in AI Light and AI Pro");
        }
        formatter.format(date);
        String string = date.format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private static final String quotaDaysLeft(Quota quota) {
        long daysLeft;
        LocalDate endDate;
        LocalDate currentDate = LocalDate.now();
        Timestamp timestamp = quota.getUntil();
        if (timestamp != null) {
            Timestamp it = timestamp;
            boolean bl = false;
            v1 = Instant.ofEpochMilli(it.getMillis()).atZone(ZoneId.systemDefault()).toLocalDate();
        } else {
            v1 = endDate = null;
        }
        return endDate != null ? daysLeft + " day" + ((daysLeft = Duration.between(currentDate.atStartOfDay(), endDate.atStartOfDay()).toDays()) == 1L ? "" : "s") : "";
    }

    private static final String volumeLeft(Quota quota) {
        return quota.getMaximum().getAmount().isZero() ? "0%" : 100 - MathKt.roundToInt((double)(quota.getCurrent().getAmount().asDouble() / quota.getMaximum().getAmount().asDouble() * (double)100)) + "%";
    }

    @Composable
    private static final void plaque(NoriaContext $this$plaque, Function1<? super ColumnScope, Unit> content2) {
        int $this$dp$iv = 8;
        boolean $i$f$getDp = false;
        Arrangement.Vertical vertical = Arrangement.INSTANCE.spacedBy-D5KLDUw(Dp.constructor-impl((float)$this$dp$iv), Alignment.Companion.getTop());
        Alignment.Horizontal horizontal = Alignment.Companion.getStart();
        int $this$dp$iv2 = 4;
        boolean $i$f$getDp2 = false;
        Modifier modifier = BackgroundKt.background-bw27NRU((Modifier)((Modifier)Modifier.Companion), (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$plaque)).get(ThemeKeys.INSTANCE.getBackgroundSecondary())).unbox-impl(), (Shape)((Shape)RoundedCornerShapeKt.RoundedCornerShape-0680j_4((float)Dp.constructor-impl((float)$this$dp$iv2))));
        $this$dp$iv2 = 12;
        $i$f$getDp2 = false;
        float f = Dp.constructor-impl((float)$this$dp$iv2);
        $this$dp$iv2 = 8;
        $i$f$getDp2 = false;
        float f2 = Dp.constructor-impl((float)$this$dp$iv2);
        $this$dp$iv2 = 8;
        $i$f$getDp2 = false;
        float f3 = Dp.constructor-impl((float)$this$dp$iv2);
        $this$dp$iv2 = 10;
        $i$f$getDp2 = false;
        Modifier modifier2 = PaddingKt.padding-qDBjuR0((Modifier)modifier, (float)f, (float)f2, (float)f3, (float)Dp.constructor-impl((float)$this$dp$iv2));
        Runtime.enterScope((NoriaContext)$this$plaque, (int)35);
        Object[] objectArray = new Object[]{content2};
        ColumnKt.Column$default((NoriaContext)$this$plaque, (Modifier)modifier2, (Arrangement.Vertical)vertical, (Alignment.Horizontal)horizontal, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<ColumnScope, Unit>(content2){
            final /* synthetic */ Function1<ColumnScope, Unit> $content;
            {
                this.$content = $content;
                super(1);
            }

            public final void invoke(ColumnScope $this$Column) {
                Intrinsics.checkNotNullParameter((Object)$this$Column, (String)"$this$Column");
                this.$content.invoke((Object)$this$Column);
            }
        })), (int)8, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$plaque);
    }

    @NotNull
    public static final LicensePlaque aiLicensePlaqueRenderer() {
        Function1 function1 = (Function1)Runtime.closure((Object[])new Object[0], (Object)((Object)aiLicensePlaqueRenderer.1.INSTANCE));
        return new LicensePlaque(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                this.function = function2;
            }

            public final /* synthetic */ void render(NoriaContext $this$render) {
                this.function.invoke((Object)$this$render);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof LicensePlaque ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        };
    }

    @Composable
    private static final void proLicensePlaque(NoriaContext $this$proLicensePlaque, AiCloudAuthenticationStatus.Authenticated.Pro status) {
        Runtime.enterScope((NoriaContext)$this$proLicensePlaque, (int)43);
        Object[] objectArray = new Object[]{status};
        AiLicensePlaquesKt.plaque($this$proLicensePlaque, (Function1<? super ColumnScope, Unit>)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<ColumnScope, Unit>(status){
            final /* synthetic */ AiCloudAuthenticationStatus.Authenticated.Pro $status;
            {
                this.$status = $status;
                super(1);
            }

            public final void invoke(ColumnScope $this$plaque) {
                Intrinsics.checkNotNullParameter((Object)$this$plaque, (String)"$this$plaque");
                Theme theme = (Theme)$this$plaque.getCurrent((CompositionLocal)CompositionLocalsKt.getLocalTheme());
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$plaque), (int)41);
                AnnotatedString annotatedString = TextKt.buildThemedAnnotatedString((NoriaContext)((NoriaContext)$this$plaque), (Function1)((Function1)new Function1<ThemedAnnotatedStringBuilder, Unit>($this$plaque, this.$status, theme){
                    final /* synthetic */ ColumnScope $this_plaque;
                    final /* synthetic */ AiCloudAuthenticationStatus.Authenticated.Pro $status;
                    final /* synthetic */ Theme $theme;
                    {
                        this.$this_plaque = $this_plaque;
                        this.$status = $status;
                        this.$theme = $theme;
                        super(1);
                    }

                    public final void invoke(ThemedAnnotatedStringBuilder $this$buildThemedAnnotatedString) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildThemedAnnotatedString, (String)"$this$buildThemedAnnotatedString");
                        ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"JetBrains AI Pro\n", null, null, null, null, null, null, null, (int)254, null);
                        Object object = this.$this_plaque;
                        Runtime.enterScope((NoriaContext)((NoriaContext)object), (int)40);
                        Object object2 = AiLicensePlaquesKt.access$quota((NoriaContext)object);
                        Runtime.exitScope((NoriaContext)((NoriaContext)object));
                        Quota quota = object2;
                        if (quota != null) {
                            ProductLicense productLicense;
                            object2 = this.$status;
                            if (object2 instanceof AiCloudAuthenticationStatus.Authenticated.Pro.Active) {
                                productLicense = ((AiCloudAuthenticationStatus.Authenticated.Pro.Active)this.$status).getProductLicense();
                            } else if (object2 instanceof AiCloudAuthenticationStatus.Authenticated.Pro.Expired) {
                                productLicense = ((AiCloudAuthenticationStatus.Authenticated.Pro.Expired)this.$status).getProductLicense();
                            } else if (object2 instanceof AiCloudAuthenticationStatus.Authenticated.Pro.OutOfCredits) {
                                productLicense = ((AiCloudAuthenticationStatus.Authenticated.Pro.OutOfCredits)this.$status).getProductLicense();
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            boolean autoProlongated = productLicense.getAutoProlongated();
                            String until = AiLicensePlaquesKt.access$quotaUntil(quota);
                            String string = autoProlongated ? "Subscription will be prolonged on " + until + "\n" : (this.$status instanceof AiCloudAuthenticationStatus.Authenticated.Pro.Expired ? "Subscription has ended on " + until + "\n" : "Subscription ends on " + until + "\n");
                            long l = ((Color)this.$theme.get(ThemeKeys.INSTANCE.getTextSecondary())).unbox-impl();
                            ThemeKey themeKey = TextStyleKeys.INSTANCE.getSmall();
                            ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)string, (ThemeKey)themeKey, null, (Color)Color.box-impl((long)l), null, null, null, null, (int)244, null);
                        }
                        if ((object = this.$status) instanceof AiCloudAuthenticationStatus.Authenticated.Pro.Active) {
                            ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Manage License\u2026", null, null, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Url("https://account.jetbrains.com/licenses")), (int)126, null);
                        } else if (object instanceof AiCloudAuthenticationStatus.Authenticated.Pro.Expired) {
                            ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"License has expired. ", null, null, (Color)((Color)this.$theme.get(ThemeKeys.INSTANCE.getTextDangerous())), null, null, null, null, (int)246, null);
                            ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Renew License\u2026", null, null, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Url("https://account.jetbrains.com/licenses")), (int)126, null);
                        } else if (object instanceof AiCloudAuthenticationStatus.Authenticated.Pro.OutOfCredits) {
                            ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"No volume left. ", null, null, (Color)((Color)this.$theme.get(ThemeKeys.INSTANCE.getTextDangerous())), null, null, null, null, (int)246, null);
                            ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Contact Support\u2026", null, null, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Url("http://jb.gg/ai-assistant/limit-reached")), (int)126, null);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }));
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$plaque));
                AnnotatedString text2 = annotatedString;
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$plaque), (int)42);
                TextKt.UiText-uuipMMg$default((NoriaContext)((NoriaContext)$this$plaque), (AnnotatedString)text2, (long)0L, (ThemeKey)TextStyleKeys.INSTANCE.getDefaultMultiline(), (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, null, null, null, (int)2034, null);
                annotatedString = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$plaque));
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$proLicensePlaque);
    }

    @Composable
    private static final void trialLicensePlaque(NoriaContext $this$trialLicensePlaque, AiCloudAuthenticationStatus.Authenticated.Trial status) {
        Runtime.enterScope((NoriaContext)$this$trialLicensePlaque, (int)47);
        Object[] objectArray = new Object[]{status};
        AiLicensePlaquesKt.plaque($this$trialLicensePlaque, (Function1<? super ColumnScope, Unit>)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<ColumnScope, Unit>(status){
            final /* synthetic */ AiCloudAuthenticationStatus.Authenticated.Trial $status;
            {
                this.$status = $status;
                super(1);
            }

            public final void invoke(ColumnScope $this$plaque) {
                Intrinsics.checkNotNullParameter((Object)$this$plaque, (String)"$this$plaque");
                Theme theme = (Theme)$this$plaque.getCurrent((CompositionLocal)CompositionLocalsKt.getLocalTheme());
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$plaque), (int)45);
                AnnotatedString annotatedString = TextKt.buildThemedAnnotatedString((NoriaContext)((NoriaContext)$this$plaque), (Function1)((Function1)new Function1<ThemedAnnotatedStringBuilder, Unit>($this$plaque, this.$status, theme){
                    final /* synthetic */ ColumnScope $this_plaque;
                    final /* synthetic */ AiCloudAuthenticationStatus.Authenticated.Trial $status;
                    final /* synthetic */ Theme $theme;
                    {
                        this.$this_plaque = $this_plaque;
                        this.$status = $status;
                        this.$theme = $theme;
                        super(1);
                    }

                    public final void invoke(ThemedAnnotatedStringBuilder $this$buildThemedAnnotatedString) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildThemedAnnotatedString, (String)"$this$buildThemedAnnotatedString");
                        ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"JetBrains AI Trial\n", null, null, null, null, null, null, null, (int)254, null);
                        ColumnScope columnScope = this.$this_plaque;
                        Runtime.enterScope((NoriaContext)((NoriaContext)columnScope), (int)44);
                        Quota quota = AiLicensePlaquesKt.access$quota((NoriaContext)columnScope);
                        Runtime.exitScope((NoriaContext)((NoriaContext)columnScope));
                        Quota quota2 = quota;
                        if (quota2 != null) {
                            String until = AiLicensePlaquesKt.access$quotaUntil(quota2);
                            String daysLeft = AiLicensePlaquesKt.access$quotaDaysLeft(quota2);
                            Object object = this.$status instanceof AiCloudAuthenticationStatus.Authenticated.Trial.Expired ? "Trial has ended on " + until + "\n" : "Trial ends in " + daysLeft + ", " + AiLicensePlaquesKt.access$volumeLeft(quota2) + " of volume left\n";
                            long l = ((Color)this.$theme.get(ThemeKeys.INSTANCE.getTextSecondary())).unbox-impl();
                            ThemeKey themeKey = TextStyleKeys.INSTANCE.getSmall();
                            ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)object, (ThemeKey)themeKey, null, (Color)Color.box-impl((long)l), null, null, null, null, (int)244, null);
                            object = this.$status;
                            if (object instanceof AiCloudAuthenticationStatus.Authenticated.Trial.Active) {
                                ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Manage License\u2026", null, null, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Url("https://account.jetbrains.com/licenses")), (int)126, null);
                            } else if (object instanceof AiCloudAuthenticationStatus.Authenticated.Trial.Expired) {
                                ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Trial has ended. ", null, null, (Color)((Color)this.$theme.get(ThemeKeys.INSTANCE.getTextDangerous())), null, null, null, null, (int)246, null);
                                ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Get Pro License\u2026", null, null, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Url("https://account.jetbrains.com/licenses")), (int)126, null);
                            } else if (object instanceof AiCloudAuthenticationStatus.Authenticated.Trial.OutOfCredits) {
                                ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"No volume left. ", null, null, (Color)((Color)this.$theme.get(ThemeKeys.INSTANCE.getTextDangerous())), null, null, null, null, (int)246, null);
                                ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Get Pro License\u2026", null, null, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Url("https://account.jetbrains.com/licenses")), (int)126, null);
                            }
                        } else if (this.$status instanceof AiCloudAuthenticationStatus.Authenticated.Trial.WaitingForConsent) {
                            ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Agree with ", null, null, null, null, null, null, null, (int)254, null);
                            ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Terms of Service", null, null, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Clickable("Terms of Service")), (int)126, null);
                            ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)" to start the trial", null, null, null, null, null, null, null, (int)254, null);
                        }
                    }
                }));
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$plaque));
                AnnotatedString text2 = annotatedString;
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$plaque), (int)46);
                TextKt.UiText-uuipMMg$default((NoriaContext)((NoriaContext)$this$plaque), (AnnotatedString)text2, (long)0L, (ThemeKey)TextStyleKeys.INSTANCE.getDefaultMultiline(), (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, null, null, (Function2)((Function2)Runtime.closure((Object[])new Object[0], (Object)((Object)trialLicensePlaque.1.INSTANCE))), (int)1010, null);
                annotatedString = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$plaque));
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$trialLicensePlaque);
    }

    @Composable
    private static final void enterpriseLicensePlaque(NoriaContext $this$enterpriseLicensePlaque, AiCloudAuthenticationStatus.Authenticated.Enterprise status) {
        Runtime.enterScope((NoriaContext)$this$enterpriseLicensePlaque, (int)50);
        Object[] objectArray = new Object[]{status};
        AiLicensePlaquesKt.plaque($this$enterpriseLicensePlaque, (Function1<? super ColumnScope, Unit>)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<ColumnScope, Unit>(status){
            final /* synthetic */ AiCloudAuthenticationStatus.Authenticated.Enterprise $status;
            {
                this.$status = $status;
                super(1);
            }

            public final void invoke(ColumnScope $this$plaque) {
                Intrinsics.checkNotNullParameter((Object)$this$plaque, (String)"$this$plaque");
                Theme theme = (Theme)$this$plaque.getCurrent((CompositionLocal)CompositionLocalsKt.getLocalTheme());
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$plaque), (int)48);
                AnnotatedString annotatedString = TextKt.buildThemedAnnotatedString((NoriaContext)((NoriaContext)$this$plaque), (Function1)((Function1)new Function1<ThemedAnnotatedStringBuilder, Unit>(this.$status, theme){
                    final /* synthetic */ AiCloudAuthenticationStatus.Authenticated.Enterprise $status;
                    final /* synthetic */ Theme $theme;
                    {
                        this.$status = $status;
                        this.$theme = $theme;
                        super(1);
                    }

                    public final void invoke(ThemedAnnotatedStringBuilder $this$buildThemedAnnotatedString) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildThemedAnnotatedString, (String)"$this$buildThemedAnnotatedString");
                        ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"JetBrains AI Enterprise\n", null, null, null, null, null, null, null, (int)254, null);
                        String string = "Managed by " + this.$status.getCompanyName() + "\n";
                        long l = ((Color)this.$theme.get(ThemeKeys.INSTANCE.getTextSecondary())).unbox-impl();
                        ThemeKey themeKey = TextStyleKeys.INSTANCE.getSmall();
                        ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)string, (ThemeKey)themeKey, null, (Color)Color.box-impl((long)l), null, null, null, null, (int)244, null);
                        if (this.$status instanceof AiCloudAuthenticationStatus.Authenticated.Enterprise.Prohibited) {
                            ThemedAnnotatedStringBuilder.text-x3qM97A$default((ThemedAnnotatedStringBuilder)$this$buildThemedAnnotatedString, (String)"Prohibited by your organization.", null, null, (Color)((Color)this.$theme.get(ThemeKeys.INSTANCE.getTextDangerous())), null, null, null, null, (int)246, null);
                        }
                    }
                }));
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$plaque));
                AnnotatedString text2 = annotatedString;
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$plaque), (int)49);
                TextKt.UiText-uuipMMg$default((NoriaContext)((NoriaContext)$this$plaque), (AnnotatedString)text2, (long)0L, (ThemeKey)TextStyleKeys.INSTANCE.getDefaultMultiline(), (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, null, null, null, (int)2034, null);
                annotatedString = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$plaque));
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$enterpriseLicensePlaque);
    }

    @Composable
    private static final void errorLicensePlaque(NoriaContext $this$errorLicensePlaque, AiCloudAuthenticationStatus.AuthenticationError status) {
        Runtime.enterScope((NoriaContext)$this$errorLicensePlaque, (int)51);
        AiLicensePlaquesKt.plaque($this$errorLicensePlaque, (Function1<? super ColumnScope, Unit>)((Function1)Runtime.closure((Object[])new Object[0], (Object)((Object)errorLicensePlaque.1.INSTANCE))));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$errorLicensePlaque);
    }

    private static final Quota quota(NoriaContext $this$quota) {
        UrlTiedGrazieToken token2;
        AiCloudAuthenticationStatus status = AiCloudAuthenticationStatusKt.obtainAiCloudAuthenticationStatus$default(false, 1, null);
        UrlTiedGrazieToken urlTiedGrazieToken = status instanceof AiCloudAuthenticationStatus.Authenticated.Pro.Active ? ((AiCloudAuthenticationStatus.Authenticated.Pro.Active)status).getToken() : (status instanceof AiCloudAuthenticationStatus.Authenticated.Pro.OutOfCredits ? ((AiCloudAuthenticationStatus.Authenticated.Pro.OutOfCredits)status).getToken() : (status instanceof AiCloudAuthenticationStatus.Authenticated.Pro.Expired ? ((AiCloudAuthenticationStatus.Authenticated.Pro.Expired)status).getToken() : (status instanceof AiCloudAuthenticationStatus.Authenticated.Trial.Active ? ((AiCloudAuthenticationStatus.Authenticated.Trial.Active)status).getToken() : (status instanceof AiCloudAuthenticationStatus.Authenticated.Trial.OutOfCredits ? ((AiCloudAuthenticationStatus.Authenticated.Trial.OutOfCredits)status).getToken() : (token2 = status instanceof AiCloudAuthenticationStatus.Authenticated.Trial.Expired ? ((AiCloudAuthenticationStatus.Authenticated.Trial.Expired)status).getToken() : null)))));
        if (token2 == null) {
            return null;
        }
        GrazieCloudUserStateEntity grazieCloudUserStateEntity = (GrazieCloudUserStateEntity)CollectionsKt.singleOrNull((Iterable)EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)GrazieCloudUserStateEntity.Companion.getToken()), (Object)token2));
        if (grazieCloudUserStateEntity == null) {
            return null;
        }
        GrazieCloudUserStateEntity userState2 = grazieCloudUserStateEntity;
        GrazieCloudQuotaStateEntity grazieCloudQuotaStateEntity = (GrazieCloudQuotaStateEntity)CollectionsKt.singleOrNull((Iterable)EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)GrazieCloudQuotaStateEntity.Companion.getUserState()), (Object)userState2));
        if (grazieCloudQuotaStateEntity == null) {
            return null;
        }
        GrazieCloudQuotaStateEntity quotaState = grazieCloudQuotaStateEntity;
        Quota quota = quotaState.getQuota();
        return switch (WhenMappings.$EnumSwitchMapping$0[((MockAuthStatus)((Object)SettingsEntityKt.querySettingsKey$default(AiSettingsKt.getAiSettingDebugMockAuthStatus(), null, null, (int)6, null))).ordinal()]) {
            case 1 -> Quota.copy$default((Quota)quota, null, null, null, (Timestamp)Timestamp.Companion.epoch(), null, (int)23, null);
            case 2 -> Quota.copy$default((Quota)quota, null, null, null, (Timestamp)Timestamp.Companion.epoch(), null, (int)23, null);
            case 3 -> Quota.copy$default((Quota)quota, null, (Credit)Credit.Companion.getZERO(), (Credit)Credit.Companion.getZERO(), null, null, (int)25, null);
            case 4 -> Quota.copy$default((Quota)quota, null, (Credit)Credit.Companion.getZERO(), (Credit)Credit.Companion.getZERO(), null, null, (int)25, null);
            default -> quota;
        };
    }

    public static final /* synthetic */ void access$proLicensePlaque(NoriaContext $receiver, AiCloudAuthenticationStatus.Authenticated.Pro status) {
        AiLicensePlaquesKt.proLicensePlaque($receiver, status);
    }

    public static final /* synthetic */ void access$trialLicensePlaque(NoriaContext $receiver, AiCloudAuthenticationStatus.Authenticated.Trial status) {
        AiLicensePlaquesKt.trialLicensePlaque($receiver, status);
    }

    public static final /* synthetic */ void access$enterpriseLicensePlaque(NoriaContext $receiver, AiCloudAuthenticationStatus.Authenticated.Enterprise status) {
        AiLicensePlaquesKt.enterpriseLicensePlaque($receiver, status);
    }

    public static final /* synthetic */ void access$errorLicensePlaque(NoriaContext $receiver, AiCloudAuthenticationStatus.AuthenticationError status) {
        AiLicensePlaquesKt.errorLicensePlaque($receiver, status);
    }

    public static final /* synthetic */ Quota access$quota(NoriaContext $receiver) {
        return AiLicensePlaquesKt.quota($receiver);
    }

    public static final /* synthetic */ String access$quotaUntil(Quota quota) {
        return AiLicensePlaquesKt.quotaUntil(quota);
    }

    public static final /* synthetic */ String access$quotaDaysLeft(Quota quota) {
        return AiLicensePlaquesKt.quotaDaysLeft(quota);
    }

    public static final /* synthetic */ String access$volumeLeft(Quota quota) {
        return AiLicensePlaquesKt.volumeLeft(quota);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MockAuthStatus.values().length];
            try {
                nArray[MockAuthStatus.ProExpired.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MockAuthStatus.TrialExpired.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MockAuthStatus.ProOutOfCredits.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MockAuthStatus.TrialOutOfCredits.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

