/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.yank;

import com.maddyhome.idea.vim.action.motion.updown.MotionDownLess1FirstNonSpaceAction;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.listener.VimYankListener;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.yank.VimYankGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J,\u0010\t\u001a\u0004\u0018\u00010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J(\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J*\u0010 \u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0007H\u0016JJ\u0010 \u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\n0$2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u000e\u0018\u00010$H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/maddyhome/idea/vim/yank/YankGroupBase;", "Lcom/maddyhome/idea/vim/yank/VimYankGroup;", "()V", "yankListeners", "", "Lcom/maddyhome/idea/vim/listener/VimYankListener;", "addListener", "", "listener", "getTextRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "ranges", "", "Lkotlin/Pair;", "", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "notifyListeners", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "textRange", "removeListener", "yankLine", "count", "yankMotion", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "yankRange", "range", "moveCursor", "caretToRange", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "startOffsets", "Lcom/maddyhome/idea/vim/api/VimCaret;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nYankGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YankGroupBase.kt\ncom/maddyhome/idea/vim/yank/YankGroupBase\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n215#2,2:199\n1855#3,2:201\n*S KotlinDebug\n*F\n+ 1 YankGroupBase.kt\ncom/maddyhome/idea/vim/yank/YankGroupBase\n*L\n37#1:199,2\n194#1:201,2\n*E\n"})
public class YankGroupBase
implements VimYankGroup {
    @NotNull
    private final List<VimYankListener> yankListeners = new ArrayList();

    private final boolean yankRange(VimEditor editor, Map<ImmutableVimCaret, TextRange> caretToRange, TextRange range, SelectionType type, Map<VimCaret, Integer> startOffsets) {
        Map<VimCaret, Integer> map = startOffsets;
        if (map != null) {
            Map<VimCaret, Integer> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<VimCaret, Integer>> object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<VimCaret, Integer> element$iv;
                Map.Entry<VimCaret, Integer> entry = element$iv = object.next();
                boolean bl = false;
                VimCaret caret = entry.getKey();
                int offset = ((Number)entry.getValue()).intValue();
                caret.moveToOffset(offset);
            }
        }
        this.notifyListeners(editor, range);
        boolean result = true;
        for (Map.Entry<ImmutableVimCaret, TextRange> entry : caretToRange.entrySet()) {
            ImmutableVimCaret caret = entry.getKey();
            TextRange myRange = entry.getValue();
            result = caret.getRegisterStorage().storeText(editor, myRange, type, false) && result;
        }
        return result;
    }

    @Contract(value="_, _ -> new")
    @Nullable
    protected final TextRange getTextRange(@NotNull List<Pair<Integer, Integer>> ranges, @NotNull SelectionType type) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (ranges.isEmpty()) {
            return null;
        }
        int size = ranges.size();
        int[] starts = new int[size];
        int[] ends = new int[size];
        if (type == SelectionType.LINE_WISE) {
            starts[size - 1] = ((Number)ranges.get(size - 1).getFirst()).intValue();
            ends[size - 1] = ((Number)ranges.get(size - 1).getSecond()).intValue();
            int n = size - 1;
            for (int i = 0; i < n; ++i) {
                Pair<Integer, Integer> range = ranges.get(i);
                starts[i] = ((Number)range.getFirst()).intValue();
                ends[i] = ((Number)range.getSecond()).intValue() - 1;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Pair<Integer, Integer> range = ranges.get(i);
                starts[i] = ((Number)range.getFirst()).intValue();
                ends[i] = ((Number)range.getSecond()).intValue();
            }
        }
        return new TextRange(starts, ends);
    }

    @Override
    public boolean yankMotion(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Command motion = argument.getMotion();
        SelectionType type = motion.isLinewiseMotion() ? SelectionType.LINE_WISE : SelectionType.CHARACTER_WISE;
        int nativeCaretCount = editor.nativeCarets().size();
        if (nativeCaretCount <= 0) {
            return false;
        }
        HashMap caretToRange = new HashMap(nativeCaretCount);
        ArrayList<Pair> ranges = new ArrayList<Pair>(nativeCaretCount);
        HashMap<VimCaret, Integer> startOffsets = argument.getMotion().getAction() instanceof MotionDownLess1FirstNonSpaceAction ? null : new HashMap<VimCaret, Integer>(nativeCaretCount);
        for (VimCaret caret : editor.nativeCarets()) {
            TextRange motionRange;
            boolean bl;
            if (VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments) == null) continue;
            boolean bl2 = bl = motionRange.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ranges.add(TuplesKt.to((Object)motionRange.getStartOffset(), (Object)motionRange.getEndOffset()));
            HashMap<VimCaret, Integer> hashMap = startOffsets;
            if (hashMap != null) {
                hashMap.put(caret, motionRange.normalize().getStartOffset());
            }
            ((Map)caretToRange).put(caret, new TextRange(motionRange.getStartOffset(), motionRange.getEndOffset()));
        }
        TextRange textRange = this.getTextRange((List<Pair<Integer, Integer>>)ranges, type);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        if (range.size() == 0) {
            return false;
        }
        return this.yankRange(editor, caretToRange, range, type, (Map<VimCaret, Integer>)startOffsets);
    }

    @Override
    public boolean yankLine(@NotNull VimEditor editor, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int caretCount = editor.nativeCarets().size();
        ArrayList<Pair> ranges = new ArrayList<Pair>(caretCount);
        HashMap caretToRange = new HashMap(caretCount);
        for (VimCaret caret : editor.nativeCarets()) {
            int start2 = VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret);
            int end = Math.min(VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEnd(editor, caret, count - 1, true) + 1, (int)editor.fileSize());
            if (end == -1) continue;
            ranges.add(TuplesKt.to((Object)start2, (Object)end));
            ((Map)caretToRange).put(caret, new TextRange(start2, end));
        }
        TextRange textRange = this.getTextRange((List<Pair<Integer, Integer>>)ranges, SelectionType.LINE_WISE);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        return this.yankRange(editor, caretToRange, range, SelectionType.LINE_WISE, null);
    }

    @Override
    public boolean yankRange(@NotNull VimEditor editor, @Nullable TextRange range, @NotNull SelectionType type, boolean moveCursor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (range == null) {
            return false;
        }
        HashMap caretToRange = new HashMap();
        if (type == SelectionType.LINE_WISE) {
            int n = range.size();
            for (int i = 0; i < n; ++i) {
                if (editor.offsetToBufferPosition(range.getStartOffsets()[i]).getColumn() != 0) {
                    range.getStartOffsets()[i] = EngineEditorHelperKt.getLineStartForOffset(editor, range.getStartOffsets()[i]);
                }
                if (editor.offsetToBufferPosition(range.getEndOffsets()[i]).getColumn() == 0) continue;
                range.getEndOffsets()[i] = RangesKt.coerceAtMost((int)(EngineEditorHelperKt.getLineEndForOffset(editor, range.getEndOffsets()[i]) + 1), (int)((int)editor.fileSize()));
            }
        }
        int[] rangeStartOffsets = range.getStartOffsets();
        int[] rangeEndOffsets = range.getEndOffsets();
        HashMap startOffsets = new HashMap(editor.nativeCarets().size());
        if (type == SelectionType.BLOCK_WISE) {
            ((Map)startOffsets).put(editor.primaryCaret(), range.normalize().getStartOffset());
            ((Map)caretToRange).put(editor.primaryCaret(), range);
        } else {
            Iterator<VimCaret> iterator = editor.nativeCarets().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                VimCaret caret = iterator.next();
                TextRange textRange = new TextRange(rangeStartOffsets[i], rangeEndOffsets[i]);
                ((Map)startOffsets).put(caret, textRange.normalize().getStartOffset());
                ((Map)caretToRange).put(caret, textRange);
            }
        }
        return moveCursor ? this.yankRange(editor, caretToRange, range, type, startOffsets) : this.yankRange(editor, caretToRange, range, type, null);
    }

    @Override
    public boolean addListener(@NotNull VimYankListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.yankListeners.add(listener);
    }

    @Override
    public boolean removeListener(@NotNull VimYankListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.yankListeners.remove(listener);
    }

    @Override
    public void notifyListeners(@NotNull VimEditor editor, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Iterable $this$forEach$iv = this.yankListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimYankListener it = (VimYankListener)element$iv;
            boolean bl = false;
            it.yankPerformed(editor, textRange);
        }
    }
}

