/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions.handlers;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.handlers.JoinFunctionHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/handlers/JoinFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "()V", "maximumNumberOfArguments", "", "getMaximumNumberOfArguments", "()Ljava/lang/Integer;", "minimumNumberOfArguments", "getMinimumNumberOfArguments", "doFunction", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "argumentValues", "", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "vim-engine"})
public final class JoinFunctionHandler
extends FunctionHandler {
    private final int minimumNumberOfArguments;
    private final int maximumNumberOfArguments;

    public JoinFunctionHandler() {
        this.minimumNumberOfArguments = 1;
        this.maximumNumberOfArguments = 2;
    }

    @Override
    @NotNull
    public Integer getMinimumNumberOfArguments() {
        return this.minimumNumberOfArguments;
    }

    @Override
    @NotNull
    public Integer getMaximumNumberOfArguments() {
        return this.maximumNumberOfArguments;
    }

    @Override
    @NotNull
    protected VimDataType doFunction(@NotNull List<? extends Expression> argumentValues, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter(argumentValues, (String)"argumentValues");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType firstArgument = argumentValues.get(0).evaluate(editor, context, vimContext);
        if (!(firstArgument instanceof VimList)) {
            throw new ExException("E714: List required");
        }
        Object object = (Expression)CollectionsKt.getOrNull(argumentValues, (int)1);
        if (object == null || (object = ((Expression)object).evaluate(editor, context, vimContext)) == null) {
            object = new VimString(" ");
        }
        Object secondArgument = object;
        return new VimString(CollectionsKt.joinToString$default((Iterable)((VimList)firstArgument).getValues(), (CharSequence)((VimDataType)secondArgument).asString(), null, null, (int)0, null, (Function1)doFunction.1.INSTANCE, (int)30, null));
    }
}

