/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions.handlers;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFuncref;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.handlers.FunctionFunctionHandlerKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/handlers/FunctionFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "()V", "maximumNumberOfArguments", "", "getMaximumNumberOfArguments", "()Ljava/lang/Integer;", "minimumNumberOfArguments", "getMinimumNumberOfArguments", "doFunction", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimFuncref;", "argumentValues", "", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "vim-engine"})
public final class FunctionFunctionHandler
extends FunctionHandler {
    private final int minimumNumberOfArguments;
    private final int maximumNumberOfArguments;

    public FunctionFunctionHandler() {
        this.minimumNumberOfArguments = 1;
        this.maximumNumberOfArguments = 3;
    }

    @Override
    @NotNull
    public Integer getMinimumNumberOfArguments() {
        return this.minimumNumberOfArguments;
    }

    @Override
    @NotNull
    public Integer getMaximumNumberOfArguments() {
        return this.maximumNumberOfArguments;
    }

    @Override
    @NotNull
    protected VimFuncref doFunction(@NotNull List<? extends Expression> argumentValues, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        VimDataType arg3;
        Intrinsics.checkNotNullParameter(argumentValues, (String)"argumentValues");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType arg1 = argumentValues.get(0).evaluate(editor, context, vimContext);
        if (!(arg1 instanceof VimString)) {
            throw new ExException("E129: Function name required");
        }
        Pair scopeAndName = FunctionFunctionHandlerKt.access$extractScopeAndName(((VimString)arg1).getValue());
        FunctionHandler functionHandler = VimInjectorKt.getInjector().getFunctionService().getFunctionHandlerOrNull((Scope)((Object)scopeAndName.getFirst()), (String)scopeAndName.getSecond(), vimContext);
        if (functionHandler == null) {
            Object object;
            if (scopeAndName.getFirst() != null) {
                Object object2 = scopeAndName.getFirst();
                Intrinsics.checkNotNull((Object)object2);
                object = ((Scope)((Object)object2)).getC() + ":";
            } else {
                object = "";
            }
            throw new ExException("E700: Unknown function: " + (String)object + scopeAndName.getSecond());
        }
        FunctionHandler function = functionHandler;
        VimList arglist = null;
        VimDictionary dictionary = null;
        Expression expression = (Expression)CollectionsKt.getOrNull(argumentValues, (int)1);
        VimDataType arg2 = expression != null ? expression.evaluate(editor, context, vimContext) : null;
        Expression expression2 = (Expression)CollectionsKt.getOrNull(argumentValues, (int)2);
        VimDataType vimDataType = arg3 = expression2 != null ? expression2.evaluate(editor, context, vimContext) : null;
        if (arg2 instanceof VimDictionary && arg3 instanceof VimDictionary) {
            throw new ExException("E923: Second argument of function() must be a list or a dict");
        }
        if (arg2 != null) {
            VimDataType vimDataType2 = arg2;
            if (vimDataType2 instanceof VimList) {
                arglist = (VimList)arg2;
            } else if (vimDataType2 instanceof VimDictionary) {
                dictionary = (VimDictionary)arg2;
            } else {
                throw new ExException("E923: Second argument of function() must be a list or a dict");
            }
        }
        if (arg3 != null && !(arg3 instanceof VimDictionary)) {
            throw new ExException("E922: expected a dict");
        }
        VimList vimList = arglist;
        if (vimList == null) {
            vimList = new VimList(new ArrayList());
        }
        VimFuncref funcref = new VimFuncref(function, vimList, dictionary, VimFuncref.Type.FUNCTION);
        if (dictionary != null) {
            funcref.setSelfFixed(true);
        }
        return funcref;
    }
}

