/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J.\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H$J,\u0010'\u001a\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "", "()V", "maximumNumberOfArguments", "", "getMaximumNumberOfArguments", "()Ljava/lang/Integer;", "minimumNumberOfArguments", "getMinimumNumberOfArguments", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "setRanges", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;)V", "scope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "getScope", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "checkFunctionCall", "", "arguments", "", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "doFunction", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "argumentValues", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "executeFunction", "vim-engine"})
public abstract class FunctionHandler {
    public String name;
    @Nullable
    private final Scope scope;
    @Nullable
    private Ranges ranges;

    @NotNull
    public final String getName() {
        String string = this.name;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"name");
        return null;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    @Nullable
    public abstract Integer getMinimumNumberOfArguments();

    @Nullable
    public abstract Integer getMaximumNumberOfArguments();

    @Nullable
    public final Ranges getRanges() {
        return this.ranges;
    }

    public final void setRanges(@Nullable Ranges ranges) {
        this.ranges = ranges;
    }

    @NotNull
    protected abstract VimDataType doFunction(@NotNull List<? extends Expression> var1, @NotNull VimEditor var2, @NotNull ExecutionContext var3, @NotNull VimLContext var4);

    @NotNull
    public final VimDataType executeFunction(@NotNull List<? extends Expression> arguments, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        this.checkFunctionCall(arguments);
        VimDataType result = this.doFunction(arguments, editor, context, vimContext);
        this.ranges = null;
        return result;
    }

    private final void checkFunctionCall(List<? extends Expression> arguments) {
        if (this.getMinimumNumberOfArguments() != null) {
            int n = arguments.size();
            Integer n2 = this.getMinimumNumberOfArguments();
            Intrinsics.checkNotNull((Object)n2);
            if (n < n2) {
                throw new ExException("E119: Not enough arguments for function: " + this.getName());
            }
        }
        if (this.getMaximumNumberOfArguments() != null) {
            int n = arguments.size();
            Integer n3 = this.getMaximumNumberOfArguments();
            Intrinsics.checkNotNull((Object)n3);
            if (n > n3) {
                throw new ExException("E118: Too many arguments for function: " + this.getName());
            }
        }
    }
}

