/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.FinishException;
import com.maddyhome.idea.vim.ex.ranges.LineNumberRange;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.expressions.Variable;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionDeclaration;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionFlag;
import com.maddyhome.idea.vim.vimscript.services.VariableService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J.\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J8\u0010$\u001a\u0004\u0018\u00010\u00162\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\t\u0010*\u001a\u00020\nH\u00d6\u0001J.\u0010+\u001a\u00020,2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001fH\u0002J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00060"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/DefinedFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "function", "Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;", "(Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;)V", "getFunction", "()Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "maximumNumberOfArguments", "", "getMaximumNumberOfArguments", "()Ljava/lang/Integer;", "minimumNumberOfArguments", "getMinimumNumberOfArguments", "scope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "getScope", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "component1", "copy", "doFunction", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "argumentValues", "", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "equals", "", "other", "", "executeBodyForLine", "line", "isRangeGiven", "exceptionsCaught", "", "Lcom/maddyhome/idea/vim/ex/ExException;", "hashCode", "initializeFunctionVariables", "", "functionCallContext", "toString", "", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nDefinedFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefinedFunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/DefinedFunctionHandler\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n38#2:183\n1549#3:184\n1620#3,3:185\n*S KotlinDebug\n*F\n+ 1 DefinedFunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/DefinedFunctionHandler\n*L\n32#1:183\n153#1:184\n153#1:185,3\n*E\n"})
public final class DefinedFunctionHandler
extends FunctionHandler {
    @NotNull
    private final FunctionDeclaration function;
    @NotNull
    private final VimLogger logger;
    @Nullable
    private final Scope scope;
    private final int minimumNumberOfArguments;

    public DefinedFunctionHandler(@NotNull FunctionDeclaration function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.function = function;
        boolean $i$f$vimLogger = false;
        this.logger = VimInjectorKt.getInjector().getLogger(DefinedFunctionHandler.class);
        this.scope = this.function.getScope();
        this.minimumNumberOfArguments = this.function.getArgs().size();
        this.setName(this.function.getName());
    }

    @NotNull
    public final FunctionDeclaration getFunction() {
        return this.function;
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public Integer getMinimumNumberOfArguments() {
        return this.minimumNumberOfArguments;
    }

    @Override
    @Nullable
    public Integer getMaximumNumberOfArguments() {
        return this.function.getHasOptionalArguments() ? null : Integer.valueOf(this.function.getArgs().size() + this.function.getDefaultArgs().size());
    }

    @Override
    @NotNull
    protected VimDataType doFunction(@NotNull List<? extends Expression> argumentValues, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        VimDataType vimDataType;
        boolean isRangeGiven;
        Intrinsics.checkNotNullParameter(argumentValues, (String)"argumentValues");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType returnValue = null;
        List exceptionsCaught = new ArrayList();
        Ranges ranges = this.getRanges();
        boolean bl = isRangeGiven = (ranges != null ? ranges.size() : 0) > 0;
        if (!isRangeGiven) {
            int currentLine = editor.currentCaret().getBufferPosition().getLine();
            this.setRanges(new Ranges());
            Ranges ranges2 = this.getRanges();
            Intrinsics.checkNotNull((Object)ranges2);
            Range[] rangeArray = new Range[]{new LineNumberRange(currentLine, 0, false), new LineNumberRange(currentLine, 0, false)};
            ranges2.addRange(rangeArray);
        }
        this.initializeFunctionVariables(argumentValues, editor, context, vimContext);
        if (this.function.getFlags().contains((Object)FunctionFlag.RANGE)) {
            VimDataType vimDataType2 = VimInjectorKt.getInjector().getVariableService().getNonNullVariableValue(new Variable(Scope.FUNCTION_VARIABLE, "firstline"), editor, context, this.function);
            Intrinsics.checkNotNull((Object)vimDataType2, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt");
            int line = ((VimInt)vimDataType2).getValue();
            returnValue = this.executeBodyForLine(line, isRangeGiven, exceptionsCaught, editor, context);
        } else {
            VimDataType vimDataType3 = VimInjectorKt.getInjector().getVariableService().getNonNullVariableValue(new Variable(Scope.FUNCTION_VARIABLE, "firstline"), editor, context, this.function);
            Intrinsics.checkNotNull((Object)vimDataType3, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt");
            int firstLine = ((VimInt)vimDataType3).getValue();
            VimDataType vimDataType4 = VimInjectorKt.getInjector().getVariableService().getNonNullVariableValue(new Variable(Scope.FUNCTION_VARIABLE, "lastline"), editor, context, this.function);
            Intrinsics.checkNotNull((Object)vimDataType4, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt");
            int lastLine = ((VimInt)vimDataType4).getValue();
            int line = firstLine;
            if (line <= lastLine) {
                while (true) {
                    returnValue = this.executeBodyForLine(line, isRangeGiven, exceptionsCaught, editor, context);
                    if (line == lastLine) break;
                    ++line;
                }
            }
        }
        if (!((Collection)exceptionsCaught).isEmpty()) {
            VimInjectorKt.getInjector().getMessages().indicateError();
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, ((ExException)CollectionsKt.last((List)exceptionsCaught)).getMessage());
        }
        if ((vimDataType = returnValue) == null) {
            vimDataType = new VimInt(0);
        }
        return vimDataType;
    }

    private final VimDataType executeBodyForLine(int line, boolean isRangeGiven, List<ExException> exceptionsCaught, VimEditor editor, ExecutionContext context) {
        VimDataType returnValue;
        block12: {
            ExecutionResult result;
            block10: {
                ExecutionResult executionResult;
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                returnValue = null;
                                if (isRangeGiven) {
                                    editor.currentCaret().moveToBufferPosition(new BufferPosition(line - 1, 0, false, 4, null));
                                }
                                result = ExecutionResult.Success.INSTANCE;
                                if (!this.function.getFlags().contains((Object)FunctionFlag.ABORT)) break block10;
                                for (Executable statement : this.function.getBody()) {
                                    statement.setVimContext(this.function);
                                    if (!(result instanceof ExecutionResult.Success)) continue;
                                    result = statement.execute(editor, context);
                                }
                                executionResult = result;
                                if (!(executionResult instanceof ExecutionResult.Break)) break block11;
                                exceptionsCaught.add(new ExException("E587: :break without :while or :for: break"));
                                break block12;
                            }
                            if (!(executionResult instanceof ExecutionResult.Continue)) break block13;
                            exceptionsCaught.add(new ExException("E586: :continue without :while or :for: continue"));
                            break block12;
                        }
                        if (!(executionResult instanceof ExecutionResult.Error)) break block14;
                        exceptionsCaught.add(new ExException("unknown error occurred"));
                        break block12;
                    }
                    if (!(executionResult instanceof ExecutionResult.Return)) break block15;
                    returnValue = ((ExecutionResult.Return)result).getValue();
                    break block12;
                }
                if (!(executionResult instanceof ExecutionResult.Success)) break block12;
                break block12;
            }
            for (Executable statement : this.function.getBody()) {
                statement.setVimContext(this.function);
                try {
                    ExecutionResult executionResult = result = statement.execute(editor, context);
                    if (executionResult instanceof ExecutionResult.Break) {
                        exceptionsCaught.add(new ExException("E587: :break without :while or :for: break"));
                        continue;
                    }
                    if (executionResult instanceof ExecutionResult.Continue) {
                        exceptionsCaught.add(new ExException("E586: :continue without :while or :for: continue"));
                        continue;
                    }
                    if (executionResult instanceof ExecutionResult.Error) {
                        exceptionsCaught.add(new ExException("unknown error occurred"));
                        continue;
                    }
                    if (executionResult instanceof ExecutionResult.Return) {
                        returnValue = ((ExecutionResult.Return)result).getValue();
                        break;
                    }
                    if (!(executionResult instanceof ExecutionResult.Success)) continue;
                }
                catch (ExException e) {
                    if (e instanceof FinishException) {
                        throw new FinishException();
                    }
                    exceptionsCaught.add(e);
                    this.logger.warn("Caught exception during execution of function with [abort] flag. Exception: " + e.getMessage());
                }
            }
        }
        return returnValue;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeFunctionVariables(List<? extends Expression> argumentValues, VimEditor editor, ExecutionContext context, VimLContext functionCallContext) {
        String name;
        Iterator<String> iterator = this.function.getArgs().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            name = iterator.next();
            VimInjectorKt.getInjector().getVariableService().storeVariable(new Variable(Scope.FUNCTION_VARIABLE, name), argumentValues.get(index).evaluate(editor, context, functionCallContext), editor, context, this.function);
        }
        n = this.function.getDefaultArgs().size();
        for (int index = 0; index < n; ++index) {
            Expression expressionToStore = index + this.function.getArgs().size() < argumentValues.size() ? argumentValues.get(index + this.function.getArgs().size()) : (Expression)this.function.getDefaultArgs().get(index).getSecond();
            VimInjectorKt.getInjector().getVariableService().storeVariable(new Variable(Scope.FUNCTION_VARIABLE, (String)this.function.getDefaultArgs().get(index).getFirst()), expressionToStore.evaluate(editor, context, functionCallContext), editor, context, this.function);
        }
        if (this.function.getHasOptionalArguments()) {
            VimList vimList;
            if (this.function.getArgs().size() + this.function.getDefaultArgs().size() < argumentValues.size()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = argumentValues.subList(this.function.getArgs().size() + this.function.getDefaultArgs().size(), argumentValues.size());
                boolean $i$f$map = false;
                name = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Expression expression = (Expression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.evaluate(editor, context, functionCallContext));
                }
                List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                vimList = new VimList(list);
            } else {
                vimList = new VimList(new ArrayList());
            }
            VimList remainingArgs = vimList;
            VimInjectorKt.getInjector().getVariableService().storeVariable(new Variable(Scope.FUNCTION_VARIABLE, "000"), remainingArgs, editor, context, this.function);
        }
        VariableService variableService2 = VimInjectorKt.getInjector().getVariableService();
        Variable variable = new Variable(Scope.FUNCTION_VARIABLE, "firstline");
        Ranges ranges = this.getRanges();
        Intrinsics.checkNotNull((Object)ranges);
        variableService2.storeVariable(variable, new VimInt(ranges.getFirstLine(editor, editor.currentCaret()) + 1), editor, context, this.function);
        VariableService variableService3 = VimInjectorKt.getInjector().getVariableService();
        Variable variable2 = new Variable(Scope.FUNCTION_VARIABLE, "lastline");
        Ranges ranges2 = this.getRanges();
        Intrinsics.checkNotNull((Object)ranges2);
        variableService3.storeVariable(variable2, new VimInt(ranges2.getLine(editor, editor.currentCaret()) + 1), editor, context, this.function);
    }

    @NotNull
    public final FunctionDeclaration component1() {
        return this.function;
    }

    @NotNull
    public final DefinedFunctionHandler copy(@NotNull FunctionDeclaration function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return new DefinedFunctionHandler(function);
    }

    public static /* synthetic */ DefinedFunctionHandler copy$default(DefinedFunctionHandler definedFunctionHandler, FunctionDeclaration functionDeclaration, int n, Object object) {
        if ((n & 1) != 0) {
            functionDeclaration = definedFunctionHandler.function;
        }
        return definedFunctionHandler.copy(functionDeclaration);
    }

    @NotNull
    public String toString() {
        return "DefinedFunctionHandler(function=" + this.function + ")";
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefinedFunctionHandler)) {
            return false;
        }
        DefinedFunctionHandler definedFunctionHandler = (DefinedFunctionHandler)other;
        return Intrinsics.areEqual((Object)this.function, (Object)definedFunctionHandler.function);
    }
}

