/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.SelectionInfo;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.InvalidRangeException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.mark.VimMark;
import com.maddyhome.idea.vim.put.PutData;
import com.maddyhome.idea.vim.put.VimPut;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J(\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0017H\u0002J,\u0010+\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00170.2\u0006\u0010*\u001a\u00020\u0017H\u0002J \u00100\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020/2\u0006\u0010*\u001a\u00020\u0017H\u0002JA\u00102\u001a\u00020,2\u0006\u0010\u001b\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u00172\b\u00105\u001a\u0004\u0018\u00010\u00172\u0006\u00106\u001a\u0002072\u0006\u0010*\u001a\u00020\u00172\u0006\u00108\u001a\u000209H\u0002\u00a2\u0006\u0002\u0010:J\t\u0010;\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006<"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "argument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgument", "()Ljava/lang/String;", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "normalizeLine", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "command", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "lineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "shiftBufferPosition", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "bufferPosition", "shift", "shiftGlobalMark", "", "markAndLine", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/mark/Mark;", "shiftLocalMark", "mark", "shiftSelectionInfo", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "startOffset", "endOffset", "selectionInfo", "Lcom/maddyhome/idea/vim/api/SelectionInfo;", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "(Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/maddyhome/idea/vim/api/SelectionInfo;ILcom/maddyhome/idea/vim/common/TextRange;)V", "toString", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMoveTextCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveTextCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n766#2:167\n857#2,2:168\n766#2:170\n857#2,2:171\n766#2:173\n857#2,2:174\n1549#2:176\n1620#2,3:177\n1855#2,2:181\n1855#2,2:183\n1#3:180\n*S KotlinDebug\n*F\n+ 1 MoveTextCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand\n*L\n70#1:167\n70#1:168,2\n71#1:170\n71#1:171,2\n74#1:173\n74#1:174,2\n75#1:176\n75#1:177,3\n101#1:181,2\n102#1:183,2\n*E\n"})
public final class MoveTextCommand
extends Command.SingleExecution {
    @NotNull
    private final Ranges ranges;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public MoveTextCommand(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(ranges, argument);
        this.ranges = ranges;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_REQUIRED, Command.Access.WRITABLE, new Command.Flag[0]);
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        Object it;
        PutData putData;
        Integer n;
        Integer n2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Mark it2;
        Iterable $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int caretCount = editor.nativeCarets().size();
        if (caretCount > 1) {
            throw new ExException("Move command supported only for one caret at the moment");
        }
        VimCaret caret = editor.primaryCaret();
        BufferPosition caretPosition = caret.getBufferPosition();
        Command command2 = VimInjectorKt.getInjector().getVimscriptParser().parseCommand(this.argument);
        if (command2 == null) {
            throw new ExException("E16: Invalid range");
        }
        Command goToLineCommand = command2;
        TextRange range = this.getTextRange(editor, caret, false);
        caret.moveToOffset(range.getStartOffset());
        LineRange lineRange = Command.getLineRange$default(this, editor, caret, false, 4, null);
        int line = Math.min((int)editor.fileSize(), this.normalizeLine(editor, caret, goToLineCommand, lineRange));
        int linesMoved = lineRange.endLine - lineRange.startLine + 1;
        if (line < -1 || line + linesMoved >= editor.lineCount()) {
            caret.moveToBufferPosition(caretPosition);
            throw new ExException("E16: Invalid range");
        }
        int shift = line + 1 - editor.offsetToBufferPosition(range.getStartOffset()).getLine();
        Iterable iterable = VimInjectorKt.getInjector().getMarkService().getAllLocalMarks(caret);
        boolean $i$f$filter = false;
        void var16_16 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (Mark)element$iv$iv;
            boolean bl = false;
            if (!range.contains(it2.offset(editor))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (Mark)element$iv$iv;
            boolean bl = false;
            if (!(it2.getKey() != '<' && it2.getKey() != '>')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set localMarks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$filter2 = VimInjectorKt.getInjector().getMarkService().getGlobalMarks(editor);
        boolean $i$f$filter3 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mark it3 = (Mark)element$iv$iv;
            boolean bl = false;
            if (!range.contains(it3.offset(editor))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Mark it3 = (Mark)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new Pair((Object)it3, (Object)it3.getLine()));
        }
        Set globalMarks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        SelectionInfo lastSelectionInfo = caret.getLastSelectionInfo();
        BufferPosition bufferPosition = lastSelectionInfo.getStart();
        if (bufferPosition != null) {
            BufferPosition it4 = bufferPosition;
            boolean bl = false;
            n2 = editor.bufferPositionToOffset(it4);
        } else {
            n2 = null;
        }
        Integer selectionStartOffset = n2;
        BufferPosition bufferPosition2 = lastSelectionInfo.getEnd();
        if (bufferPosition2 != null) {
            BufferPosition it5 = bufferPosition2;
            boolean bl = false;
            n = editor.bufferPositionToOffset(it5);
        } else {
            n = null;
        }
        Integer selectionEndOffset = n;
        String text2 = EngineEditorHelperKt.getText(editor, range);
        PutData.TextData textData = new PutData.TextData(text2, SelectionType.LINE_WISE, CollectionsKt.emptyList(), null);
        boolean dropNewLineInEnd = line + linesMoved == editor.lineCount() - 1 && StringsKt.last((CharSequence)text2) == '\n' || lineRange.endLine == editor.lineCount() - 1;
        editor.deleteString(range);
        if (line == -1) {
            caret.moveToOffset(0);
            putData = new PutData(textData, null, 1, true, true, false, 0, 64, null);
        } else {
            putData = new PutData(textData, null, 1, false, true, false, line);
        }
        PutData putData2 = putData;
        VimPut.putTextForCaret$default(VimInjectorKt.getInjector().getPut(), editor, caret, context, putData2, false, false, 48, null);
        if (dropNewLineInEnd) {
            boolean it6;
            boolean bl = it6 = StringsKt.last((CharSequence)editor.text()) == '\n';
            if (_Assertions.ENABLED && !it6) {
                String bl2 = "Assertion failed";
                throw new AssertionError((Object)bl2);
            }
            editor.deleteString(new TextRange(editor.text().length() - 1, editor.text().length()));
        }
        Iterable $this$forEach$iv = globalMarks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            this.shiftGlobalMark(editor, (Pair<? extends Mark, Integer>)it, shift);
        }
        $this$forEach$iv = localMarks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Mark)element$iv;
            boolean bl = false;
            this.shiftLocalMark(caret, (Mark)it, shift);
        }
        this.shiftSelectionInfo(caret, selectionStartOffset, selectionEndOffset, lastSelectionInfo, shift, range);
        BufferPosition newCaretPosition = this.shiftBufferPosition(caretPosition, shift);
        caret.moveToBufferPosition(newCaretPosition);
        return ExecutionResult.Success.INSTANCE;
    }

    private final void shiftGlobalMark(VimEditor editor, Pair<? extends Mark, Integer> markAndLine, int shift) {
        int newOffset = editor.bufferPositionToOffset(new BufferPosition(((Number)markAndLine.getSecond()).intValue() + shift, ((Mark)markAndLine.getFirst()).getCol(), false, 4, null));
        VimInjectorKt.getInjector().getMarkService().setGlobalMark(editor, ((Mark)markAndLine.getFirst()).getKey(), newOffset);
    }

    private final void shiftLocalMark(VimCaret caret, Mark mark, int shift) {
        VimEditor editor = caret.getEditor();
        String string = editor.getPath();
        if (string == null) {
            return;
        }
        String path = string;
        VimMark mark2 = new VimMark(mark.getKey(), mark.getLine() + shift, mark.getCol(), path, editor.extractProtocol());
        VimInjectorKt.getInjector().getMarkService().setMark(caret, mark2);
    }

    private final void shiftSelectionInfo(ImmutableVimCaret caret, Integer startOffset, Integer endOffset, SelectionInfo selectionInfo, int shift, TextRange range) {
        BufferPosition newStartPosition = selectionInfo.getStart();
        if (startOffset != null && selectionInfo.getStart() != null && range.contains(startOffset)) {
            BufferPosition bufferPosition = selectionInfo.getStart();
            Intrinsics.checkNotNull((Object)bufferPosition);
            newStartPosition = this.shiftBufferPosition(bufferPosition, shift);
        }
        BufferPosition newEndPosition = selectionInfo.getEnd();
        if (endOffset != null && selectionInfo.getEnd() != null && range.contains(endOffset)) {
            BufferPosition bufferPosition = selectionInfo.getEnd();
            Intrinsics.checkNotNull((Object)bufferPosition);
            newEndPosition = this.shiftBufferPosition(bufferPosition, shift);
        }
        if (!Intrinsics.areEqual((Object)newStartPosition, (Object)selectionInfo.getStart()) || !Intrinsics.areEqual((Object)newEndPosition, (Object)selectionInfo.getEnd())) {
            caret.setLastSelectionInfo(new SelectionInfo(newStartPosition, newEndPosition, selectionInfo.getSelectionType()));
        }
    }

    private final BufferPosition shiftBufferPosition(BufferPosition bufferPosition, int shift) {
        return new BufferPosition(bufferPosition.getLine() + shift, bufferPosition.getColumn(), bufferPosition.getLeansForward());
    }

    private final int normalizeLine(VimEditor editor, VimCaret caret, Command command2, LineRange lineRange) {
        int line = command2.getCommandRanges().getFirstLine(editor, caret);
        int adj = lineRange.endLine - lineRange.startLine + 1;
        if (line >= lineRange.endLine) {
            line -= adj;
        } else if (line >= lineRange.startLine) {
            throw new InvalidRangeException(VimInjectorKt.getInjector().getMessages().message("e_backrange", new Object[0]));
        }
        return line;
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final MoveTextCommand copy(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new MoveTextCommand(ranges, argument);
    }

    public static /* synthetic */ MoveTextCommand copy$default(MoveTextCommand moveTextCommand, Ranges ranges, String string, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = moveTextCommand.ranges;
        }
        if ((n & 2) != 0) {
            string = moveTextCommand.argument;
        }
        return moveTextCommand.copy(ranges, string);
    }

    @NotNull
    public String toString() {
        return "MoveTextCommand(ranges=" + this.ranges + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.ranges.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MoveTextCommand)) {
            return false;
        }
        MoveTextCommand moveTextCommand = (MoveTextCommand)other;
        if (!Intrinsics.areEqual((Object)this.ranges, (Object)moveTextCommand.ranges)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)moveTextCommand.argument);
    }
}

