/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VirtualFile;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.helper.EngineStringHelper;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/MarksCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "argument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgument", "()Ljava/lang/String;", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "toString", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMarksCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarksCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/MarksCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n766#2:58\n857#2,2:59\n*S KotlinDebug\n*F\n+ 1 MarksCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/MarksCommand\n*L\n34#1:58\n34#1:59,2\n*E\n"})
public final class MarksCommand
extends Command.SingleExecution {
    @NotNull
    private final Ranges ranges;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public MarksCommand(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(ranges, argument);
        this.ranges = ranges;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Set<Mark> localMarks = VimInjectorKt.getInjector().getMarkService().getAllLocalMarks(editor.primaryCaret());
        Set<Mark> globalMarks = VimInjectorKt.getInjector().getMarkService().getAllGlobalMarks();
        Iterable iterable = SetsKt.plus(localMarks, (Iterable)globalMarks);
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mark it = (Mark)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)this.argument).length() == 0 || StringsKt.contains$default((CharSequence)this.argument, (char)it.getKey(), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String res2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)Mark.KeySorter.INSTANCE), (CharSequence)"\n", (CharSequence)"mark line  col file/text\n", null, (int)0, null, (Function1)((Function1)new Function1<Mark, CharSequence>(editor){
            final /* synthetic */ VimEditor $editor;
            {
                this.$editor = $editor;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Mark mark) {
                String string;
                Intrinsics.checkNotNullParameter((Object)mark, (String)"mark");
                String line = StringsKt.padStart$default((String)String.valueOf(mark.getLine() + 1), (int)5, (char)'\u0000', (int)2, null);
                String column = StringsKt.padStart$default((String)String.valueOf(mark.getCol()), (int)3, (char)'\u0000', (int)2, null);
                VirtualFile vf = this.$editor.getVirtualFile();
                if (vf != null && Intrinsics.areEqual((Object)vf.getPath(), (Object)mark.getFilepath())) {
                    String lineText = StringsKt.take((String)((Object)StringsKt.trim((CharSequence)this.$editor.getLineText(mark.getLine()))).toString(), (int)200);
                    string = StringsKt.take((String)EngineStringHelper.INSTANCE.toPrintableCharacters(VimInjectorKt.getInjector().getParser().stringToKeys(lineText)), (int)200);
                } else {
                    string = mark.getFilepath();
                }
                String text2 = string;
                return " " + mark.getKey() + "  " + line + "  " + column + " " + text2;
            }
        }), (int)28, null);
        VimInjectorKt.getInjector().getExOutputPanel().getPanel(editor).output(res2);
        return ExecutionResult.Success.INSTANCE;
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final MarksCommand copy(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new MarksCommand(ranges, argument);
    }

    public static /* synthetic */ MarksCommand copy$default(MarksCommand marksCommand, Ranges ranges, String string, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = marksCommand.ranges;
        }
        if ((n & 2) != 0) {
            string = marksCommand.argument;
        }
        return marksCommand.copy(ranges, string);
    }

    @NotNull
    public String toString() {
        return "MarksCommand(ranges=" + this.ranges + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.ranges.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MarksCommand)) {
            return false;
        }
        MarksCommand marksCommand = (MarksCommand)other;
        if (!Intrinsics.areEqual((Object)this.ranges, (Object)marksCommand.ranges)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)marksCommand.argument);
    }
}

