/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/GoToLineCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ForEachCaret;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "toString", "", "vim-engine"})
public final class GoToLineCommand
extends Command.ForEachCaret {
    @NotNull
    private final Ranges ranges;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public GoToLineCommand(@NotNull Ranges ranges) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        super(ranges, null, 2, null);
        this.ranges = ranges;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_REQUIRED, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int line = Integer.min(this.getLine(editor, caret), editor.lineCount() - 1);
        if (line >= 0) {
            int offset = VimInjectorKt.getInjector().getMotion().moveCaretToLineWithStartOfLineOption(editor, line, caret);
            caret.moveToOffset(offset);
            return ExecutionResult.Success.INSTANCE;
        }
        caret.moveToOffset(0);
        return ExecutionResult.Error.INSTANCE;
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @NotNull
    public final GoToLineCommand copy(@NotNull Ranges ranges) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        return new GoToLineCommand(ranges);
    }

    public static /* synthetic */ GoToLineCommand copy$default(GoToLineCommand goToLineCommand, Ranges ranges, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = goToLineCommand.ranges;
        }
        return goToLineCommand.copy(ranges);
    }

    @NotNull
    public String toString() {
        return "GoToLineCommand(ranges=" + this.ranges + ")";
    }

    public int hashCode() {
        return this.ranges.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GoToLineCommand)) {
            return false;
        }
        GoToLineCommand goToLineCommand = (GoToLineCommand)other;
        return Intrinsics.areEqual((Object)this.ranges, (Object)goToLineCommand.ranges);
    }
}

