/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J3\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\t\u0010)\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/DelfunctionCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "scope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "name", "", "ignoreIfMissing", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;Ljava/lang/String;Z)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getIgnoreIfMissing", "()Z", "getName", "()Ljava/lang/String;", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "getScope", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "toString", "vim-engine"})
public final class DelfunctionCommand
extends Command.SingleExecution {
    @NotNull
    private final Ranges ranges;
    @Nullable
    private final Scope scope;
    @NotNull
    private final String name;
    private final boolean ignoreIfMissing;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public DelfunctionCommand(@NotNull Ranges ranges, @Nullable Scope scope, @NotNull String name, boolean ignoreIfMissing) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(ranges, null, 2, null);
        this.ranges = ranges;
        this.scope = scope;
        this.name = name;
        this.ignoreIfMissing = ignoreIfMissing;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @Nullable
    public final Scope getScope() {
        return this.scope;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getIgnoreIfMissing() {
        return this.ignoreIfMissing;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (this.ignoreIfMissing) {
            try {
                VimInjectorKt.getInjector().getFunctionService().deleteFunction(this.name, this.scope, this);
                return ExecutionResult.Success.INSTANCE;
            }
            catch (ExException e) {
                if (e.getMessage() == null) throw e;
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.startsWith$default((String)string, (String)"E130", (boolean)false, (int)2, null)) return ExecutionResult.Success.INSTANCE;
                throw e;
            }
        } else {
            VimInjectorKt.getInjector().getFunctionService().deleteFunction(this.name, this.scope, this);
        }
        return ExecutionResult.Success.INSTANCE;
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @Nullable
    public final Scope component2() {
        return this.scope;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    public final boolean component4() {
        return this.ignoreIfMissing;
    }

    @NotNull
    public final DelfunctionCommand copy(@NotNull Ranges ranges, @Nullable Scope scope, @NotNull String name, boolean ignoreIfMissing) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new DelfunctionCommand(ranges, scope, name, ignoreIfMissing);
    }

    public static /* synthetic */ DelfunctionCommand copy$default(DelfunctionCommand delfunctionCommand, Ranges ranges, Scope scope, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = delfunctionCommand.ranges;
        }
        if ((n & 2) != 0) {
            scope = delfunctionCommand.scope;
        }
        if ((n & 4) != 0) {
            string = delfunctionCommand.name;
        }
        if ((n & 8) != 0) {
            bl = delfunctionCommand.ignoreIfMissing;
        }
        return delfunctionCommand.copy(ranges, scope, string, bl);
    }

    @NotNull
    public String toString() {
        return "DelfunctionCommand(ranges=" + this.ranges + ", scope=" + this.scope + ", name=" + this.name + ", ignoreIfMissing=" + this.ignoreIfMissing + ")";
    }

    public int hashCode() {
        int result = this.ranges.hashCode();
        result = result * 31 + (this.scope == null ? 0 : this.scope.hashCode());
        result = result * 31 + this.name.hashCode();
        result = result * 31 + Boolean.hashCode(this.ignoreIfMissing);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DelfunctionCommand)) {
            return false;
        }
        DelfunctionCommand delfunctionCommand = (DelfunctionCommand)other;
        if (!Intrinsics.areEqual((Object)this.ranges, (Object)delfunctionCommand.ranges)) {
            return false;
        }
        if (this.scope != delfunctionCommand.scope) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)delfunctionCommand.name)) {
            return false;
        }
        return this.ignoreIfMissing == delfunctionCommand.ignoreIfMissing;
    }
}

