/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.state;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.MappingState;
import com.maddyhome.idea.vim.common.DigraphSequence;
import com.maddyhome.idea.vim.impl.state.VimStateMachineImplKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0000H\u0016J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "", "()V", "mappingState", "Lcom/maddyhome/idea/vim/command/MappingState;", "digraphSequence", "Lcom/maddyhome/idea/vim/common/DigraphSequence;", "commandBuilder", "Lcom/maddyhome/idea/vim/command/CommandBuilder;", "(Lcom/maddyhome/idea/vim/command/MappingState;Lcom/maddyhome/idea/vim/common/DigraphSequence;Lcom/maddyhome/idea/vim/command/CommandBuilder;)V", "getCommandBuilder", "()Lcom/maddyhome/idea/vim/command/CommandBuilder;", "getDigraphSequence", "()Lcom/maddyhome/idea/vim/common/DigraphSequence;", "getMappingState", "()Lcom/maddyhome/idea/vim/command/MappingState;", "clone", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "partialReset", "", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "reset", "toString", "", "vim-engine"})
public final class KeyHandlerState
implements Cloneable {
    @NotNull
    private final MappingState mappingState;
    @NotNull
    private final DigraphSequence digraphSequence;
    @NotNull
    private final CommandBuilder commandBuilder;

    public KeyHandlerState(@NotNull MappingState mappingState, @NotNull DigraphSequence digraphSequence, @NotNull CommandBuilder commandBuilder) {
        Intrinsics.checkNotNullParameter((Object)mappingState, (String)"mappingState");
        Intrinsics.checkNotNullParameter((Object)digraphSequence, (String)"digraphSequence");
        Intrinsics.checkNotNullParameter((Object)commandBuilder, (String)"commandBuilder");
        this.mappingState = mappingState;
        this.digraphSequence = digraphSequence;
        this.commandBuilder = commandBuilder;
    }

    @NotNull
    public final MappingState getMappingState() {
        return this.mappingState;
    }

    @NotNull
    public final DigraphSequence getDigraphSequence() {
        return this.digraphSequence;
    }

    @NotNull
    public final CommandBuilder getCommandBuilder() {
        return this.commandBuilder;
    }

    public KeyHandlerState() {
        this(new MappingState(), new DigraphSequence(), new CommandBuilder(VimInjectorKt.getInjector().getKeyGroup().getKeyRoot(MappingMode.NORMAL)));
    }

    public final void partialReset(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.mappingState.resetMappingSequence();
        this.commandBuilder.resetInProgressCommandPart(VimInjectorKt.getInjector().getKeyGroup().getKeyRoot(VimStateMachineImplKt.toMappingMode(mode)));
    }

    public final void reset(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        this.digraphSequence.reset();
        this.mappingState.resetMappingSequence();
        this.commandBuilder.resetAll(VimInjectorKt.getInjector().getKeyGroup().getKeyRoot(VimStateMachineImplKt.toMappingMode(mode)));
    }

    @NotNull
    public KeyHandlerState clone() {
        return new KeyHandlerState(this.mappingState.clone(), this.digraphSequence.clone(), this.commandBuilder.clone());
    }

    @NotNull
    public final MappingState component1() {
        return this.mappingState;
    }

    @NotNull
    public final DigraphSequence component2() {
        return this.digraphSequence;
    }

    @NotNull
    public final CommandBuilder component3() {
        return this.commandBuilder;
    }

    @NotNull
    public final KeyHandlerState copy(@NotNull MappingState mappingState, @NotNull DigraphSequence digraphSequence, @NotNull CommandBuilder commandBuilder) {
        Intrinsics.checkNotNullParameter((Object)mappingState, (String)"mappingState");
        Intrinsics.checkNotNullParameter((Object)digraphSequence, (String)"digraphSequence");
        Intrinsics.checkNotNullParameter((Object)commandBuilder, (String)"commandBuilder");
        return new KeyHandlerState(mappingState, digraphSequence, commandBuilder);
    }

    public static /* synthetic */ KeyHandlerState copy$default(KeyHandlerState keyHandlerState, MappingState mappingState, DigraphSequence digraphSequence, CommandBuilder commandBuilder, int n, Object object) {
        if ((n & 1) != 0) {
            mappingState = keyHandlerState.mappingState;
        }
        if ((n & 2) != 0) {
            digraphSequence = keyHandlerState.digraphSequence;
        }
        if ((n & 4) != 0) {
            commandBuilder = keyHandlerState.commandBuilder;
        }
        return keyHandlerState.copy(mappingState, digraphSequence, commandBuilder);
    }

    @NotNull
    public String toString() {
        return "KeyHandlerState(mappingState=" + this.mappingState + ", digraphSequence=" + this.digraphSequence + ", commandBuilder=" + this.commandBuilder + ")";
    }

    public int hashCode() {
        int result = this.mappingState.hashCode();
        result = result * 31 + this.digraphSequence.hashCode();
        result = result * 31 + this.commandBuilder.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyHandlerState)) {
            return false;
        }
        KeyHandlerState keyHandlerState = (KeyHandlerState)other;
        if (!Intrinsics.areEqual((Object)this.mappingState, (Object)keyHandlerState.mappingState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.digraphSequence, (Object)keyHandlerState.digraphSequence)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.commandBuilder, (Object)keyHandlerState.commandBuilder);
    }
}

