/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.key.consumers.ModeInputConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/ModeInputConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "shouldRecord", "Lcom/maddyhome/idea/vim/KeyHandler$MutableBoolean;", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nModeInputConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModeInputConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/ModeInputConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,63:1\n38#2:64\n*S KotlinDebug\n*F\n+ 1 ModeInputConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/ModeInputConsumer\n*L\n22#1:64\n*E\n"})
public final class ModeInputConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, @NotNull KeyHandler.MutableBoolean shouldRecord) {
        boolean isProcessed;
        boolean bl;
        boolean keyProcessed;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        Intrinsics.checkNotNullParameter((Object)shouldRecord, (String)"shouldRecord");
        Mode mode = editor.getMode();
        if (Intrinsics.areEqual((Object)mode, (Object)Mode.INSERT.INSTANCE) ? true : Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE)) {
            logger.trace("Process insert or replace");
            keyProcessed = VimInjectorKt.getInjector().getChangeGroup().processKey(editor, key, keyProcessResultBuilder);
            shouldRecord.setValue(keyProcessed && shouldRecord.getValue());
            bl = keyProcessed;
        } else if (mode instanceof Mode.SELECT) {
            logger.trace("Process select");
            keyProcessed = VimInjectorKt.getInjector().getChangeGroup().processKeyInSelectMode(editor, key, keyProcessResultBuilder);
            shouldRecord.setValue(keyProcessed && shouldRecord.getValue());
            bl = keyProcessed;
        } else if (mode instanceof Mode.CMD_LINE) {
            logger.trace("Process cmd line");
            keyProcessed = VimInjectorKt.getInjector().getProcessGroup().processExKey(editor, key, keyProcessResultBuilder);
            shouldRecord.setValue(keyProcessed && shouldRecord.getValue());
            bl = keyProcessed;
        } else {
            bl = isProcessed = false;
        }
        if (isProcessed) {
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)consumeKey.1.INSTANCE));
        }
        return isProcessed;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(ModeInputConsumer.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/ModeInputConsumer$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

