/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.StringAndKeysKt;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.register.VimRegisterGroup;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/EditorResetConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "shouldRecord", "Lcom/maddyhome/idea/vim/KeyHandler$MutableBoolean;", "handleEditorReset", "", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "isEditorReset", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nEditorResetConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorResetConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/EditorResetConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,80:1\n33#2,4:81\n38#2:85\n*S KotlinDebug\n*F\n+ 1 EditorResetConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/EditorResetConsumer\n*L\n45#1:81,4\n27#1:85\n*E\n"})
public final class EditorResetConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, @NotNull KeyHandler.MutableBoolean shouldRecord) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        Intrinsics.checkNotNullParameter((Object)shouldRecord, (String)"shouldRecord");
        if (!this.isEditorReset(key, editor)) {
            return false;
        }
        keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(this, key){
            final /* synthetic */ EditorResetConsumer this$0;
            final /* synthetic */ KeyStroke $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(3);
            }

            public final void invoke(@NotNull KeyHandlerState lambdaKeyState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext lambdaContext) {
                Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
                Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
                EditorResetConsumer.access$handleEditorReset(this.this$0, lambdaEditor, this.$key, lambdaKeyState, lambdaContext);
            }
        }));
        return true;
    }

    private final boolean isEditorReset(KeyStroke key, VimEditor editor) {
        boolean editorReset = editor.getMode() instanceof Mode.NORMAL && StringAndKeysKt.isCloseKeyStroke(key);
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("This is editor reset: " + editorReset);
        }
        return editorReset;
    }

    private final void handleEditorReset(VimEditor editor, KeyStroke key, KeyHandlerState keyState, ExecutionContext context) {
        VimRegisterGroup register;
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        if (commandBuilder.isAwaitingCharOrDigraphArgument()) {
            editor.setReplaceCharacter(false);
        }
        if (commandBuilder.isAtDefaultState() && (register = VimInjectorKt.getInjector().getRegisterGroup()).getCurrentRegister() == register.getDefaultRegister()) {
            boolean indicateError = true;
            if (key.getKeyCode() == 27) {
                Boolean[] booleanArray = new Boolean[]{null};
                Boolean[] executed = booleanArray;
                VimInjectorKt.getInjector().getActionExecutor().executeCommand(editor, () -> EditorResetConsumer.handleEditorReset$lambda$1(executed, context), "", null);
                Boolean bl = executed[0];
                Intrinsics.checkNotNull((Object)bl);
                boolean bl2 = indicateError = bl == false;
            }
            if (indicateError) {
                VimInjectorKt.getInjector().getMessages().indicateError();
            }
        }
        KeyHandler.Companion.getInstance().reset(keyState, editor.getMode());
    }

    private static final void handleEditorReset$lambda$1(Boolean[] $executed, ExecutionContext $context) {
        Intrinsics.checkNotNullParameter((Object)$executed, (String)"$executed");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        $executed[0] = VimInjectorKt.getInjector().getActionExecutor().executeEsc($context);
    }

    public static final /* synthetic */ void access$handleEditorReset(EditorResetConsumer $this, VimEditor editor, KeyStroke key, KeyHandlerState keyState, ExecutionContext context) {
        $this.handleEditorReset(editor, key, keyState, context);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(EditorResetConsumer.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/EditorResetConsumer$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

