/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.common.DigraphResult;
import com.maddyhome.idea.vim.common.DigraphSequence;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.key.consumers.DigraphConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/DigraphConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "shouldRecord", "Lcom/maddyhome/idea/vim/KeyHandler$MutableBoolean;", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nDigraphConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigraphConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/DigraphConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,125:1\n38#2:126\n*S KotlinDebug\n*F\n+ 1 DigraphConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/DigraphConsumer\n*L\n25#1:126\n*E\n"})
public final class DigraphConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, @NotNull KeyHandler.MutableBoolean shouldRecord) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        Intrinsics.checkNotNullParameter((Object)shouldRecord, (String)"shouldRecord");
        logger.debug("Handling digraph");
        KeyHandlerState keyState = keyProcessResultBuilder.getState();
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        DigraphSequence digraphSequence = keyState.getDigraphSequence();
        if (commandBuilder.getExpectedArgumentType() == Argument.Type.DIGRAPH) {
            logger.trace("Expected argument is digraph");
            if (digraphSequence.isDigraphStart(key)) {
                digraphSequence.startDigraphSequence();
                commandBuilder.addKey(key);
                return true;
            }
            if (digraphSequence.isLiteralStart(key)) {
                digraphSequence.startLiteralSequence();
                commandBuilder.addKey(key);
                return true;
            }
        }
        DigraphResult res2 = digraphSequence.processKey(key, editor);
        KeyHandler keyHandler = KeyHandler.Companion.getInstance();
        switch (res2.getResult()) {
            case 0: {
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(keyHandler, key){
                    final /* synthetic */ KeyHandler $keyHandler;
                    final /* synthetic */ KeyStroke $key;
                    {
                        this.$keyHandler = $keyHandler;
                        this.$key = $key;
                        super(3);
                    }

                    public final void invoke(@NotNull KeyHandlerState lambdaKeyState, @NotNull VimEditor vimEditor, @NotNull ExecutionContext executionContext) {
                        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
                        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<anonymous parameter 1>");
                        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<anonymous parameter 2>");
                        if (VimInjectorKt.getInjector().getExEntryPanel().isActive()) {
                            this.$keyHandler.setPromptCharacterEx(lambdaKeyState.getCommandBuilder().isPuttingLiteral() ? (char)'^' : this.$key.getKeyChar());
                        }
                        lambdaKeyState.getCommandBuilder().addKey(this.$key);
                    }
                }));
                return true;
            }
            case 3: {
                if (VimInjectorKt.getInjector().getExEntryPanel().isActive()) {
                    if (key.getKeyCode() == 67 && (key.getModifiers() & 0x80) != 0) {
                        return false;
                    }
                    keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)consumeKey.2.INSTANCE));
                }
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)consumeKey.3.INSTANCE));
                KeyStroke keyStroke = res2.getStroke();
                if (keyStroke == null) {
                    return false;
                }
                KeyStroke stroke = keyStroke;
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(key, keyHandler, stroke){
                    final /* synthetic */ KeyStroke $key;
                    final /* synthetic */ KeyHandler $keyHandler;
                    final /* synthetic */ KeyStroke $stroke;
                    {
                        this.$key = $key;
                        this.$keyHandler = $keyHandler;
                        this.$stroke = $stroke;
                        super(3);
                    }

                    public final void invoke(@NotNull KeyHandlerState lambdaKeyState, @NotNull VimEditor lambdaEditorState, @NotNull ExecutionContext lambdaContext) {
                        Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
                        Intrinsics.checkNotNullParameter((Object)lambdaEditorState, (String)"lambdaEditorState");
                        Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
                        lambdaKeyState.getCommandBuilder().addKey(this.$key);
                        this.$keyHandler.handleKey(lambdaEditorState, this.$stroke, lambdaContext, lambdaKeyState);
                    }
                }));
                return true;
            }
            case 4: {
                if (VimInjectorKt.getInjector().getExEntryPanel().isActive()) {
                    if (key.getKeyCode() == 67 && (key.getModifiers() & 0x80) != 0) {
                        return false;
                    }
                    keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)consumeKey.5.INSTANCE));
                }
                keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)consumeKey.6.INSTANCE));
                return true;
            }
            case 1: {
                if (commandBuilder.getExpectedArgumentType() == Argument.Type.DIGRAPH) {
                    commandBuilder.fallbackToCharacterArgument();
                    keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(keyHandler, key){
                        final /* synthetic */ KeyHandler $keyHandler;
                        final /* synthetic */ KeyStroke $key;
                        {
                            this.$keyHandler = $keyHandler;
                            this.$key = $key;
                            super(3);
                        }

                        public final void invoke(@NotNull KeyHandlerState lambdaKeyState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext lambdaContext) {
                            Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
                            Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                            Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
                            this.$keyHandler.handleKey(lambdaEditor, this.$key, lambdaContext, lambdaKeyState);
                        }
                    }));
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(DigraphConsumer.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/DigraphConsumer$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

