/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CommandCountConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "shouldRecord", "Lcom/maddyhome/idea/vim/KeyHandler$MutableBoolean;", "isCommandCountKey", "chKey", "", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommandCountConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandCountConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CommandCountConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,59:1\n38#2:60\n*S KotlinDebug\n*F\n+ 1 CommandCountConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CommandCountConsumer\n*L\n24#1:60\n*E\n"})
public final class CommandCountConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, @NotNull KeyHandler.MutableBoolean shouldRecord) {
        char chKey;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        Intrinsics.checkNotNullParameter((Object)shouldRecord, (String)"shouldRecord");
        char c = chKey = key.getKeyChar() == '\uffff' ? (char)'\u0000' : key.getKeyChar();
        if (!this.isCommandCountKey(chKey, keyProcessResultBuilder.getState(), editor)) {
            return false;
        }
        keyProcessResultBuilder.getState().getCommandBuilder().addCountCharacter(key);
        return true;
    }

    private final boolean isCommandCountKey(char chKey, KeyHandlerState keyState, VimEditor editor) {
        VimStateMachine editorState = EngineHelperKt.getVimStateMachine(editor);
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        boolean notRegisterPendingCommand = editorState.getMode() instanceof Mode.NORMAL && !editorState.isRegisterPending();
        boolean visualMode = editorState.getMode() instanceof Mode.VISUAL && !editorState.isRegisterPending();
        boolean opPendingMode = editorState.getMode() instanceof Mode.OP_PENDING;
        if ((notRegisterPendingCommand || visualMode || opPendingMode) && commandBuilder.isExpectingCount() && Character.isDigit(chKey) && (commandBuilder.getCount() > 0 || chKey != '0')) {
            logger.debug("This is a command key count");
            return true;
        }
        logger.debug("This is NOT a command key count");
        return false;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(CommandCountConsumer.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CommandCountConsumer$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

