/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.key.consumers.CharArgumentConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CharArgumentConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "()V", "consumeKey", "", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "shouldRecord", "Lcom/maddyhome/idea/vim/KeyHandler$MutableBoolean;", "handleCharArgument", "", "chKey", "", "processBuilder", "isExpectingCharArgument", "commandBuilder", "Lcom/maddyhome/idea/vim/command/CommandBuilder;", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCharArgumentConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharArgumentConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CharArgumentConsumer\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,75:1\n33#2,4:76\n38#2:80\n*S KotlinDebug\n*F\n+ 1 CharArgumentConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CharArgumentConsumer\n*L\n44#1:76,4\n24#1:80\n*E\n"})
public final class CharArgumentConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, @NotNull KeyHandler.MutableBoolean shouldRecord) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        Intrinsics.checkNotNullParameter((Object)shouldRecord, (String)"shouldRecord");
        if (!this.isExpectingCharArgument(keyProcessResultBuilder.getState().getCommandBuilder())) {
            return false;
        }
        char chKey = key.getKeyChar() == '\uffff' ? (char)'\u0000' : key.getKeyChar();
        this.handleCharArgument(key, chKey, keyProcessResultBuilder);
        return true;
    }

    private final boolean isExpectingCharArgument(CommandBuilder commandBuilder) {
        boolean expectingCharArgument = commandBuilder.getExpectedArgumentType() == Argument.Type.CHARACTER;
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Expecting char argument: " + expectingCharArgument);
        }
        return expectingCharArgument;
    }

    private final void handleCharArgument(KeyStroke key, char chKey, KeyProcessResult.KeyProcessResultBuilder processBuilder) {
        Ref.CharRef mutableChKey = new Ref.CharRef();
        mutableChKey.element = chKey;
        logger.trace("Handling char argument");
        if (mutableChKey.element == '\u0000') {
            switch (key.getKeyCode()) {
                case 9: {
                    mutableChKey.element = (char)9;
                    break;
                }
                case 10: {
                    mutableChKey.element = (char)10;
                }
            }
        }
        CommandBuilder commandBuilder = processBuilder.getState().getCommandBuilder();
        if (mutableChKey.element != '\u0000') {
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(commandBuilder, mutableChKey){
                final /* synthetic */ CommandBuilder $commandBuilder;
                final /* synthetic */ Ref.CharRef $mutableChKey;
                {
                    this.$commandBuilder = $commandBuilder;
                    this.$mutableChKey = $mutableChKey;
                    super(3);
                }

                public final void invoke(@NotNull KeyHandlerState keyHandlerState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext executionContext) {
                    Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                    Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<anonymous parameter 2>");
                    CharArgumentConsumer.access$getLogger$cp().trace("Add character argument to the current command");
                    this.$commandBuilder.completeCommandPart(new Argument(this.$mutableChKey.element));
                    lambdaEditor.setReplaceCharacter(false);
                }
            }));
        } else {
            logger.trace("This is not a valid character argument. Set command state to BAD_COMMAND");
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)handleCharArgument.2.INSTANCE));
        }
    }

    public static final /* synthetic */ VimLogger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(CharArgumentConsumer.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CharArgumentConsumer$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

