/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group.visual;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimFoldRegion;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.group.visual.EngineVisualModeHelperKt;
import com.maddyhome.idea.vim.group.visual.VimVisualGroupKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0014\u0010\u000f\u001a\u00020\u0006*\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0001\u001a&\u0010\u0011\u001a\u00020\u0006*\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0006*\u00020\n\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"vimLeadSelectionOffset", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "getVimLeadSelectionOffset", "(Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;)I", "setVisualSelection", "", "selectionStart", "selectionEnd", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "vimMoveBlockSelectionToOffset", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "offset", "vimMoveSelectionToCaret", "vimSelectionStart", "vimSetSelection", "start", "end", "moveCaretToSelectionEnd", "", "vimUpdateEditorSelection", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nEngineVisualGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EngineVisualGroup.kt\ncom/maddyhome/idea/vim/group/visual/EngineVisualGroupKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1549#2:183\n1620#2,3:184\n1045#2:187\n*S KotlinDebug\n*F\n+ 1 EngineVisualGroup.kt\ncom/maddyhome/idea/vim/group/visual/EngineVisualGroupKt\n*L\n167#1:183\n167#1:184,3\n167#1:187\n*E\n"})
public final class EngineVisualGroupKt {
    public static final void setVisualSelection(int selectionStart, int selectionEnd, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Pair pair = selectionStart > selectionEnd ? TuplesKt.to((Object)selectionEnd, (Object)selectionStart) : TuplesKt.to((Object)selectionStart, (Object)selectionEnd);
        int start2 = ((Number)pair.component1()).intValue();
        int end = ((Number)pair.component2()).intValue();
        VimEditor editor = caret.getEditor();
        SelectionType selectionType = ModeExtensionsKt.getSelectionType(editor.getMode());
        if (selectionType == null) {
            selectionType = SelectionType.CHARACTER_WISE;
        }
        SelectionType subMode = selectionType;
        Mode mode = editor.getMode();
        switch (WhenMappings.$EnumSwitchMapping$0[subMode.ordinal()]) {
            case 1: {
                Pair<Integer, Integer> pair2 = VimVisualGroupKt.charToNativeSelection(editor, start2, end, mode);
                int nativeStart = ((Number)pair2.component1()).intValue();
                int nativeEnd = ((Number)pair2.component2()).intValue();
                EngineVisualModeHelperKt.vimSetSystemSelectionSilently(caret, nativeStart, nativeEnd);
                break;
            }
            case 2: {
                Pair<Integer, Integer> pair3 = VimVisualGroupKt.lineToNativeSelection(editor, start2, end);
                int nativeStart = ((Number)pair3.component1()).intValue();
                int nativeEnd = ((Number)pair3.component2()).intValue();
                EngineVisualModeHelperKt.vimSetSystemSelectionSilently(caret, nativeStart, nativeEnd);
                break;
            }
            case 3: {
                editor.removeSecondaryCarets();
                Pair<BufferPosition, BufferPosition> pair4 = VimVisualGroupKt.blockToNativeSelection(editor, selectionStart, selectionEnd, mode);
                BufferPosition blockStart = (BufferPosition)pair4.component1();
                BufferPosition blockEnd = (BufferPosition)pair4.component2();
                int lastColumn = editor.primaryCaret().getVimLastColumn();
                editor.vimSetSystemBlockSelectionSilently(blockStart, blockEnd);
                VimInjectorKt.getInjector().getEditorGroup().updateCaretsVisualAttributes(editor);
                for (VimCaret aCaret : editor.nativeCarets()) {
                    if (!aCaret.isValid()) continue;
                    int line = aCaret.getBufferPosition().getLine();
                    int lineEndOffset = EngineEditorHelperKt.getLineEndOffset(editor, line, true);
                    int lineStartOffset = editor.getLineStartOffset(line);
                    if (lastColumn >= 9999) {
                        EngineVisualModeHelperKt.vimSetSystemSelectionSilently(aCaret, aCaret.getSelectionStart(), lineEndOffset);
                        int newOffset = RangesKt.coerceAtLeast((int)(lineEndOffset - VimInjectorKt.getInjector().getVisualMotionGroup().getSelectionAdj()), (int)lineStartOffset);
                        aCaret.moveToInlayAwareOffset(newOffset);
                    }
                    VimVisualPosition visualPosition = editor.offsetToVisualPosition(aCaret.getSelectionEnd());
                    if (aCaret.getOffset().getPoint() == aCaret.getSelectionEnd() && !Intrinsics.areEqual((Object)visualPosition, (Object)aCaret.getVisualPosition())) {
                        aCaret.moveToVisualPosition(visualPosition);
                    }
                    if (mode instanceof Mode.SELECT || EngineEditorHelperKt.isLineEmpty(editor, line, false) || aCaret.getOffset().getPoint() != aCaret.getSelectionEnd() || aCaret.getSelectionEnd() - 1 < lineStartOffset || aCaret.getSelectionEnd() - aCaret.getSelectionStart() == 0) continue;
                    aCaret.moveToVisualPosition(new VimVisualPosition(visualPosition.getLine(), visualPosition.getColumn() - 1, false, 4, null));
                }
                editor.primaryCaret().moveToInlayAwareOffset(selectionEnd);
            }
        }
    }

    public static final void vimSetSelection(@NotNull VimCaret $this$vimSetSelection, int start2, int end, boolean moveCaretToSelectionEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$vimSetSelection, (String)"<this>");
        $this$vimSetSelection.setVimSelectionStart(start2);
        EngineVisualGroupKt.setVisualSelection(start2, end, $this$vimSetSelection);
        if (moveCaretToSelectionEnd && !EditorExtensionsKt.getInBlockSelection($this$vimSetSelection.getEditor())) {
            $this$vimSetSelection.moveToInlayAwareOffset(end);
        }
    }

    public static /* synthetic */ void vimSetSelection$default(VimCaret vimCaret, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        EngineVisualGroupKt.vimSetSelection(vimCaret, n, n2, bl);
    }

    public static final void vimMoveBlockSelectionToOffset(@NotNull VimEditor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimCaret primaryCaret = editor.primaryCaret();
        int startOffsetMark = primaryCaret.getVimSelectionStart();
        EngineVisualGroupKt.setVisualSelection(startOffsetMark, offset, primaryCaret);
    }

    public static final void vimMoveSelectionToCaret(@NotNull VimCaret $this$vimMoveSelectionToCaret, int vimSelectionStart) {
        Intrinsics.checkNotNullParameter((Object)$this$vimMoveSelectionToCaret, (String)"<this>");
        if (!EditorExtensionsKt.getInVisualMode($this$vimMoveSelectionToCaret.getEditor()) && !EditorExtensionsKt.getInSelectMode($this$vimMoveSelectionToCaret.getEditor())) {
            throw new IllegalStateException("Attempt to extent selection in non-visual mode".toString());
        }
        if (EditorExtensionsKt.getInBlockSelection($this$vimMoveSelectionToCaret.getEditor())) {
            throw new IllegalStateException("Move caret with [vimMoveBlockSelectionToOffset]".toString());
        }
        int startOffsetMark = vimSelectionStart;
        EngineVisualGroupKt.setVisualSelection(startOffsetMark, $this$vimMoveSelectionToCaret.getOffset().getPoint(), $this$vimMoveSelectionToCaret);
    }

    public static /* synthetic */ void vimMoveSelectionToCaret$default(VimCaret vimCaret, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = vimCaret.getVimSelectionStart();
        }
        EngineVisualGroupKt.vimMoveSelectionToCaret(vimCaret, n);
    }

    public static final void vimUpdateEditorSelection(@NotNull VimCaret $this$vimUpdateEditorSelection) {
        Intrinsics.checkNotNullParameter((Object)$this$vimUpdateEditorSelection, (String)"<this>");
        int startOffsetMark = $this$vimUpdateEditorSelection.getVimSelectionStart();
        EngineVisualGroupKt.setVisualSelection(startOffsetMark, $this$vimUpdateEditorSelection.getOffset().getPoint(), $this$vimUpdateEditorSelection);
    }

    /*
     * WARNING - void declaration
     */
    public static final int getVimLeadSelectionOffset(@NotNull ImmutableVimCaret $this$vimLeadSelectionOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$vimLeadSelectionOffset, (String)"<this>");
        int caretOffset = $this$vimLeadSelectionOffset.getOffset().getPoint();
        if ($this$vimLeadSelectionOffset.hasSelection()) {
            int n;
            VimFoldRegion foldRegion;
            int selectionAdj = VimInjectorKt.getInjector().getVisualMotionGroup().getSelectionAdj();
            if (caretOffset != $this$vimLeadSelectionOffset.getSelectionStart() && caretOffset != $this$vimLeadSelectionOffset.getSelectionEnd() && (foldRegion = $this$vimLeadSelectionOffset.getEditor().getFoldRegionAtOffset(caretOffset)) != null) {
                if (foldRegion.getStartOffset().getPoint() == $this$vimLeadSelectionOffset.getSelectionStart()) {
                    return RangesKt.coerceAtLeast((int)($this$vimLeadSelectionOffset.getSelectionEnd() - selectionAdj), (int)0);
                }
                if (foldRegion.getEndOffset().getPoint() == $this$vimLeadSelectionOffset.getSelectionEnd()) {
                    return $this$vimLeadSelectionOffset.getSelectionStart();
                }
            }
            if (ModeExtensionsKt.getSelectionType($this$vimLeadSelectionOffset.getEditor().getMode()) == SelectionType.LINE_WISE) {
                int column;
                int selectionStartLine = $this$vimLeadSelectionOffset.getEditor().offsetToBufferPosition($this$vimLeadSelectionOffset.getSelectionStart()).getLine();
                int caretLine = $this$vimLeadSelectionOffset.getEditor().offsetToBufferPosition($this$vimLeadSelectionOffset.getOffset().getPoint()).getLine();
                n = caretLine == selectionStartLine ? ((column = $this$vimLeadSelectionOffset.getEditor().offsetToBufferPosition($this$vimLeadSelectionOffset.getSelectionEnd()).getColumn()) == 0 ? RangesKt.coerceAtLeast((int)($this$vimLeadSelectionOffset.getSelectionEnd() - 1), (int)0) : $this$vimLeadSelectionOffset.getSelectionEnd()) : $this$vimLeadSelectionOffset.getSelectionStart();
            } else if (EditorExtensionsKt.getInBlockSelection($this$vimLeadSelectionOffset.getEditor())) {
                void $this$sortedBy$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = $this$vimLeadSelectionOffset.getEditor().nativeCarets();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VimCaret vimCaret = (VimCaret)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)it.getSelectionStart(), (Object)it.getSelectionEnd()));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                List selections = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Integer)it.getFirst();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
                    }
                });
                VimCaret pCaret = $this$vimLeadSelectionOffset.getEditor().primaryCaret();
                int n2 = pCaret.getOffset().getPoint();
                n = n2 == ((Number)((Pair)CollectionsKt.first((List)selections)).getFirst()).intValue() ? RangesKt.coerceAtLeast((int)(((Number)((Pair)CollectionsKt.last((List)selections)).getSecond()).intValue() - selectionAdj), (int)0) : (n2 == ((Number)((Pair)CollectionsKt.first((List)selections)).getSecond()).intValue() ? ((Number)((Pair)CollectionsKt.last((List)selections)).getFirst()).intValue() : (n2 == ((Number)((Pair)CollectionsKt.last((List)selections)).getFirst()).intValue() ? RangesKt.coerceAtLeast((int)(((Number)((Pair)CollectionsKt.first((List)selections)).getSecond()).intValue() - selectionAdj), (int)0) : (n2 == ((Number)((Pair)CollectionsKt.last((List)selections)).getSecond()).intValue() ? ((Number)((Pair)CollectionsKt.first((List)selections)).getFirst()).intValue() : ((Number)((Pair)CollectionsKt.first((List)selections)).getFirst()).intValue())));
            } else {
                n = caretOffset == $this$vimLeadSelectionOffset.getSelectionStart() ? RangesKt.coerceAtLeast((int)($this$vimLeadSelectionOffset.getSelectionEnd() - selectionAdj), (int)0) : $this$vimLeadSelectionOffset.getSelectionStart();
            }
            return n;
        }
        return caretOffset;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SelectionType.values().length];
            try {
                nArray[SelectionType.CHARACTER_WISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.LINE_WISE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.BLOCK_WISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

