/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ranges.LineNumberRange;
import com.maddyhome.idea.vim.ex.ranges.MarkRange;
import com.maddyhome.idea.vim.ex.ranges.SearchRange;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0005J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H$J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0005H$J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0001\u0003\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/Range;", "", "offset", "", "isMove", "", "(IZ)V", "()Z", "getOffset", "()I", "equals", "other", "getLine", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "lastZero", "getRangeLine", "hashCode", "toString", "", "Companion", "Lcom/maddyhome/idea/vim/ex/ranges/LineNumberRange;", "Lcom/maddyhome/idea/vim/ex/ranges/MarkRange;", "Lcom/maddyhome/idea/vim/ex/ranges/SearchRange;", "vim-engine"})
public abstract class Range {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offset;
    private final boolean isMove;

    private Range(int offset, boolean isMove) {
        this.offset = offset;
        this.isMove = isMove;
    }

    protected final int getOffset() {
        return this.offset;
    }

    public final boolean isMove() {
        return this.isMove;
    }

    public final int getLine(@NotNull VimEditor editor, boolean lastZero) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int line = this.getRangeLine(editor, lastZero);
        return line + this.offset;
    }

    public final int getLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, boolean lastZero) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.offset == 0 ? this.getRangeLine(editor, lastZero) : this.getRangeLine(editor, caret, lastZero) + this.offset;
    }

    @NotNull
    public String toString() {
        return "Range{offset=" + this.offset + ", move=" + this.isMove + "}";
    }

    protected abstract int getRangeLine(@NotNull VimEditor var1, boolean var2);

    protected abstract int getRangeLine(@NotNull VimEditor var1, @NotNull ImmutableVimCaret var2, boolean var3);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Range)) {
            return false;
        }
        if (this.offset != ((Range)other).offset) {
            return false;
        }
        return this.isMove == ((Range)other).isMove;
    }

    public int hashCode() {
        int result = this.offset;
        result = 31 * result + Boolean.hashCode(this.isMove);
        return result;
    }

    @JvmStatic
    @Nullable
    public static final Range[] createRange(@NotNull String str, int offset, boolean move) {
        return Companion.createRange(str, offset, move);
    }

    public /* synthetic */ Range(int offset, boolean isMove, DefaultConstructorMarker $constructor_marker) {
        this(offset, isMove);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/Range$Companion;", "", "()V", "createRange", "", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "str", "", "offset", "", "move", "", "(Ljava/lang/String;IZ)[Lcom/maddyhome/idea/vim/ex/ranges/Range;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Range[] createRange(@NotNull String str, int offset, boolean move) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            if (((CharSequence)str).length() == 0 || Intrinsics.areEqual((Object)str, (Object)".")) {
                Range[] rangeArray = new Range[]{new LineNumberRange(offset, move)};
                return rangeArray;
            }
            if (Intrinsics.areEqual((Object)str, (Object)"%")) {
                Range[] rangeArray = new Range[]{new LineNumberRange(0, 0, move), new LineNumberRange(-99999998, offset, move)};
                return rangeArray;
            }
            if (Intrinsics.areEqual((Object)str, (Object)"$")) {
                Range[] rangeArray = new Range[]{new LineNumberRange(-99999998, offset, move)};
                return rangeArray;
            }
            if (StringsKt.startsWith$default((String)str, (String)"'", (boolean)false, (int)2, null) && str.length() == 2) {
                Range[] rangeArray = new Range[]{new MarkRange(str.charAt(1), offset, move)};
                return rangeArray;
            }
            if (StringsKt.startsWith$default((String)str, (String)"/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"\\/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"\\&", (boolean)false, (int)2, null)) {
                Range[] rangeArray = new Range[]{new SearchRange(str, offset, move)};
                return rangeArray;
            }
            if (StringsKt.startsWith$default((String)str, (String)"?", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"\\?", (boolean)false, (int)2, null)) {
                Range[] rangeArray = new Range[]{new SearchRange(str, offset, move)};
                return rangeArray;
            }
            try {
                int line = Integer.parseInt(str) - 1;
                Range[] rangeArray = new Range[]{new LineNumberRange(line, offset, move)};
                return rangeArray;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

