/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.mark.Mark;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0014J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007H\u0014J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/MarkRange;", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "mark", "", "offset", "", "move", "", "(CIZ)V", "equals", "other", "", "getRangeLine", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "lastZero", "hashCode", "toString", "", "vim-engine"})
public final class MarkRange
extends Range {
    private final char mark;

    public MarkRange(char mark, int offset, boolean move) {
        super(offset, move, null);
        this.mark = mark;
    }

    @Override
    protected int getRangeLine(@NotNull VimEditor editor, boolean lastZero) {
        Mark mark;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Mark mark2 = mark = VimInjectorKt.getInjector().getMarkService().getMark(editor.currentCaret(), this.mark);
        return mark2 != null ? mark2.getLine() : -1;
    }

    @Override
    protected int getRangeLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, boolean lastZero) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.getRangeLine(editor, lastZero);
    }

    @Override
    @NotNull
    public String toString() {
        return "MarkRange[mark=" + this.mark + ", " + super.toString() + "]";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ex.ranges.MarkRange");
        MarkRange cfr_ignored_0 = (MarkRange)other;
        if (this.mark != ((MarkRange)other).mark) {
            return false;
        }
        if (this.getOffset() != ((MarkRange)other).getOffset()) {
            return false;
        }
        return this.isMove() == ((MarkRange)other).isMove();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return prime * prime * Character.hashCode(this.mark) + prime * Integer.hashCode(this.getOffset()) + Boolean.hashCode(this.isMove());
    }
}

