/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ranges.Range;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J \u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/LineNumberRange;", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "offset", "", "move", "", "(IZ)V", "line", "(IIZ)V", "equals", "other", "", "getRangeLine", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "lastZero", "hashCode", "toString", "", "Companion", "vim-engine"})
public final class LineNumberRange
extends Range {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int line;
    public static final int CURRENT_LINE = -99999999;
    public static final int LAST_LINE = -99999998;

    public LineNumberRange(int offset, boolean move) {
        super(offset, move, null);
        this.line = -99999999;
    }

    public LineNumberRange(int line, int offset, boolean move) {
        super(offset, move, null);
        this.line = line;
    }

    @Override
    protected int getRangeLine(@NotNull VimEditor editor, boolean lastZero) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (this.line == -99999999) {
            this.line = editor.currentCaret().getBufferPosition().getLine();
        } else if (this.line == -99999998) {
            this.line = editor.lineCount() - 1;
        }
        return this.line;
    }

    @Override
    protected int getRangeLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, boolean lastZero) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.line = this.line == -99999998 ? editor.lineCount() - 1 : caret.getBufferPosition().getLine();
        return this.line;
    }

    @Override
    @NotNull
    public String toString() {
        return "LineNumberRange[line=" + this.line + ", " + super.toString() + "]";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ex.ranges.LineNumberRange");
        LineNumberRange cfr_ignored_0 = (LineNumberRange)other;
        if (this.line != ((LineNumberRange)other).line) {
            return false;
        }
        if (this.getOffset() != ((LineNumberRange)other).getOffset()) {
            return false;
        }
        return this.isMove() == ((LineNumberRange)other).isMove();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return Boolean.hashCode(this.isMove()) + prime * Integer.hashCode(this.getOffset()) + prime * prime * Integer.hashCode(this.line);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/LineNumberRange$Companion;", "", "()V", "CURRENT_LINE", "", "LAST_LINE", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

