/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.command;

import com.maddyhome.idea.vim.action.change.LazyVimCommand;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.DuplicableOperatorAction;
import com.maddyhome.idea.vim.common.CurrentCommandState;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.key.CommandPartNode;
import com.maddyhome.idea.vim.key.Node;
import com.maddyhome.idea.vim.key.RootNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\b\u0018\u0000 K2\u00020\u0001:\u0001KB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020!J\u000e\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020!J\u0006\u0010+\u001a\u00020\bJ\b\u0010,\u001a\u00020\u0000H\u0016J\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020(J\u0013\u00101\u001a\u00020\u00192\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\u0006\u00104\u001a\u00020(J\u0016\u00105\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u0001062\u0006\u0010)\u001a\u00020!J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u0006\u00108\u001a\u00020\u0019J\b\u00109\u001a\u00020\u0010H\u0016J\u0006\u0010:\u001a\u00020\u0019J\u0006\u0010;\u001a\u00020\u0019J\u0006\u0010<\u001a\u00020\u0019J\u000e\u0010=\u001a\u00020\u00192\u0006\u0010)\u001a\u00020!J\u0006\u0010>\u001a\u00020\u0019J\u0006\u0010?\u001a\u00020\bJ\u000e\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020BJ\u000e\u0010@\u001a\u00020(2\u0006\u0010C\u001a\u00020DJ\u0014\u0010E\u001a\u00020(2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0006\u0010G\u001a\u00020(J\u0014\u0010H\u001a\u00020(2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0014\u0010I\u001a\u00020(2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001aR\u0011\u0010\u001e\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/maddyhome/idea/vim/command/CommandBuilder;", "", "currentCommandPartNode", "Lcom/maddyhome/idea/vim/key/CommandPartNode;", "Lcom/maddyhome/idea/vim/action/change/LazyVimCommand;", "(Lcom/maddyhome/idea/vim/key/CommandPartNode;)V", "commandParts", "Lkotlin/collections/ArrayDeque;", "Lcom/maddyhome/idea/vim/command/Command;", "commandState", "Lcom/maddyhome/idea/vim/common/CurrentCommandState;", "getCommandState", "()Lcom/maddyhome/idea/vim/common/CurrentCommandState;", "setCommandState", "(Lcom/maddyhome/idea/vim/common/CurrentCommandState;)V", "<set-?>", "", "count", "getCount", "()I", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "expectedArgumentType", "getExpectedArgumentType", "()Lcom/maddyhome/idea/vim/command/Argument$Type;", "isAtDefaultState", "", "()Z", "isBad", "isEmpty", "isExpectingCount", "isReady", "keyList", "", "Ljavax/swing/KeyStroke;", "keys", "", "getKeys", "()Ljava/lang/Iterable;", "prevExpectedArgumentType", "addCountCharacter", "", "key", "addKey", "buildCommand", "clone", "completeCommandPart", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "deleteCountCharacter", "equals", "other", "", "fallbackToCharacterArgument", "getChildNode", "Lcom/maddyhome/idea/vim/key/Node;", "getCurrentTrie", "hasCurrentCommandPartArgument", "hashCode", "isAwaitingCharOrDigraphArgument", "isBuildingMultiKeyCommand", "isDone", "isDuplicateOperatorKeyStroke", "isPuttingLiteral", "popCommandPart", "pushCommandPart", "action", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "register", "", "resetAll", "commandPartNode", "resetCount", "resetInProgressCommandPart", "setCurrentCommandPartNode", "newNode", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommandBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandBuilder.kt\ncom/maddyhome/idea/vim/command/CommandBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,237:1\n1#2:238\n33#3,4:239\n33#3,4:243\n38#3:247\n*S KotlinDebug\n*F\n+ 1 CommandBuilder.kt\ncom/maddyhome/idea/vim/command/CommandBuilder\n*L\n111#1:239,4\n122#1:243,4\n234#1:247\n*E\n"})
public final class CommandBuilder
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CommandPartNode<LazyVimCommand> currentCommandPartNode;
    @NotNull
    private ArrayDeque<Command> commandParts;
    @NotNull
    private List<KeyStroke> keyList;
    @NotNull
    private CurrentCommandState commandState;
    private int count;
    @Nullable
    private Argument.Type expectedArgumentType;
    @Nullable
    private Argument.Type prevExpectedArgumentType;
    @NotNull
    private static final VimLogger LOG;

    public CommandBuilder(@NotNull CommandPartNode<LazyVimCommand> currentCommandPartNode) {
        Intrinsics.checkNotNullParameter(currentCommandPartNode, (String)"currentCommandPartNode");
        this.currentCommandPartNode = currentCommandPartNode;
        this.commandParts = new ArrayDeque();
        this.keyList = new ArrayList();
        this.commandState = CurrentCommandState.NEW_COMMAND;
    }

    @NotNull
    public final CurrentCommandState getCommandState() {
        return this.commandState;
    }

    public final void setCommandState(@NotNull CurrentCommandState currentCommandState) {
        Intrinsics.checkNotNullParameter((Object)((Object)currentCommandState), (String)"<set-?>");
        this.commandState = currentCommandState;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final Iterable<KeyStroke> getKeys() {
        return this.keyList;
    }

    @Nullable
    public final Argument.Type getExpectedArgumentType() {
        return this.expectedArgumentType;
    }

    public final boolean isReady() {
        return this.commandState == CurrentCommandState.READY;
    }

    public final boolean isBad() {
        return this.commandState == CurrentCommandState.BAD_COMMAND;
    }

    public final boolean isEmpty() {
        return this.commandParts.isEmpty();
    }

    public final boolean isAtDefaultState() {
        return this.isEmpty() && this.count == 0 && this.expectedArgumentType == null;
    }

    public final boolean isExpectingCount() {
        return this.commandState == CurrentCommandState.NEW_COMMAND && this.expectedArgumentType != Argument.Type.CHARACTER && this.expectedArgumentType != Argument.Type.DIGRAPH;
    }

    public final void pushCommandPart(@NotNull EditorActionHandlerBase action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.commandParts.add((Object)new Command(this.count, action2, action2.getType(), action2.getFlags()));
        this.prevExpectedArgumentType = this.expectedArgumentType;
        this.expectedArgumentType = action2.getArgumentType();
        this.count = 0;
    }

    public final void pushCommandPart(char register) {
        this.commandParts.add((Object)new Command(this.count, register));
        this.expectedArgumentType = null;
        this.count = 0;
    }

    @NotNull
    public final Command popCommandPart() {
        Command command2 = (Command)this.commandParts.removeLast();
        this.expectedArgumentType = this.commandParts.size() > 0 ? ((Command)this.commandParts.last()).getAction().getArgumentType() : null;
        return command2;
    }

    public final void fallbackToCharacterArgument() {
        boolean bl;
        boolean bl2 = bl = this.expectedArgumentType == Argument.Type.DIGRAPH;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Cannot move state from " + this.expectedArgumentType + " to CHARACTER";
            throw new AssertionError((Object)string);
        }
        this.expectedArgumentType = Argument.Type.CHARACTER;
    }

    public final void addKey(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.keyList.add(key);
    }

    public final void addCountCharacter(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.count = this.count * 10 + (key.getKeyChar() - 48);
        if (this.count < 0) {
            this.count = 999999999;
        }
        this.addKey(key);
    }

    public final void deleteCountCharacter() {
        this.count /= 10;
        this.keyList.remove(this.keyList.size() - 1);
    }

    public final void setCurrentCommandPartNode(@NotNull CommandPartNode<LazyVimCommand> newNode) {
        Intrinsics.checkNotNullParameter(newNode, (String)"newNode");
        this.currentCommandPartNode = newNode;
    }

    @Nullable
    public final Node<LazyVimCommand> getChildNode(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Node)this.currentCommandPartNode.get((Object)key);
    }

    public final boolean isAwaitingCharOrDigraphArgument() {
        if (this.commandParts.size() == 0) {
            return false;
        }
        Argument.Type argumentType = ((Command)this.commandParts.last()).getAction().getArgumentType();
        boolean awaiting = argumentType == Argument.Type.CHARACTER || argumentType == Argument.Type.DIGRAPH;
        VimLogger $this$debug$iv = LOG;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Awaiting char of digraph: " + awaiting);
        }
        return awaiting;
    }

    public final boolean isBuildingMultiKeyCommand() {
        boolean isMultikey = !(this.currentCommandPartNode instanceof RootNode);
        VimLogger $this$debug$iv = LOG;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Building multikey command: " + isMultikey);
        }
        return isMultikey;
    }

    public final boolean isPuttingLiteral() {
        return !this.commandParts.isEmpty() && Intrinsics.areEqual((Object)((Command)this.commandParts.last()).getAction().getId(), (Object)"VimInsertCompletedLiteralAction");
    }

    public final boolean isDone() {
        return this.commandParts.isEmpty();
    }

    public final void completeCommandPart(@NotNull Argument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        ((Command)this.commandParts.last()).setArgument(argument);
        this.commandState = CurrentCommandState.READY;
    }

    public final boolean isDuplicateOperatorKeyStroke(@NotNull KeyStroke key) {
        DuplicableOperatorAction action2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        EditorActionHandlerBase editorActionHandlerBase = ((Command)this.commandParts.last()).getAction();
        DuplicableOperatorAction duplicableOperatorAction = action2 = editorActionHandlerBase instanceof DuplicableOperatorAction ? (DuplicableOperatorAction)((Object)editorActionHandlerBase) : null;
        return duplicableOperatorAction != null ? duplicableOperatorAction.getDuplicateWith() == key.getKeyChar() : false;
    }

    public final boolean hasCurrentCommandPartArgument() {
        Command command2 = (Command)this.commandParts.firstOrNull();
        return (command2 != null ? command2.getArgument() : null) != null;
    }

    @NotNull
    public final Command buildCommand() {
        if (Intrinsics.areEqual((Object)((Command)this.commandParts.last()).getAction().getId(), (Object)"VimInsertCompletedDigraphAction") || Intrinsics.areEqual((Object)((Command)this.commandParts.last()).getAction().getId(), (Object)"VimResetModeAction")) {
            this.expectedArgumentType = this.prevExpectedArgumentType;
            this.prevExpectedArgumentType = null;
            return (Command)this.commandParts.removeLast();
        }
        Command command2 = (Command)this.commandParts.removeFirst();
        while (this.commandParts.size() > 0) {
            boolean bl;
            Command next = (Command)this.commandParts.removeFirst();
            next.setCount(command2.getRawCount() == 0 && next.getRawCount() == 0 ? 0 : command2.getCount() * next.getCount());
            command2.setCount(0);
            if (command2.getType() == Command.Type.SELECT_REGISTER) {
                next.setRegister(command2.getRegister());
                command2.setRegister(null);
                command2 = next;
                continue;
            }
            command2.setArgument(new Argument(next));
            boolean bl2 = bl = this.commandParts.size() == 0;
            if (!_Assertions.ENABLED || bl) continue;
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.expectedArgumentType = null;
        return command2;
    }

    public final void resetAll(@NotNull CommandPartNode<LazyVimCommand> commandPartNode) {
        Intrinsics.checkNotNullParameter(commandPartNode, (String)"commandPartNode");
        this.resetInProgressCommandPart(commandPartNode);
        this.commandState = CurrentCommandState.NEW_COMMAND;
        this.commandParts.clear();
        this.keyList.clear();
        this.expectedArgumentType = null;
        this.prevExpectedArgumentType = null;
    }

    public final void resetCount() {
        this.count = 0;
    }

    public final void resetInProgressCommandPart(@NotNull CommandPartNode<LazyVimCommand> commandPartNode) {
        Intrinsics.checkNotNullParameter(commandPartNode, (String)"commandPartNode");
        this.count = 0;
        this.setCurrentCommandPartNode(commandPartNode);
    }

    @TestOnly
    @NotNull
    public final CommandPartNode<LazyVimCommand> getCurrentTrie() {
        return this.currentCommandPartNode;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.command.CommandBuilder");
        CommandBuilder cfr_ignored_0 = (CommandBuilder)other;
        if (!Intrinsics.areEqual(this.currentCommandPartNode, ((CommandBuilder)other).currentCommandPartNode)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.commandParts, ((CommandBuilder)other).commandParts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyList, ((CommandBuilder)other).keyList)) {
            return false;
        }
        if (this.commandState != ((CommandBuilder)other).commandState) {
            return false;
        }
        if (this.count != ((CommandBuilder)other).count) {
            return false;
        }
        if (this.expectedArgumentType != ((CommandBuilder)other).expectedArgumentType) {
            return false;
        }
        return this.prevExpectedArgumentType == ((CommandBuilder)other).prevExpectedArgumentType;
    }

    public int hashCode() {
        int result = this.currentCommandPartNode.hashCode();
        result = 31 * result + this.commandParts.hashCode();
        result = 31 * result + ((Object)this.keyList).hashCode();
        result = 31 * result + this.commandState.hashCode();
        result = 31 * result + this.count;
        Argument.Type type = this.expectedArgumentType;
        result = 31 * result + (type != null ? type.hashCode() : 0);
        Argument.Type type2 = this.prevExpectedArgumentType;
        result = 31 * result + (type2 != null ? type2.hashCode() : 0);
        return result;
    }

    @NotNull
    public CommandBuilder clone() {
        CommandBuilder result = new CommandBuilder(this.currentCommandPartNode);
        result.commandParts = new ArrayDeque((Collection)this.commandParts);
        result.keyList = CollectionsKt.toMutableList((Collection)this.keyList);
        result.commandState = this.commandState;
        result.count = this.count;
        result.expectedArgumentType = this.expectedArgumentType;
        result.prevExpectedArgumentType = this.prevExpectedArgumentType;
        return result;
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(CommandBuilder.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/command/CommandBuilder$Companion;", "", "()V", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

