/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.command;

import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.MotionType;
import com.maddyhome.idea.vim.command.NonExecutableActionHandler;
import com.maddyhome.idea.vim.command.TextObjectVisualType;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.MotionActionHandler;
import com.maddyhome.idea.vim.handler.TextObjectActionHandler;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00018B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\bH\u00c6\u0003J\t\u0010.\u001a\u00020\nH\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J7\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u00020\u0003H\u00d6\u0001J\u0006\u00105\u001a\u000202J\t\u00106\u001a\u000207H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010)\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u00069"}, d2={"Lcom/maddyhome/idea/vim/command/Command;", "", "rawCount", "", "register", "", "(IC)V", "action", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "flags", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/command/CommandFlags;", "(ILcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;Lcom/maddyhome/idea/vim/command/Command$Type;Ljava/util/EnumSet;)V", "getAction", "()Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "setAction", "(Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;)V", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "getArgument", "()Lcom/maddyhome/idea/vim/command/Argument;", "setArgument", "(Lcom/maddyhome/idea/vim/command/Argument;)V", "value", "count", "getCount", "()I", "setCount", "(I)V", "getFlags", "()Ljava/util/EnumSet;", "setFlags", "(Ljava/util/EnumSet;)V", "getRawCount", "setRawCount", "getRegister", "()Ljava/lang/Character;", "setRegister", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "isLinewiseMotion", "toString", "", "Type", "vim-engine"})
public final class Command {
    private int rawCount;
    @NotNull
    private EditorActionHandlerBase action;
    @NotNull
    private final Type type;
    @NotNull
    private EnumSet<CommandFlags> flags;
    @Nullable
    private Argument argument;
    @Nullable
    private Character register;

    public Command(int rawCount, @NotNull EditorActionHandlerBase action2, @NotNull Type type, @NotNull EnumSet<CommandFlags> flags) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.rawCount = rawCount;
        this.action = action2;
        this.type = type;
        this.flags = flags;
        this.action.process(this);
    }

    public final int getRawCount() {
        return this.rawCount;
    }

    public final void setRawCount(int n) {
        this.rawCount = n;
    }

    @NotNull
    public final EditorActionHandlerBase getAction() {
        return this.action;
    }

    public final void setAction(@NotNull EditorActionHandlerBase editorActionHandlerBase) {
        Intrinsics.checkNotNullParameter((Object)editorActionHandlerBase, (String)"<set-?>");
        this.action = editorActionHandlerBase;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final EnumSet<CommandFlags> getFlags() {
        return this.flags;
    }

    public final void setFlags(@NotNull EnumSet<CommandFlags> enumSet) {
        Intrinsics.checkNotNullParameter(enumSet, (String)"<set-?>");
        this.flags = enumSet;
    }

    public Command(int rawCount, char register) {
        EditorActionHandlerBase editorActionHandlerBase = NonExecutableActionHandler.INSTANCE;
        EnumSet<Enum> enumSet = EnumSet.of((Enum)CommandFlags.FLAG_EXPECT_MORE);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        this(rawCount, editorActionHandlerBase, Type.SELECT_REGISTER, enumSet);
        this.register = Character.valueOf(register);
    }

    public final int getCount() {
        return RangesKt.coerceAtLeast((int)this.rawCount, (int)1);
    }

    public final void setCount(int value) {
        this.rawCount = value;
    }

    @Nullable
    public final Argument getArgument() {
        return this.argument;
    }

    public final void setArgument(@Nullable Argument argument) {
        this.argument = argument;
    }

    @Nullable
    public final Character getRegister() {
        return this.register;
    }

    public final void setRegister(@Nullable Character c) {
        this.register = c;
    }

    public final boolean isLinewiseMotion() {
        boolean bl;
        EditorActionHandlerBase editorActionHandlerBase = this.action;
        if (editorActionHandlerBase instanceof TextObjectActionHandler) {
            EditorActionHandlerBase editorActionHandlerBase2 = this.action;
            Intrinsics.checkNotNull((Object)editorActionHandlerBase2, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.TextObjectActionHandler");
            bl = ((TextObjectActionHandler)editorActionHandlerBase2).getVisualType() == TextObjectVisualType.LINE_WISE;
        } else if (editorActionHandlerBase instanceof MotionActionHandler) {
            EditorActionHandlerBase editorActionHandlerBase3 = this.action;
            Intrinsics.checkNotNull((Object)editorActionHandlerBase3, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.handler.MotionActionHandler");
            bl = ((MotionActionHandler)editorActionHandlerBase3).getMotionType() == MotionType.LINE_WISE;
        } else {
            throw new IllegalStateException(("Command is not a motion: " + this.action).toString());
        }
        return bl;
    }

    public final int component1() {
        return this.rawCount;
    }

    @NotNull
    public final EditorActionHandlerBase component2() {
        return this.action;
    }

    @NotNull
    public final Type component3() {
        return this.type;
    }

    @NotNull
    public final EnumSet<CommandFlags> component4() {
        return this.flags;
    }

    @NotNull
    public final Command copy(int rawCount, @NotNull EditorActionHandlerBase action2, @NotNull Type type, @NotNull EnumSet<CommandFlags> flags) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        return new Command(rawCount, action2, type, flags);
    }

    public static /* synthetic */ Command copy$default(Command command2, int n, EditorActionHandlerBase editorActionHandlerBase, Type type, EnumSet enumSet, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = command2.rawCount;
        }
        if ((n2 & 2) != 0) {
            editorActionHandlerBase = command2.action;
        }
        if ((n2 & 4) != 0) {
            type = command2.type;
        }
        if ((n2 & 8) != 0) {
            enumSet = command2.flags;
        }
        return command2.copy(n, editorActionHandlerBase, type, enumSet);
    }

    @NotNull
    public String toString() {
        return "Command(rawCount=" + this.rawCount + ", action=" + this.action + ", type=" + this.type + ", flags=" + this.flags + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.rawCount);
        result = result * 31 + this.action.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.flags.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Command)) {
            return false;
        }
        Command command2 = (Command)other;
        if (this.rawCount != command2.rawCount) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.action, (Object)command2.action)) {
            return false;
        }
        if (this.type != command2.type) {
            return false;
        }
        return Intrinsics.areEqual(this.flags, command2.flags);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/command/Command$Type;", "", "(Ljava/lang/String;I)V", "isRead", "", "()Z", "isWrite", "MOTION", "INSERT", "DELETE", "CHANGE", "COPY", "PASTE", "SELECT_REGISTER", "OTHER_READONLY", "OTHER_WRITABLE", "OTHER_SELF_SYNCHRONIZED", "vim-engine"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type MOTION = new Type();
        public static final /* enum */ Type INSERT = new Type();
        public static final /* enum */ Type DELETE = new Type();
        public static final /* enum */ Type CHANGE = new Type();
        public static final /* enum */ Type COPY = new Type();
        public static final /* enum */ Type PASTE = new Type();
        public static final /* enum */ Type SELECT_REGISTER = new Type();
        public static final /* enum */ Type OTHER_READONLY = new Type();
        public static final /* enum */ Type OTHER_WRITABLE = new Type();
        public static final /* enum */ Type OTHER_SELF_SYNCHRONIZED = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isRead() {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean isWrite() {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.MOTION, Type.INSERT, Type.DELETE, Type.CHANGE, Type.COPY, Type.PASTE, Type.SELECT_REGISTER, Type.OTHER_READONLY, Type.OTHER_WRITABLE, Type.OTHER_SELF_SYNCHRONIZED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                try {
                    nArray[Type.MOTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.COPY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.OTHER_READONLY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.INSERT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.DELETE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.CHANGE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.PASTE.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.OTHER_WRITABLE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

