/*
 * Decompiled with CFR 0.152.
 */
package org.cef.handler;

import java.util.Arrays;
import org.cef.CefApp;
import org.cef.callback.CefCommandLine;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandler;
import org.cef.misc.CefLog;

public abstract class CefAppHandlerAdapter
implements CefAppHandler {
    private final String[] args_;

    public CefAppHandlerAdapter(String[] args) {
        this.args_ = args;
    }

    public String[] getArgs() {
        return this.args_ == null ? null : Arrays.copyOf(this.args_, this.args_.length);
    }

    @Override
    public void onBeforeCommandLineProcessing(String process_type, CefCommandLine command_line) {
        if (process_type.isEmpty() && this.args_ != null) {
            boolean parseSwitchesDone = false;
            block5: for (String arg : this.args_) {
                if (parseSwitchesDone || arg.length() < 2) {
                    command_line.appendArgument(arg);
                    continue;
                }
                int switchCnt = arg.startsWith("--") ? 2 : (arg.startsWith("/") ? 1 : (arg.startsWith("-") ? 1 : 0));
                switch (switchCnt) {
                    case 2: {
                        if (arg.length() == 2) {
                            parseSwitchesDone = true;
                            continue block5;
                        }
                    }
                    case 1: {
                        String[] switchVals = arg.substring(switchCnt).split("=");
                        if (switchVals.length == 2) {
                            command_line.appendSwitchWithValue(switchVals[0], switchVals[1]);
                            continue block5;
                        }
                        command_line.appendSwitch(switchVals[0]);
                        continue block5;
                    }
                    case 0: {
                        command_line.appendArgument(arg);
                    }
                }
            }
        }
    }

    @Override
    public boolean onBeforeTerminate() {
        return false;
    }

    @Override
    public void stateHasChanged(CefApp.CefAppState state2) {
    }

    @Override
    public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
    }

    @Override
    public void onContextInitialized() {
    }

    @Override
    public void onScheduleMessagePumpWork(long delay_ms) {
        if (CefApp.getState() == CefApp.CefAppState.TERMINATED) {
            CefLog.Debug("CefApp is terminated, skip doMessageLoopWork", new Object[0]);
            return;
        }
        CefApp.getInstance().doMessageLoopWork(delay_ms);
    }

    @Override
    public void onBeforeChildProcessLaunch(String command_line) {
    }
}

