/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.callback.RemoteSchemeHandlerFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.handler.CefAppStateHandler;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class CefApp
extends CefAppHandlerAdapter {
    private static CefApp self = null;
    private static CefAppHandler appHandler_ = null;
    private static CefAppState state_ = CefAppState.NONE;
    private static final CompletableFuture<Void> ourStartupFeature = new CompletableFuture();
    private Timer workTimer_ = null;
    private final HashSet<CefClient> clients_ = new HashSet();
    private CefSettings settings_ = null;
    private volatile boolean isInitialized_ = false;
    private final LinkedList<CefAppStateHandler> initializationListeners_ = new LinkedList();
    private static final boolean PREINIT_ON_ANY_THREAD = Utils.getBoolean("jcef_app_preinit_any");
    private static final int PREINIT_TEST_DELAY_MS = Utils.getInteger("jcef_app_preinit_test_delay_ms", 0);
    private static final int INIT_TEST_DELAY_MS = Utils.getInteger("jcef_app_init_test_delay_ms", 0);
    private static final boolean IS_REMOTE_ENABLED = Boolean.getBoolean("jcef.remote.enabled");

    private CefApp(String[] args, CefSettings settings) {
        super(args);
        if (settings != null) {
            this.settings_ = settings.clone();
        }
        CefLog.init(settings);
        CefApp.setState(CefAppState.NEW);
        ourStartupFeature.thenRunAsync(() -> {
            if (IS_REMOTE_ENABLED) {
                if (CefServer.connect(appHandler_, this.settings_)) {
                    CefLog.Debug("CefApp: native CefServer is initialized.", new Object[0]);
                    CefApp.setState(CefAppState.INITIALIZED);
                    LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
                    synchronized (linkedList) {
                        this.isInitialized_ = true;
                        this.initializationListeners_.forEach(l -> l.stateHasChanged(CefAppState.INITIALIZED));
                        this.initializationListeners_.clear();
                    }
                    CefLog.Info("Connected to CefServer. JCEF version: %s", this.getVersion());
                }
            } else {
                this.preinit(args);
                this.initialize();
            }
        }, new NamedThreadExecutor("CefInitialize-thread"));
    }

    private void preinit(String[] args) throws RuntimeException {
        AtomicBoolean success = new AtomicBoolean(false);
        if (PREINIT_ON_ANY_THREAD) {
            success.set(this.N_PreInitialize());
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> success.set(this.N_PreInitialize()));
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException("Failed to do JCEF preinit", e);
            }
        }
        if (!success.get()) {
            throw new RuntimeException("Failed to do JCEF preinit");
        }
    }

    public void onInitialization(CefAppStateHandler initListener) {
        this.onInitialization(initListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitialization(CefAppStateHandler initListener, boolean first) {
        LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
        synchronized (linkedList) {
            if (this.isInitialized_) {
                initListener.stateHasChanged(CefAppState.INITIALIZED);
            } else if (first) {
                this.initializationListeners_.addFirst(initListener);
            } else {
                this.initializationListeners_.addLast(initListener);
            }
        }
    }

    public static void addAppHandler(CefAppHandler appHandler) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Must be called before CefApp is initialized");
        }
        appHandler_ = appHandler;
    }

    public static synchronized CefApp getInstance() {
        return CefApp.getInstance(null, null);
    }

    public static synchronized CefApp getInstance(String[] args) {
        return CefApp.getInstance(args, null);
    }

    public static synchronized CefApp getInstance(CefSettings settings) throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, settings);
    }

    public static synchronized CefApp getInstance(String[] args, CefSettings settings) {
        if (settings != null && CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time. Current state is " + CefApp.getState());
        }
        if (self == null) {
            if (CefApp.getState() == CefAppState.TERMINATED) {
                throw new IllegalStateException("CefApp was terminated");
            }
            assert (CefApp.getState() == CefAppState.NONE);
            self = new CefApp(args, settings);
        }
        return self;
    }

    public static synchronized CefApp getInstanceIfAny() throws UnsatisfiedLinkError {
        return self;
    }

    public final void setSettings(CefSettings settings) throws IllegalStateException {
        if (CefApp.getState().compareTo(CefAppState.NEW) > 0) {
            throw new IllegalStateException("Settings can only be passed to CEF before createClient is called the first time. Current state is " + CefApp.getState());
        }
        this.settings_ = settings.clone();
    }

    public final CefVersion getVersion() {
        if (IS_REMOTE_ENABLED) {
            return new CefVersion(0, "0", 0, 0, 0, 0, 0, 0, 0, 0){

                @Override
                public String toString() {
                    return "remote_" + CefServer.getVersion();
                }

                @Override
                public String getJcefVersion() {
                    return "remote_" + CefServer.getVersion();
                }
            };
        }
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError ule) {
            CefLog.Error("Failed to get CEF version. %s", ule.getMessage());
            return null;
        }
    }

    public static final boolean isRemoteEnabled() {
        return IS_REMOTE_ENABLED;
    }

    public static CefAppState getState() {
        return state_;
    }

    private static void setState(final CefAppState state2) {
        if (state2.compareTo(state_) < 0) {
            String errMsg = "CefApp: state cannot go backward. Current state " + state_ + ". Proposed state " + state2;
            CefLog.Error(errMsg, new Object[0]);
            throw new IllegalStateException(errMsg);
        }
        CefLog.Info("CefApp: set state %s", new Object[]{state2});
        state_ = state2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefAppHandler handler;
                CefAppHandler cefAppHandler = handler = appHandler_ == null ? self : appHandler_;
                if (handler != null) {
                    handler.stateHasChanged(state2);
                }
            }
        });
    }

    public final synchronized void dispose() {
        switch (CefApp.getState()) {
            case NEW: {
                CefApp.setState(CefAppState.TERMINATED);
                self = null;
                break;
            }
            case INITIALIZING: 
            case INITIALIZED: {
                CefApp.setState(CefAppState.SHUTTING_DOWN);
                if (this.clients_.isEmpty()) {
                    this.finishShutdown();
                    break;
                }
                CefLog.Debug("CefApp: dispose clients before shutting down", new Object[0]);
                HashSet<CefClient> clients = new HashSet<CefClient>(this.clients_);
                for (CefClient c : clients) {
                    CefLog.Debug("CefApp: dispose %s", c);
                    c.dispose();
                }
                break;
            }
        }
    }

    public synchronized CefClient createClient() {
        if (state_.compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            String errMsg = "Can't create client in state " + state_;
            CefLog.Error(errMsg, new Object[0]);
            throw new IllegalStateException(errMsg);
        }
        CefClient client = new CefClient();
        this.onInitialization(client, true);
        this.clients_.add(client);
        return client;
    }

    public boolean registerSchemeHandlerFactory(String schemeName, String domainName, CefSchemeHandlerFactory factory) {
        if (IS_REMOTE_ENABLED) {
            CefServer.instance().onConnected(() -> {
                RemoteSchemeHandlerFactory rf = RemoteSchemeHandlerFactory.create(factory);
                CefServer.instance().getService().exec(s -> s.SchemeHandlerFactory_Register(schemeName, domainName, rf.thriftId()));
            }, "registerSchemeHandlerFactory", true);
            return true;
        }
        this.onInitialization(state2 -> {
            if (!this.N_RegisterSchemeHandlerFactory(schemeName, domainName, factory)) {
                CefLog.Error("Can't register scheme [%s:%s]", schemeName, domainName);
            }
        });
        return true;
    }

    public boolean clearSchemeHandlerFactories() {
        if (IS_REMOTE_ENABLED) {
            CefServer.instance().onConnected(() -> CefServer.instance().getService().exec(s -> s.ClearAllSchemeHandlerFactories()), "clearSchemeHandlerFactories", false);
            return true;
        }
        if (!this.isInitialized_) {
            return false;
        }
        return this.N_ClearSchemeHandlerFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void clientWasDisposed(CefClient client) {
        this.clients_.remove(client);
        LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
        synchronized (linkedList) {
            this.initializationListeners_.remove(client);
        }
        CefLog.Debug("CefApp: client was disposed: %s [clients count %d]", client, this.clients_.size());
        if (this.clients_.isEmpty() && CefApp.getState().compareTo(CefAppState.SHUTTING_DOWN) >= 0) {
            this.finishShutdown();
        }
    }

    private static void testSleep(int ms) {
        if (ms > 0) {
            CefLog.Debug("testSleep %s ms", ms);
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        CefApp.setState(CefAppState.INITIALIZING);
        CefApp.testSleep(INIT_TEST_DELAY_MS);
        String logMsg = "Initialize CefApp on " + Thread.currentThread();
        if (this.settings_.log_severity == CefSettings.LogSeverity.LOGSEVERITY_INFO || this.settings_.log_severity == CefSettings.LogSeverity.LOGSEVERITY_VERBOSE) {
            CefLog.Info(logMsg, new Object[0]);
        } else {
            CefLog.Debug(logMsg, new Object[0]);
        }
        CefSettings settings = this.settings_ != null ? this.settings_ : new CefSettings();
        boolean success = this.N_Initialize(appHandler_ == null ? this : appHandler_, settings, false);
        if (success) {
            CefLog.Debug("CefApp: native initialization is finished.", new Object[0]);
            CefApp.setState(CefAppState.INITIALIZED);
            LinkedList<CefAppStateHandler> linkedList = this.initializationListeners_;
            synchronized (linkedList) {
                this.isInitialized_ = true;
                this.initializationListeners_.forEach(l -> l.stateHasChanged(CefAppState.INITIALIZED));
                this.initializationListeners_.clear();
            }
            CefLog.Info("version: %s | settings: %s", this.getVersion(), settings.getDescription());
        } else {
            CefLog.Error("CefApp: N_Initialize failed.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishShutdown() {
        if (IS_REMOTE_ENABLED) {
            CefServer.instance().disconnect();
            CefApp cefApp = this;
            synchronized (cefApp) {
                CefApp.setState(CefAppState.TERMINATED);
                self = null;
            }
            return;
        }
        new Thread(() -> {
            int sleepBeforeShutdown = Utils.getInteger("JCEF_SLEEP_BEFORE_SHUTDOWN", 999);
            if (sleepBeforeShutdown > 0) {
                try {
                    CefLog.Debug("Sleep before native shutdown for %d ms, thread %s.", sleepBeforeShutdown, Thread.currentThread());
                    Thread.sleep(sleepBeforeShutdown);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            CefLog.Info("Perform native shutdown of CEF on thread %s.", Thread.currentThread());
            this.N_Shutdown();
            CefApp cefApp = this;
            synchronized (cefApp) {
                CefApp.setState(CefAppState.TERMINATED);
                self = null;
            }
        }, "CEF-shutdown-thread").start();
    }

    public final void doMessageLoopWork(final long delay_ms) {
        if (IS_REMOTE_ENABLED) {
            CefLog.Error("doMessageLoopWork musn't be called in remote mode.", new Object[0]);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CefApp.getState() == CefAppState.TERMINATED) {
                    return;
                }
                long kMaxTimerDelay = 33L;
                if (CefApp.this.workTimer_ != null) {
                    CefApp.this.workTimer_.stop();
                    CefApp.this.workTimer_ = null;
                }
                if (delay_ms <= 0L) {
                    CefApp.this.N_DoMessageLoopWork();
                    CefApp.this.doMessageLoopWork(33L);
                } else {
                    long timer_delay_ms = delay_ms;
                    if (timer_delay_ms > 33L) {
                        timer_delay_ms = 33L;
                    }
                    CefApp.this.workTimer_ = new Timer((int)timer_delay_ms, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            CefApp.this.workTimer_.stop();
                            CefApp.this.workTimer_ = null;
                            CefApp.this.N_DoMessageLoopWork();
                            CefApp.this.doMessageLoopWork(33L);
                        }
                    });
                    CefApp.this.workTimer_.start();
                }
            }
        });
    }

    public static boolean startup(String[] args) {
        if (OS.isMacintosh() && args.length == 0) {
            CefApp.startupAsync(JCefAppConfig.getJbrFrameworkPathOSX());
            return true;
        }
        String frameworkPathOSX = null;
        String switchPrefix = "--framework-dir-path=";
        for (String arg : args) {
            if (!arg.startsWith(switchPrefix)) continue;
            frameworkPathOSX = new File(arg.substring(switchPrefix.length())).getAbsolutePath();
        }
        CefApp.startupAsync(frameworkPathOSX);
        return true;
    }

    @Deprecated(forRemoval=true)
    public static void startupAsync() {
        CefApp.startupAsync(JCefAppConfig.getJbrFrameworkPathOSX());
    }

    public static void startupAsync(String frameworkPath) {
        if (IS_REMOTE_ENABLED) {
            ourStartupFeature.complete(null);
            return;
        }
        new NamedThreadExecutor("CefStartup-thread").execute(() -> {
            try {
                if (OS.isWindows()) {
                    try {
                        SystemBootstrap.loadLibrary("jawt");
                    }
                    catch (UnsatisfiedLinkError e) {
                        CefLog.Error("can't load jawt library: " + e.getMessage(), new Object[0]);
                    }
                    SystemBootstrap.loadLibrary("chrome_elf");
                    SystemBootstrap.loadLibrary("libcef");
                } else if (OS.isLinux()) {
                    SystemBootstrap.loadLibrary("cef");
                }
                SystemBootstrap.loadLibrary("jcef");
                CefApp.N_Startup(frameworkPath);
                ourStartupFeature.complete(null);
            }
            catch (Throwable e) {
                ourStartupFeature.completeExceptionally(e);
            }
        });
    }

    private static native boolean N_Startup(String var0);

    private native boolean N_PreInitialize();

    private native boolean N_Initialize(CefAppHandler var1, CefSettings var2, boolean var3);

    private native void N_Shutdown();

    private native void N_DoMessageLoopWork();

    private native CefVersion N_GetVersion();

    private native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    private native boolean N_ClearSchemeHandlerFactories();

    public static enum CefAppState {
        NONE,
        NEW,
        INITIALIZING,
        INITIALIZED,
        SHUTTING_DOWN,
        TERMINATED;

    }

    static class NamedThreadExecutor
    implements Executor {
        private final String name;

        NamedThreadExecutor(String name) {
            this.name = name;
        }

        @Override
        public void execute(Runnable command) {
            new Thread(command, this.name).start();
        }
    }

    public class CefVersion {
        public final int JCEF_COMMIT_NUMBER;
        public final String JCEF_COMMIT_HASH;
        public final int CEF_VERSION_MAJOR;
        public final int CEF_VERSION_MINOR;
        public final int CEF_VERSION_PATCH;
        public final int CEF_COMMIT_NUMBER;
        public final int CHROME_VERSION_MAJOR;
        public final int CHROME_VERSION_MINOR;
        public final int CHROME_VERSION_BUILD;
        public final int CHROME_VERSION_PATCH;

        protected CefVersion(int jcefCommitNo, String jcefCommitHash, int cefMajor, int cefMinor, int cefPatch, int cefCommitNo, int chrMajor, int chrMin, int chrBuild, int chrPatch) {
            this.JCEF_COMMIT_NUMBER = jcefCommitNo;
            this.JCEF_COMMIT_HASH = jcefCommitHash;
            this.CEF_VERSION_MAJOR = cefMajor;
            this.CEF_VERSION_MINOR = cefMinor;
            this.CEF_VERSION_PATCH = cefPatch;
            this.CEF_COMMIT_NUMBER = cefCommitNo;
            this.CHROME_VERSION_MAJOR = chrMajor;
            this.CHROME_VERSION_MINOR = chrMin;
            this.CHROME_VERSION_BUILD = chrBuild;
            this.CHROME_VERSION_PATCH = chrPatch;
        }

        public String getJcefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH + "." + this.JCEF_COMMIT_NUMBER + "." + this.JCEF_COMMIT_HASH;
        }

        public String getCefVersion() {
            return this.CEF_VERSION_MAJOR + "." + this.CEF_VERSION_MINOR + "." + this.CEF_VERSION_PATCH;
        }

        public String getChromeVersion() {
            return this.CHROME_VERSION_MAJOR + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\nCEF Version = " + this.getCefVersion() + "\nChromium Version = " + this.getChromeVersion();
        }
    }
}

