/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.RemoteServerObject;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.callback.RemoteCompletionCallback;
import com.jetbrains.cef.remote.network.RemoteCookieManager;
import com.jetbrains.cef.remote.network.RemoteCookieVisitor;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefCookieVisitor;
import org.cef.misc.CefLog;
import org.cef.network.CefCookie;

public class RemoteCookieManagerImpl
extends RemoteServerObject {
    private RemoteCookieManagerImpl(RpcExecutor server, RObject robj) {
        super(server, robj);
    }

    public static RemoteCookieManagerImpl create(RpcExecutor server) {
        RObject robj = server.execObj(s -> s.CookieManager_Create());
        if (robj.objId < 0) {
            CefLog.Error("CookieManager_Create returns invalid objId %d.", robj.objId);
            return null;
        }
        return new RemoteCookieManagerImpl(server, robj);
    }

    @Override
    protected void disposeOnServerImpl() {
        this.myServer.exec(s -> s.CookieManager_Dispose(this.thriftId()));
    }

    @Override
    public void flush() {
    }

    public boolean visitAllCookies(CefCookieVisitor visitor) {
        if (visitor == null) {
            return false;
        }
        RemoteCookieVisitor rvisitor = RemoteCookieVisitor.create(visitor);
        return this.myServer.execObj(s -> s.CookieManager_VisitAllCookies(this.thriftId(), rvisitor.thriftId()));
    }

    public boolean visitUrlCookies(String url, boolean includeHttpOnly, CefCookieVisitor visitor) {
        if (visitor == null) {
            return false;
        }
        RemoteCookieVisitor rvisitor = RemoteCookieVisitor.create(visitor);
        return this.myServer.execObj(s -> s.CookieManager_VisitUrlCookies(this.thriftId(), rvisitor.thriftId(), url, includeHttpOnly));
    }

    public boolean setCookie(String url, CefCookie cookie) {
        return this.myServer.execObj(s -> s.CookieManager_SetCookie(this.thriftId(), url, RemoteCookieManager.toThriftCookie(cookie)));
    }

    public boolean deleteCookies(String url, String cookieName) {
        return this.myServer.execObj(s -> s.CookieManager_DeleteCookies(this.thriftId(), url, cookieName));
    }

    public boolean flushStore(CefCompletionCallback callback) {
        RObject cbId = callback != null ? RemoteCompletionCallback.create(callback).thriftId() : new RObject(-1);
        return this.myServer.execObj(s -> s.CookieManager_FlushStore(this.thriftId(), cbId));
    }
}

