/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.RemoteBrowser;
import com.jetbrains.cef.remote.RemoteFrame;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.callback.RemoteAuthCallback;
import com.jetbrains.cef.remote.callback.RemoteCallback;
import com.jetbrains.cef.remote.callback.RemoteCompletionCallback;
import com.jetbrains.cef.remote.callback.RemoteSchemeHandlerFactory;
import com.jetbrains.cef.remote.network.RemoteCookieAccessFilter;
import com.jetbrains.cef.remote.network.RemoteCookieManager;
import com.jetbrains.cef.remote.network.RemoteCookieVisitor;
import com.jetbrains.cef.remote.network.RemoteRequest;
import com.jetbrains.cef.remote.network.RemoteRequestContextHandler;
import com.jetbrains.cef.remote.network.RemoteRequestImpl;
import com.jetbrains.cef.remote.network.RemoteResourceHandler;
import com.jetbrains.cef.remote.network.RemoteResourceRequestHandler;
import com.jetbrains.cef.remote.network.RemoteResponse;
import com.jetbrains.cef.remote.network.RemoteResponseImpl;
import com.jetbrains.cef.remote.network.RemoteSSLInfo;
import com.jetbrains.cef.remote.router.RemoteMessageRouterHandler;
import com.jetbrains.cef.remote.router.RemoteQueryCallback;
import com.jetbrains.cef.remote.thrift_codegen.ClientHandlers;
import com.jetbrains.cef.remote.thrift_codegen.Cookie;
import com.jetbrains.cef.remote.thrift_codegen.KeyEvent;
import com.jetbrains.cef.remote.thrift_codegen.Point;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import com.jetbrains.cef.remote.thrift_codegen.Rect;
import com.jetbrains.cef.remote.thrift_codegen.ResponseData;
import com.jetbrains.cef.remote.thrift_codegen.ResponseHeaders;
import com.jetbrains.cef.remote.thrift_codegen.ScreenInfo;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;
import org.cef.CefSettings;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefCookieVisitor;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefCookieAccessFilter;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefNativeRenderHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestContextHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefScreenInfo;
import org.cef.misc.BoolRef;
import org.cef.misc.CefLog;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.misc.Utils;
import org.cef.network.CefCookie;
import org.cef.network.CefRequest;
import org.cef.network.CefURLRequest;
import org.cef.security.CefSSLInfo;

public class ClientHandlersImpl
implements ClientHandlers.Iface {
    private static final boolean TRACE_REMOTE_FIND_BID = Utils.getBoolean("TRACE_REMOTE_FIND_BID");
    private final Map<Integer, RemoteBrowser> myBid2RemoteBrowser;
    private Runnable myOnContextInitialized;
    private final RpcExecutor myService;
    private static final Rect INVALID_RECT = new Rect(0, 0, -1, -1);
    private static final Point INVALID_POINT = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private static final ScreenInfo INVALID_SCREENINFO = new ScreenInfo(-1.0, -1, -1, false, new Rect(), new Rect());
    private static final RObject INVALID = new RObject(-1);

    public ClientHandlersImpl(RpcExecutor service, Map<Integer, RemoteBrowser> bid2RemoteBrowser) {
        this.myService = service;
        this.myBid2RemoteBrowser = bid2RemoteBrowser;
    }

    public void setOnContextInitialized(Runnable onContextInitialized) {
        this.myOnContextInitialized = onContextInitialized;
    }

    private RemoteBrowser getRemoteBrowser(int bid) {
        RemoteBrowser browser = this.myBid2RemoteBrowser.get(bid);
        if (browser == null) {
            if (TRACE_REMOTE_FIND_BID) {
                CefLog.Debug("Can't find remote browser with bid=%d.", bid);
            }
            return null;
        }
        return browser;
    }

    @Override
    public int connect() {
        return 0;
    }

    @Override
    public void log(String msg) {
        CefLog.Debug("received message from CefServer: " + msg, new Object[0]);
    }

    @Override
    public void AppHandler_OnContextInitialized() {
        CefLog.Debug("AppHandler_OnContextInitialized: ", new Object[0]);
        if (this.myOnContextInitialized != null) {
            this.myOnContextInitialized.run();
        }
    }

    @Override
    public Rect RenderHandler_GetViewRect(int bid) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return INVALID_RECT;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return INVALID_RECT;
        }
        Rectangle rect = rh.getViewRect(browser);
        return new Rect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public ScreenInfo RenderHandler_GetScreenInfo(int bid) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return INVALID_SCREENINFO;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return INVALID_SCREENINFO;
        }
        CefScreenInfo csi = new CefScreenInfo();
        boolean success = rh.getScreenInfo(browser, csi);
        return success ? new ScreenInfo(csi.device_scale_factor, csi.depth, csi.depth_per_component, csi.is_monochrome, new Rect(csi.x, csi.y, csi.width, csi.height), new Rect(csi.available_x, csi.available_y, csi.available_width, csi.available_height)) : INVALID_SCREENINFO;
    }

    @Override
    public Point RenderHandler_GetScreenPoint(int bid, int viewX, int viewY) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return INVALID_POINT;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return INVALID_POINT;
        }
        java.awt.Point res = rh.getScreenPoint(browser, new java.awt.Point(viewX, viewY));
        return new Point(res.x, res.y);
    }

    @Override
    public void RenderHandler_OnPaint(int bid, boolean popup, int dirtyRectsCount, String sharedMemName, long sharedMemHandle, int width, int height) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefRenderHandler rh = browser.getRenderHandler();
        if (rh == null) {
            return;
        }
        ((CefNativeRenderHandler)rh).onPaintWithSharedMem(browser, popup, dirtyRectsCount, sharedMemName, sharedMemHandle, width, height);
    }

    @Override
    public boolean LifeSpanHandler_OnBeforePopup(int bid, RObject frame, String url, String frameName, boolean gesture) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        return browser.getOwner().hLifeSpan.handleBool(lsh -> lsh.onBeforePopup(browser, rframe, url, frameName));
    }

    @Override
    public void LifeSpanHandler_OnAfterCreated(int bid, int nativeBrowserIdentifier) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        browser.getOwner().onAfterCreated(browser, nativeBrowserIdentifier);
    }

    @Override
    public void LifeSpanHandler_OnBeforeClose(int bid) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        browser.getOwner().onBeforeClosed(browser);
    }

    @Override
    public boolean LifeSpanHandler_DoClose(int bid) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser != null) {
            browser.getOwner().hLifeSpan.handle(lsh -> lsh.doClose(browser));
        }
        return false;
    }

    @Override
    public void LoadHandler_OnLoadingStateChange(int bid, boolean isLoading, boolean canGoBack, boolean canGoForward) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefLoadHandler loadHandler = browser.getOwner().getLoadHandler();
        if (loadHandler == null) {
            return;
        }
        loadHandler.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward);
    }

    @Override
    public void LoadHandler_OnLoadStart(int bid, RObject frame, int transition_type) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefLoadHandler loadHandler = browser.getOwner().getLoadHandler();
        if (loadHandler == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        loadHandler.onLoadStart(browser, rframe, CefRequest.TransitionType.TT_LINK);
    }

    @Override
    public void LoadHandler_OnLoadEnd(int bid, RObject frame, int httpStatusCode) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefLoadHandler loadHandler = browser.getOwner().getLoadHandler();
        if (loadHandler == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        loadHandler.onLoadEnd(browser, rframe, httpStatusCode);
    }

    @Override
    public void LoadHandler_OnLoadError(int bid, RObject frame, int errorCode, String errorText, String failedUrl) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefLoadHandler loadHandler = browser.getOwner().getLoadHandler();
        if (loadHandler == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        loadHandler.onLoadError(browser, rframe, CefLoadHandler.ErrorCode.findByCode(errorCode), errorText, failedUrl);
    }

    @Override
    public void DisplayHandler_OnAddressChange(int bid, RObject frame, String url) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        dh.onAddressChange(browser, rframe, url);
    }

    @Override
    public void DisplayHandler_OnTitleChange(int bid, String title) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return;
        }
        dh.onTitleChange(browser, title);
    }

    @Override
    public boolean DisplayHandler_OnTooltip(int bid, String text) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return false;
        }
        return dh.onTooltip(browser, text);
    }

    @Override
    public void DisplayHandler_OnStatusMessage(int bid, String value) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return;
        }
        dh.onStatusMessage(browser, value);
    }

    @Override
    public boolean DisplayHandler_OnConsoleMessage(int bid, int level, String message, String source, int line) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefDisplayHandler dh = browser.getOwner().getDisplayHandler();
        if (dh == null) {
            return false;
        }
        CefLog.Error("onConsoleMessage: used incorrect log level", new Object[0]);
        return dh.onConsoleMessage(browser, CefSettings.LogSeverity.LOGSEVERITY_DEFAULT, message, source, line);
    }

    @Override
    public boolean KeyboardHandler_OnPreKeyEvent(int bid, KeyEvent event) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefKeyboardHandler kh = browser.getOwner().getKeyboardHandler();
        if (kh == null) {
            return false;
        }
        return kh.onPreKeyEvent(browser, ClientHandlersImpl.thrift2jcef(event), new BoolRef());
    }

    private static CefKeyboardHandler.CefKeyEvent thrift2jcef(KeyEvent event) {
        CefKeyboardHandler.CefKeyEvent.EventType type;
        if (event == null) {
            return null;
        }
        if (event.type == null || event.type.isEmpty()) {
            CefLog.Error("Empty key event type: ", new Object[0]);
            return null;
        }
        try {
            type = CefKeyboardHandler.CefKeyEvent.EventType.valueOf(event.type);
        }
        catch (IllegalArgumentException e) {
            CefLog.Error("Unknown key event type: ", e.getMessage());
            return null;
        }
        return new CefKeyboardHandler.CefKeyEvent(type, event.modifiers, event.windows_key_code, event.native_key_code, event.is_system_key, (char)event.character, (char)event.unmodified_character, event.focus_on_editable_field);
    }

    @Override
    public boolean KeyboardHandler_OnKeyEvent(int bid, KeyEvent event) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefKeyboardHandler kh = browser.getOwner().getKeyboardHandler();
        if (kh == null) {
            return false;
        }
        return kh.onKeyEvent(browser, ClientHandlersImpl.thrift2jcef(event));
    }

    @Override
    public void FocusHandler_OnTakeFocus(int bid, boolean next) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefFocusHandler fh = browser.getOwner().getFocusHandler();
        if (fh == null) {
            return;
        }
        fh.onTakeFocus(browser, next);
    }

    @Override
    public boolean FocusHandler_OnSetFocus(int bid, String source) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefFocusHandler fh = browser.getOwner().getFocusHandler();
        if (fh == null) {
            return false;
        }
        CefFocusHandler.FocusSource src = CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION;
        if (source != null && !source.isEmpty()) {
            try {
                src = CefFocusHandler.FocusSource.valueOf(source);
            }
            catch (IllegalArgumentException e) {
                CefLog.Error("FocusHandler_OnSetFocus: ", e.getMessage());
            }
        }
        return fh.onSetFocus(browser, src);
    }

    @Override
    public void FocusHandler_OnGotFocus(int bid) throws TException {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefFocusHandler fh = browser.getOwner().getFocusHandler();
        if (fh == null) {
            return;
        }
        fh.onGotFocus(browser);
    }

    @Override
    public boolean RequestHandler_OnBeforeBrowse(int bid, RObject frame, RObject request, boolean user_gesture, boolean is_redirect) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return false;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myService, request);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        return rh.onBeforeBrowse(browser, rframe, new RemoteRequest(rr), user_gesture, is_redirect);
    }

    @Override
    public RObject RequestHandler_GetResourceRequestHandler(int bid, RObject frame, RObject request, boolean isNavigation, boolean isDownload, String requestInitiator) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return INVALID;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return INVALID;
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myService, request);
        BoolRef disableDefaultHandling = new BoolRef(false);
        CefResourceRequestHandler handler = rh.getResourceRequestHandler(browser, rframe, new RemoteRequest(rr), isNavigation, isDownload, requestInitiator, disableDefaultHandling);
        if (handler == null) {
            return INVALID;
        }
        RemoteResourceRequestHandler resultHandler = RemoteResourceRequestHandler.create(handler);
        return resultHandler.thriftId(disableDefaultHandling.get() ? 1 : 0);
    }

    @Override
    public RObject ResourceRequestHandler_GetCookieAccessFilter(int rrHandler, int bid, RObject frame, RObject request) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return INVALID;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myService, request);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        CefCookieAccessFilter filter = ((CefResourceRequestHandler)rrrh.getDelegate()).getCookieAccessFilter(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rr));
        if (filter == null) {
            return INVALID;
        }
        RemoteCookieAccessFilter resultHandler = RemoteCookieAccessFilter.create(filter);
        return resultHandler.thriftId();
    }

    @Override
    public void ResourceRequestHandler_Dispose(int rrHandler) {
        RemoteResourceRequestHandler.FACTORY.dispose(rrHandler);
    }

    @Override
    public void CookieAccessFilter_Dispose(int filter) {
        RemoteCookieAccessFilter.FACTORY.dispose(filter);
    }

    private static CefCookie cookieFromList(List<String> cookie) {
        try {
            return new CefCookie(cookie.get(0), cookie.get(1), cookie.get(2), cookie.get(3), Boolean.parseBoolean(cookie.get(4)), Boolean.parseBoolean(cookie.get(5)), new Date(Long.parseLong(cookie.get(6))), new Date(Long.parseLong(cookie.get(7))), Boolean.parseBoolean(cookie.get(8)), new Date(Long.parseLong(cookie.get(9))));
        }
        catch (NumberFormatException e) {
            CefLog.Error("Can't parse cookie: err %s, list: '%s'", e.getMessage(), Arrays.toString(cookie.toArray()));
            return null;
        }
    }

    @Override
    public boolean CookieAccessFilter_CanSendCookie(int filter, int bid, RObject frame, RObject request, List<String> cookie) {
        RemoteCookieAccessFilter f = RemoteCookieAccessFilter.FACTORY.get(filter);
        if (f == null) {
            return false;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myService, request);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        boolean result = ((CefCookieAccessFilter)f.getDelegate()).canSendCookie(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rr), ClientHandlersImpl.cookieFromList(cookie));
        return result;
    }

    @Override
    public boolean CookieAccessFilter_CanSaveCookie(int filter, int bid, RObject frame, RObject request, RObject response, List<String> cookie) {
        RemoteCookieAccessFilter f = RemoteCookieAccessFilter.FACTORY.get(filter);
        if (f == null) {
            return false;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myService, request);
        RemoteResponseImpl rresp = new RemoteResponseImpl(this.myService, response);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        boolean result = ((CefCookieAccessFilter)f.getDelegate()).canSaveCookie(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), new RemoteResponse(rresp), ClientHandlersImpl.cookieFromList(cookie));
        return result;
    }

    @Override
    public boolean RequestHandler_OnOpenURLFromTab(int bid, RObject frame, String target_url, boolean user_gesture) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return false;
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        return rh.onOpenURLFromTab(browser, rframe, target_url, user_gesture);
    }

    @Override
    public boolean RequestHandler_GetAuthCredentials(int bid, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, RObject authCallback) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return false;
        }
        RemoteAuthCallback callback = new RemoteAuthCallback(this.myService, authCallback);
        return rh.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback);
    }

    @Override
    public boolean RequestHandler_OnCertificateError(int bid, String cert_error, String request_url, ByteBuffer sslInfo, RObject callback) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return false;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return false;
        }
        RemoteCallback cb = new RemoteCallback(this.myService, callback);
        CefSSLInfo ssl = RemoteSSLInfo.fromBinary(sslInfo);
        CefLoadHandler.ErrorCode err = CefLoadHandler.ErrorCode.ERR_NONE;
        if (cert_error != null && !cert_error.isEmpty()) {
            try {
                err = CefLoadHandler.ErrorCode.valueOf(cert_error);
            }
            catch (IllegalArgumentException e) {
                CefLog.Error("OnCertificateError: ", e.getMessage());
            }
        }
        return rh.onCertificateError(browser, err, request_url, ssl, cb);
    }

    @Override
    public void RequestHandler_OnRenderProcessTerminated(int bid, String status) {
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null) {
            return;
        }
        CefRequestHandler rh = browser.getOwner().getRequestHandler();
        if (rh == null) {
            return;
        }
        CefRequestHandler.TerminationStatus s = CefRequestHandler.TerminationStatus.TS_ABNORMAL_TERMINATION;
        if (status != null && !status.isEmpty()) {
            try {
                s = CefRequestHandler.TerminationStatus.valueOf(status);
            }
            catch (IllegalArgumentException e) {
                CefLog.Error("onRenderProcessTerminated: ", e.getMessage());
            }
        }
        rh.onRenderProcessTerminated(browser, s);
    }

    @Override
    public boolean ResourceRequestHandler_OnBeforeResourceLoad(int rrHandler, int bid, RObject frame, RObject request) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return false;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myService, request);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        boolean result = ((CefResourceRequestHandler)rrrh.getDelegate()).onBeforeResourceLoad(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rr));
        rr.flush();
        return result;
    }

    @Override
    public RObject ResourceRequestHandler_GetResourceHandler(int rrHandler, int bid, RObject frame, RObject request) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return INVALID;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myService, request);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        CefResourceHandler handler = ((CefResourceRequestHandler)rrrh.getDelegate()).getResourceHandler(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rr));
        if (handler == null) {
            return INVALID;
        }
        RemoteResourceHandler result = RemoteResourceHandler.create(handler);
        return result.thriftId();
    }

    @Override
    public boolean ResourceHandler_ProcessRequest(int resourceHandler, RObject request, RObject callback) throws TException {
        RemoteResourceHandler rrh = RemoteResourceHandler.FACTORY.find(resourceHandler);
        if (rrh == null) {
            return false;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myService, request);
        RemoteCallback cb = new RemoteCallback(this.myService, callback);
        boolean result = ((CefResourceHandler)rrh.getDelegate()).processRequest(new RemoteRequest(rr), cb);
        rr.flush();
        return result;
    }

    @Override
    public ResponseHeaders ResourceHandler_GetResponseHeaders(int resourceHandler, RObject response) throws TException {
        RemoteResourceHandler rrh = RemoteResourceHandler.FACTORY.find(resourceHandler);
        if (rrh == null) {
            return null;
        }
        RemoteResponseImpl rr = new RemoteResponseImpl(this.myService, response);
        IntRef respLen = new IntRef();
        StringRef redirectUrlRef = new StringRef();
        ((CefResourceHandler)rrh.getDelegate()).getResponseHeaders(new RemoteResponse(rr), respLen, redirectUrlRef);
        rr.flush();
        ResponseHeaders result = new ResponseHeaders();
        result.setLength(respLen.get());
        if (redirectUrlRef.get() != null) {
            result.setRedirectUrl(redirectUrlRef.get());
        }
        return result;
    }

    @Override
    public ResponseData ResourceHandler_ReadResponse(int resourceHandler, int bytes_to_read, RObject callback) throws TException {
        RemoteResourceHandler rrh;
        if (bytes_to_read <= 0) {
            return new ResponseData();
        }
        if (bytes_to_read > 262144) {
            CefLog.Error("ResourceHandler_ReadResponse: too much bytes to read %d. Need to implement via shared memory.", bytes_to_read);
        }
        if ((rrh = RemoteResourceHandler.FACTORY.find(resourceHandler)) == null) {
            return null;
        }
        RemoteCallback cb = new RemoteCallback(this.myService, callback);
        byte[] buf = new byte[bytes_to_read];
        IntRef bytesRead = new IntRef();
        boolean continueRead = ((CefResourceHandler)rrh.getDelegate()).readResponse(buf, bytes_to_read, bytesRead, cb);
        int read = bytesRead.get();
        ResponseData result = new ResponseData();
        result.setContinueRead(continueRead);
        result.setBytes_read(read);
        result.setData(ByteBuffer.wrap(buf, 0, read));
        return result;
    }

    @Override
    public void ResourceHandler_Cancel(int resourceHandler) throws TException {
        RemoteResourceHandler rrh = RemoteResourceHandler.FACTORY.find(resourceHandler);
        if (rrh == null) {
            return;
        }
        ((CefResourceHandler)rrh.getDelegate()).cancel();
    }

    @Override
    public String ResourceRequestHandler_OnResourceRedirect(int rrHandler, int bid, RObject frame, RObject request, RObject response, String new_url) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return "";
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myService, request);
        RemoteResponseImpl rresp = new RemoteResponseImpl(this.myService, response);
        StringRef sref = new StringRef(new_url);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        ((CefResourceRequestHandler)rrrh.getDelegate()).onResourceRedirect(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), new RemoteResponse(rresp), sref);
        return sref.get();
    }

    @Override
    public boolean ResourceRequestHandler_OnResourceResponse(int rrHandler, int bid, RObject frame, RObject request, RObject response) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return false;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myService, request);
        RemoteResponseImpl rresp = new RemoteResponseImpl(this.myService, response);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        boolean result = ((CefResourceRequestHandler)rrrh.getDelegate()).onResourceResponse(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), new RemoteResponse(rresp));
        rreq.flush();
        return result;
    }

    @Override
    public void ResourceRequestHandler_OnResourceLoadComplete(int rrHandler, int bid, RObject frame, RObject request, RObject response, String status, long receivedContentLength) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myService, request);
        RemoteResponseImpl rresp = new RemoteResponseImpl(this.myService, response);
        CefURLRequest.Status s = CefURLRequest.Status.UR_UNKNOWN;
        if (status != null && !status.isEmpty()) {
            try {
                s = CefURLRequest.Status.valueOf(status);
            }
            catch (IllegalArgumentException e) {
                CefLog.Error("OnResourceLoadComplete: ", e.getMessage());
            }
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        ((CefResourceRequestHandler)rrrh.getDelegate()).onResourceLoadComplete(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), new RemoteResponse(rresp), s, receivedContentLength);
    }

    @Override
    public boolean ResourceRequestHandler_OnProtocolExecution(int rrHandler, int bid, RObject frame, RObject request, boolean allowOsExecution) {
        RemoteResourceRequestHandler rrrh = RemoteResourceRequestHandler.FACTORY.get(rrHandler);
        if (rrrh == null) {
            return false;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myService, request);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        BoolRef br = new BoolRef(allowOsExecution);
        ((CefResourceRequestHandler)rrrh.getDelegate()).onProtocolExecution(this.getRemoteBrowser(bid), rframe, new RemoteRequest(rreq), br);
        return br.get();
    }

    @Override
    public void ResourceHandler_Dispose(int resHandler) throws TException {
        RemoteResourceHandler.FACTORY.dispose(resHandler);
    }

    @Override
    public boolean MessageRouterHandler_onQuery(RObject handler, int bid, RObject frame, long queryId, String request, boolean persistent, RObject queryCallback) throws TException {
        RemoteMessageRouterHandler rmrh = RemoteMessageRouterHandler.FACTORY.get(handler.objId);
        if (rmrh == null) {
            return false;
        }
        RemoteQueryCallback rcb = new RemoteQueryCallback(this.myService, queryCallback);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        return ((CefMessageRouterHandler)rmrh.getDelegate()).onQuery(this.getRemoteBrowser(bid), rframe, queryId, request, persistent, rcb);
    }

    @Override
    public void MessageRouterHandler_onQueryCanceled(RObject handler, int bid, RObject frame, long queryId) throws TException {
        RemoteMessageRouterHandler rmrh = RemoteMessageRouterHandler.FACTORY.get(handler.objId);
        if (rmrh == null) {
            return;
        }
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        ((CefMessageRouterHandler)rmrh.getDelegate()).onQueryCanceled(this.getRemoteBrowser(bid), rframe, queryId);
    }

    @Override
    public void MessageRouterHandler_Dispose(int handler) throws TException {
        RemoteMessageRouterHandler.FACTORY.dispose(handler);
    }

    @Override
    public RObject SchemeHandlerFactory_CreateHandler(int schemeHandlerFactory, int bid, RObject frame, String scheme_name, RObject request) throws TException {
        RemoteSchemeHandlerFactory sf = RemoteSchemeHandlerFactory.FACTORY.get(schemeHandlerFactory);
        if (sf == null) {
            return INVALID;
        }
        RemoteRequestImpl rreq = new RemoteRequestImpl(this.myService, request);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        CefResourceHandler handler = ((CefSchemeHandlerFactory)sf.getDelegate()).create(this.getRemoteBrowser(bid), rframe, scheme_name, new RemoteRequest(rreq));
        if (handler == null) {
            return INVALID;
        }
        RemoteResourceHandler result = RemoteResourceHandler.create(handler);
        return result.thriftId();
    }

    @Override
    public void SchemeHandlerFactory_Dispose(int schemeHandlerFactory) throws TException {
        RemoteSchemeHandlerFactory.FACTORY.dispose(schemeHandlerFactory);
    }

    @Override
    public void CompletionCallback_OnComplete(int completionCallback) throws TException {
        RemoteCompletionCallback cc = RemoteCompletionCallback.FACTORY.get(completionCallback);
        if (cc == null) {
            return;
        }
        ((CefCompletionCallback)cc.getDelegate()).onComplete();
        RemoteCompletionCallback.FACTORY.dispose(completionCallback);
    }

    @Override
    public RObject RequestContextHandler_GetResourceRequestHandler(int handlerId, int bid, RObject frame, RObject request, boolean isNavigation, boolean isDownload, String requestInitiator) throws TException {
        RemoteRequestContextHandler rhandler = RemoteRequestContextHandler.FACTORY.get(handlerId);
        RemoteBrowser browser = this.getRemoteBrowser(bid);
        if (browser == null || rhandler == null) {
            return INVALID;
        }
        RemoteRequestImpl rr = new RemoteRequestImpl(this.myService, request);
        RemoteFrame rframe = new RemoteFrame(this.myService, frame);
        BoolRef disableDefaultHandling = new BoolRef(false);
        CefResourceRequestHandler handler = ((CefRequestContextHandler)rhandler.getDelegate()).getResourceRequestHandler(browser, rframe, new RemoteRequest(rr), isNavigation, isDownload, requestInitiator, disableDefaultHandling);
        if (handler == null) {
            return INVALID;
        }
        RemoteResourceRequestHandler resultHandler = RemoteResourceRequestHandler.create(handler);
        return resultHandler.thriftId(disableDefaultHandling.get() ? 1 : 0);
    }

    @Override
    public boolean CookieVisitor_Visit(int visitor, Cookie cookie, int count, int total) throws TException {
        RemoteCookieVisitor rvisitor = RemoteCookieVisitor.FACTORY.get(visitor);
        if (rvisitor == null) {
            return false;
        }
        BoolRef delete = new BoolRef(false);
        boolean continueTraverse = ((CefCookieVisitor)rvisitor.getDelegate()).visit(RemoteCookieManager.toCefCookie(cookie), count, total, delete);
        if (delete.get()) {
            CefLog.Error("Can't delete cookie %s via CefCookieVisitor, please use CefCookieManager.deleteCookie. TODO: implement.", new Object[0]);
        }
        if (count == total || !continueTraverse) {
            CefLog.Debug("Last cookie (%d) visited, dispose RemoteCookieVisitor %d.", total, visitor);
            RemoteCookieVisitor.FACTORY.dispose(visitor);
        }
        return continueTraverse;
    }

    @Override
    public void CookieVisitor_Dispose(int visitor) throws TException {
        CefLog.Debug("Dispose RemoteCookieVisitor %d (by server request).", visitor);
        RemoteCookieVisitor.FACTORY.dispose(visitor);
    }
}

